/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.swing.HtmlPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Help
implements Command {
    private static transient Logger log = LoggingManager.getLoggerFor((String)"jmeter.gui");
    private static Set commands = new HashSet();
    public static final String HELP = "help";
    private static String helpPage;
    private static JDialog helpWindow;
    private static HtmlPane helpDoc;
    private static JScrollPane scroller;
    private static String currentPage;

    public void doAction(ActionEvent e) {
        if (helpWindow == null) {
            helpWindow = new JDialog(GuiPackage.getInstance().getMainFrame(), JMeterUtils.getResString(HELP), false);
            helpWindow.getContentPane().setLayout(new GridLayout(1, 1));
            ComponentUtil.centerComponentInWindow((Component)helpWindow, (int)60);
        }
        if (e.getSource() instanceof String[]) {
            String[] source = (String[])e.getSource();
            this.resetPage(source[0]);
            helpDoc.scrollToReference(source[1]);
        } else {
            this.resetPage(helpPage);
            helpDoc.scrollToReference(GuiPackage.getInstance().getTreeListener().getCurrentNode().getStaticLabel().replace(' ', '_'));
        }
        helpWindow.getContentPane().removeAll();
        helpWindow.getContentPane().add(scroller);
        helpWindow.show();
    }

    private void resetPage(String source) {
        if (!currentPage.equals(source)) {
            try {
                helpDoc.setPage(source);
                currentPage = source;
            }
            catch (IOException err) {
                log.error("Couldn't load page: " + source, (Throwable)err);
            }
        }
    }

    public Set getActionNames() {
        return commands;
    }

    static {
        HELP = HELP;
        helpPage = "file:///" + JMeterUtils.getJMeterHome() + "/docs/usermanual/component_reference.html";
        commands.add(HELP);
        helpDoc = new HtmlPane();
        scroller = new JScrollPane(helpDoc);
        helpDoc.setEditable(false);
        try {
            helpDoc.setPage(helpPage);
            currentPage = helpPage;
        }
        catch (IOException err) {
            log.error("Couldn't load " + helpPage, (Throwable)err);
        }
    }
}

