/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import org.apache.jmeter.engine.ClientJMeterEngine;
import org.apache.jmeter.engine.JMeterEngine;
import org.apache.jmeter.engine.JMeterEngineException;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.AbstractAction;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class RemoteStart
extends AbstractAction {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    private Map remoteEngines = new HashMap();
    private static Set commands = new HashSet();

    public void doAction(ActionEvent e) {
        String name = ((Component)e.getSource()).getName();
        String action = e.getActionCommand();
        if (action.equals("remote_stop")) {
            GuiPackage.getInstance().getMainFrame().showStoppingMessage(name);
            JMeterEngine engine = (JMeterEngine)this.remoteEngines.get(name);
            engine.stopTest();
        } else if (action.equals("remote_start")) {
            JMeterEngine engine = (JMeterEngine)this.remoteEngines.get(name);
            if (engine == null) {
                try {
                    engine = new ClientJMeterEngine(name);
                    this.remoteEngines.put(name, engine);
                }
                catch (Exception ex) {
                    log.error("", (Throwable)ex);
                    JMeterUtils.reportErrorToUser("Bad call to remote host");
                    return;
                }
            } else {
                engine.reset();
            }
            this.startEngine(engine, name);
        }
    }

    public Set getActionNames() {
        return commands;
    }

    private void startEngine(JMeterEngine engine, String host) {
        GuiPackage gui = GuiPackage.getInstance();
        HashTree testTree = gui.getTreeModel().getTestPlan();
        this.convertSubTree(testTree);
        testTree.add(testTree.getArray()[0], (Object)gui.getMainFrame());
        engine.configure(testTree);
        try {
            engine.runTest();
        }
        catch (JMeterEngineException e) {
            JOptionPane.showMessageDialog(gui.getMainFrame(), e.getMessage(), JMeterUtils.getResString("Error Occurred"), 0);
        }
    }

    static {
        commands.add("remote_start");
        commands.add("remote_stop");
    }
}

