/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.tree;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.gui.TestPlanGui;
import org.apache.jmeter.control.gui.WorkBenchGui;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.WorkBench;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;

public class JMeterTreeModel
extends DefaultTreeModel {
    public JMeterTreeModel() {
        super(new JMeterTreeNode(new NamePanel(), null));
        this.insertNodeInto(new JMeterTreeNode(new TestPlanGui(), this), (JMeterTreeNode)this.getRoot(), 0);
        this.insertNodeInto(new JMeterTreeNode(new WorkBenchGui(), this), (JMeterTreeNode)this.getRoot(), 1);
    }

    public List getNodesOfType(Class type) {
        LinkedList nodeList = new LinkedList();
        this.traverseAndFind(type, (JMeterTreeNode)this.getRoot(), nodeList);
        return nodeList;
    }

    public boolean addSubTree(HashTree subTree, JMeterTreeNode current) throws IllegalUserActionException {
        boolean ret = false;
        Iterator iter = subTree.list().iterator();
        while (iter.hasNext()) {
            JMeterGUIComponent item = (JMeterGUIComponent)iter.next();
            if (item instanceof TestPlanGui) {
                current = (JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0);
                current.configure(item.createTestElement());
                this.addSubTree(subTree.getTree((Object)item), current);
                ret = true;
                continue;
            }
            this.addSubTree(subTree.getTree((Object)item), this.addComponent(item, current));
        }
        return ret;
    }

    public JMeterTreeNode addComponent(Object component, JMeterTreeNode node) throws IllegalUserActionException {
        if (node.getUserObject() instanceof AbstractConfigGui) {
            throw new IllegalUserActionException("This node cannot hold sub-elements");
        }
        JMeterTreeNode newNode = new JMeterTreeNode((JMeterGUIComponent)component, this);
        this.insertNodeInto(newNode, node, node.getChildCount());
        return newNode;
    }

    public void removeNodeFromParent(JMeterTreeNode node) {
        if (!(node.getUserObject() instanceof TestPlan) && !(node.getUserObject() instanceof WorkBench)) {
            super.removeNodeFromParent(node);
        }
    }

    private void traverseAndFind(Class type, JMeterTreeNode node, List nodeList) {
        if (type.isInstance(node.getUserObject())) {
            nodeList.add(node);
        }
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumeration.nextElement();
            this.traverseAndFind(type, child, nodeList);
        }
    }

    public HashTree getCurrentSubTree(JMeterTreeNode node) {
        ListedHashTree hashTree = new ListedHashTree((Object)node);
        Enumeration<TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            JMeterTreeNode child = (JMeterTreeNode)enumeration.nextElement();
            hashTree.add((Object)node, this.getCurrentSubTree(child));
        }
        return hashTree;
    }

    public HashTree getTestPlan() {
        return this.getCurrentSubTree((JMeterTreeNode)((JMeterTreeNode)this.getRoot()).getChildAt(0));
    }

    public void clearTestPlan() {
        super.removeNodeFromParent((JMeterTreeNode)this.getChild(this.getRoot(), 0));
        this.insertNodeInto(new JMeterTreeNode(new TestPlanGui(), this), (JMeterTreeNode)this.getRoot(), 0);
        super.removeNodeFromParent((JMeterTreeNode)this.getChild(this.getRoot(), 1));
        this.insertNodeInto(new JMeterTreeNode(new WorkBenchGui(), this), (JMeterTreeNode)this.getRoot(), 1);
    }
}

