/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.FileDialoger;
import org.apache.jmeter.util.JMeterUtils;

public class FilePanel
extends JPanel
implements ActionListener {
    JTextField filename = new JTextField(20);
    JLabel label = new JLabel(JMeterUtils.getResString("file_visualizer_filename"));
    JButton browse = new JButton(JMeterUtils.getResString("browse"));
    List listeners = new LinkedList();
    String title;

    public FilePanel() {
        this.title = "";
        this.init();
    }

    public FilePanel(String title) {
        this.title = title;
        this.init();
    }

    public FilePanel(ChangeListener l, String title) {
        this.title = title;
        this.init();
        this.listeners.add(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    private void init() {
        this.setLayout(new FlowLayout(0));
        this.setBorder(BorderFactory.createTitledBorder(this.title));
        this.add(this.label);
        this.add(this.filename);
        this.filename.addActionListener(this);
        this.add(this.browse);
        this.browse.setActionCommand("browse");
        this.browse.addActionListener(this);
    }

    public String getFilename() {
        return this.filename.getText();
    }

    public void setFilename(String f) {
        this.filename.setText(f);
    }

    private void fireFileChanged() {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(new ChangeEvent(this));
        }
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("browse")) {
            JFileChooser chooser = FileDialoger.promptToOpenFile(new String[]{".jtl"});
            if (chooser != null && chooser.getSelectedFile() != null) {
                this.filename.setText(chooser.getSelectedFile().getPath());
                this.fireFileChanged();
            }
        } else {
            this.fireFileChanged();
        }
    }
}

