/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.util.SSLManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterMenuBar
extends JMenuBar
implements LocaleChangeListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    JMenu fileMenu;
    JMenuItem file_save_all;
    JMenuItem file_load;
    JMenuItem file_exit;
    JMenuItem file_new;
    JMenu editMenu;
    JMenu edit_add;
    JMenu edit_add_submenu;
    JMenuItem edit_remove;
    JMenu runMenu;
    JMenuItem run_start;
    JMenu remote_start;
    Collection remote_engine_start = new LinkedList();
    JMenuItem run_stop;
    JMenu remote_stop;
    Collection remote_engine_stop = new LinkedList();
    JMenuItem run_clear;
    JMenuItem run_clearAll;
    JMenu reportMenu;
    JMenuItem analyze;
    JMenu optionsMenu;
    JMenu lafMenu;
    JMenuItem sslManager;
    JMenu helpMenu;
    JMenuItem help_about;
    String[] remoteHosts = JOrphanUtils.split((String)JMeterUtils.getPropDefault("remote_hosts", ""), (String)",");

    public JMeterMenuBar() {
        if (this.remoteHosts.length == 1 && this.remoteHosts[0].equals("")) {
            this.remoteHosts = new String[0];
        }
        this.getRemoteItems();
        this.createMenuBar();
    }

    public void setFileSaveEnabled(boolean enabled) {
        this.file_save_all.setEnabled(enabled);
    }

    public void setFileLoadEnabled(boolean enabled) {
        if (this.file_load != null) {
            this.file_load.setEnabled(enabled);
        }
    }

    public void setEditEnabled(boolean enabled) {
        if (this.editMenu != null) {
            this.editMenu.setEnabled(enabled);
        }
    }

    public void setEditAddMenu(JMenu menu) {
        if (this.edit_add != null) {
            this.editMenu.remove(this.edit_add);
        }
        this.edit_add = menu;
        this.editMenu.insert(this.edit_add, 0);
    }

    public void setEditMenu(JPopupMenu menu) {
        if (menu != null) {
            this.editMenu.removeAll();
            Component[] comps = menu.getComponents();
            int i = 0;
            while (i < comps.length) {
                this.editMenu.add(comps[i]);
                ++i;
            }
            this.editMenu.setEnabled(true);
        } else {
            this.editMenu.setEnabled(false);
        }
    }

    public void setEditAddEnabled(boolean enabled) {
        if (this.edit_add != null) {
            this.edit_add.setEnabled(enabled);
        }
        if (enabled) {
            this.setEditEnabled(true);
        } else if (!this.edit_remove.isEnabled()) {
            this.editMenu.setEnabled(false);
        }
    }

    public void setEditRemoveEnabled(boolean enabled) {
        this.edit_remove.setEnabled(enabled);
        if (enabled) {
            this.setEditEnabled(true);
        } else if (!this.edit_add.isEnabled()) {
            this.editMenu.setEnabled(false);
        }
    }

    public void createMenuBar() {
        this.createFileMenu();
        this.makeEditMenu();
        this.makeRunMenu();
        this.makeOptionsMenu();
        this.makeHelpMenu();
        this.add(this.fileMenu);
        this.add(this.editMenu);
        this.add(this.runMenu);
        this.add(this.optionsMenu);
        this.add(this.helpMenu);
    }

    private void makeHelpMenu() {
        this.helpMenu = new JMenu(JMeterUtils.getResString("help"));
        this.helpMenu.setMnemonic('H');
        JMenuItem contextHelp = new JMenuItem(JMeterUtils.getResString("help"), 72);
        contextHelp.setActionCommand("help");
        contextHelp.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        contextHelp.addActionListener(ActionRouter.getInstance());
        this.help_about = new JMenuItem(JMeterUtils.getResString("about"), 65);
        this.help_about.setActionCommand("about");
        this.help_about.addActionListener(ActionRouter.getInstance());
        this.helpMenu.add(contextHelp);
        this.helpMenu.add(this.help_about);
    }

    private void makeOptionsMenu() {
        this.optionsMenu = new JMenu(JMeterUtils.getResString("option"));
        JMenuItem functionHelper = new JMenuItem(JMeterUtils.getResString("function_dialog_menu_item"), 70);
        functionHelper.addActionListener(ActionRouter.getInstance());
        functionHelper.setActionCommand("functions");
        functionHelper.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.lafMenu = new JMenu(JMeterUtils.getResString("appearance"));
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lafs.length) {
            JMenuItem laf = new JMenuItem(lafs[i].getName());
            laf.addActionListener(ActionRouter.getInstance());
            laf.setActionCommand("laf:" + lafs[i].getClassName());
            this.lafMenu.setMnemonic('L');
            this.lafMenu.add(laf);
            ++i;
        }
        this.optionsMenu.setMnemonic('O');
        this.optionsMenu.add(functionHelper);
        this.optionsMenu.add(this.lafMenu);
        if (SSLManager.isSSLSupported()) {
            this.sslManager = new JMenuItem(JMeterUtils.getResString("sslManager"));
            this.sslManager.addActionListener(ActionRouter.getInstance());
            this.sslManager.setActionCommand("sslManager");
            this.sslManager.setMnemonic('S');
            this.sslManager.setAccelerator(KeyStroke.getKeyStroke(77, 2));
            this.optionsMenu.add(this.sslManager);
        }
        this.optionsMenu.add(this.makeLanguageMenu());
    }

    private JMenu makeLanguageMenu() {
        JMenu languageMenu = new JMenu(JMeterUtils.getResString("choose_language"));
        languageMenu.setMnemonic('C');
        JMenuItem english = new JMenuItem(JMeterUtils.getResString("en"), 69);
        english.addActionListener(ActionRouter.getInstance());
        english.setActionCommand("change_language");
        english.setName("en");
        languageMenu.add(english);
        JMenuItem japanese = new JMenuItem(JMeterUtils.getResString("jp"), 74);
        japanese.addActionListener(ActionRouter.getInstance());
        japanese.setActionCommand("change_language");
        japanese.setName("ja");
        languageMenu.add(japanese);
        JMenuItem norway = new JMenuItem(JMeterUtils.getResString("no"), 78);
        norway.addActionListener(ActionRouter.getInstance());
        norway.setActionCommand("change_language");
        norway.setName("no");
        languageMenu.add(norway);
        JMenuItem german = new JMenuItem(JMeterUtils.getResString("de"), 71);
        german.addActionListener(ActionRouter.getInstance());
        german.setActionCommand("change_language");
        german.setName("de");
        languageMenu.add(german);
        return languageMenu;
    }

    private void makeRunMenu() {
        this.runMenu = new JMenu(JMeterUtils.getResString("run"));
        this.runMenu.setMnemonic('R');
        this.run_start = new JMenuItem(JMeterUtils.getResString("start"), 83);
        this.run_start.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.run_start.addActionListener(ActionRouter.getInstance());
        this.run_start.setActionCommand("start");
        this.run_stop = new JMenuItem(JMeterUtils.getResString("stop"), 84);
        this.run_stop.setAccelerator(KeyStroke.getKeyStroke(46, 2));
        this.run_stop.setEnabled(false);
        this.run_stop.addActionListener(ActionRouter.getInstance());
        this.run_stop.setActionCommand("stop");
        this.run_clear = new JMenuItem(JMeterUtils.getResString("clear"), 67);
        this.run_clear.addActionListener(ActionRouter.getInstance());
        this.run_clear.setActionCommand("action.clear");
        this.run_clearAll = new JMenuItem(JMeterUtils.getResString("clear_all"), 97);
        this.run_clearAll.addActionListener(ActionRouter.getInstance());
        this.run_clearAll.setActionCommand("action.clear_all");
        this.runMenu.add(this.run_start);
        if (this.remote_start != null) {
            this.runMenu.add(this.remote_start);
        }
        this.runMenu.add(this.run_stop);
        if (this.remote_stop != null) {
            this.runMenu.add(this.remote_stop);
        }
        this.runMenu.addSeparator();
        this.runMenu.add(this.run_clear);
        this.runMenu.add(this.run_clearAll);
    }

    private void makeEditMenu() {
        this.editMenu = new JMenu(JMeterUtils.getResString("edit"));
        this.editMenu.setEnabled(false);
    }

    private void createFileMenu() {
        this.fileMenu = new JMenu(JMeterUtils.getResString("file"));
        this.fileMenu.setMnemonic('F');
        JMenuItem file_save = new JMenuItem(JMeterUtils.getResString("save_all"), 83);
        file_save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        file_save.setActionCommand("save");
        file_save.addActionListener(ActionRouter.getInstance());
        file_save.setEnabled(true);
        this.file_save_all = new JMenuItem(JMeterUtils.getResString("save_all_as"), 65);
        this.file_save_all.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.file_save_all.setActionCommand("save_all");
        this.file_save_all.addActionListener(ActionRouter.getInstance());
        this.file_save_all.setEnabled(true);
        this.file_load = new JMenuItem(JMeterUtils.getResString("open"), 79);
        this.file_load.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.file_load.addActionListener(ActionRouter.getInstance());
        this.file_load.setEnabled(false);
        this.file_load.setActionCommand("open");
        this.file_new = new JMenuItem(JMeterUtils.getResString("new"), 78);
        this.file_new.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.file_new.setActionCommand("new");
        this.file_new.addActionListener(ActionRouter.getInstance());
        this.file_exit = new JMenuItem(JMeterUtils.getResString("exit"), 88);
        this.file_exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.file_exit.setActionCommand("exit");
        this.file_exit.addActionListener(ActionRouter.getInstance());
        this.fileMenu.add(this.file_new);
        this.fileMenu.add(this.file_load);
        this.fileMenu.add(file_save);
        this.fileMenu.add(this.file_save_all);
        this.fileMenu.addSeparator();
        this.fileMenu.add(this.file_exit);
    }

    public void setRunning(boolean running, String host) {
        Iterator iter = this.remote_engine_start.iterator();
        Iterator iter2 = this.remote_engine_stop.iterator();
        while (iter.hasNext() && iter2.hasNext()) {
            JMenuItem start = (JMenuItem)iter.next();
            JMenuItem stop = (JMenuItem)iter2.next();
            log.info("host = " + host + " start = " + start.getText());
            if (start.getText().equals(host)) {
                start.setEnabled(!running);
            }
            if (!stop.getText().equals(host)) continue;
            stop.setEnabled(running);
        }
    }

    public void setEnabled(boolean enable) {
        this.run_start.setEnabled(!enable);
        this.run_stop.setEnabled(enable);
    }

    private void getRemoteItems() {
        if (this.remoteHosts.length > 0) {
            this.remote_start = new JMenu(JMeterUtils.getResString("remote_start"));
            this.remote_stop = new JMenu(JMeterUtils.getResString("remote_stop"));
            int i = 0;
            while (i < this.remoteHosts.length) {
                JMenuItem item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_start");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ActionRouter.getInstance());
                this.remote_engine_start.add(item);
                this.remote_start.add(item);
                item = new JMenuItem(this.remoteHosts[i]);
                item.setActionCommand("remote_stop");
                item.setName(this.remoteHosts[i]);
                item.addActionListener(ActionRouter.getInstance());
                item.setEnabled(false);
                this.remote_engine_stop.add(item);
                this.remote_stop.add(item);
                ++i;
            }
        }
    }

    public void localeChanged(LocaleChangeEvent event) {
        this.updateMenuElement(this.fileMenu);
        this.updateMenuElement(this.editMenu);
        this.updateMenuElement(this.runMenu);
        this.updateMenuElement(this.optionsMenu);
        this.updateMenuElement(this.helpMenu);
    }

    private void updateMenuElement(MenuElement menu) {
        Component component = menu.getComponent();
        if (component.getName() != null) {
            if (component instanceof JMenu) {
                ((JMenu)component).setText(JMeterUtils.getResString(component.getName()));
            } else {
                ((JMenuItem)component).setText(JMeterUtils.getResString(component.getName()));
            }
        }
        MenuElement[] subelements = menu.getSubElements();
        int i = 0;
        while (i < subelements.length) {
            this.updateMenuElement(subelements[i]);
            ++i;
        }
    }
}

