/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TextAreaTableCellEditor
implements TableCellEditor,
FocusListener {
    JScrollPane pane;
    JTextArea editor;
    String value = "";
    LinkedList listeners = new LinkedList();
    int row;
    int col;

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.editor = new JTextArea(value.toString());
        this.editor.addFocusListener(this);
        this.editor.setEnabled(true);
        this.editor.setRows(this.editor.getRows());
        this.editor.revalidate();
        this.pane = new JScrollPane(this.editor, 21, 31);
        this.pane.validate();
        this.row = row;
        this.col = this.col;
        return this.pane;
    }

    public int getColumn() {
        return this.col;
    }

    public int getRow() {
        return this.row;
    }

    public void focusLost(FocusEvent fe) {
        this.stopCellEditing();
    }

    public void focusGained(FocusEvent fe) {
    }

    public TextAreaTableCellEditor() {
        this.editor = new JTextArea();
        this.editor.setRows(3);
    }

    public Component getComponent() {
        return this.editor;
    }

    public Object getCellEditorValue() {
        return this.editor.getText();
    }

    public void cancelCellEditing() {
        Iterator iter = ((List)this.listeners.clone()).iterator();
        while (iter.hasNext()) {
            ((CellEditorListener)iter.next()).editingCanceled(new ChangeEvent(this));
        }
    }

    public boolean stopCellEditing() {
        Iterator iter = ((List)this.listeners.clone()).iterator();
        while (iter.hasNext()) {
            ((CellEditorListener)iter.next()).editingStopped(new ChangeEvent(this));
        }
        return true;
    }

    public void addCellEditorListener(CellEditorListener lis) {
        this.listeners.add(lis);
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent ? ((MouseEvent)anEvent).getClickCount() > 0 : anEvent instanceof FocusEvent && ((FocusEvent)anEvent).getID() == 1004) {
            return true;
        }
        return true;
    }

    public void removeCellEditorListener(CellEditorListener lis) {
        this.listeners.remove(lis);
    }

    public boolean shouldSelectCell(EventObject eo) {
        return true;
    }
}

