/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public class JMeterTest
extends TestCase {
    private static Logger log = LoggingManager.getLoggerFor((String)"jmeter.test");
    static /* synthetic */ Class class$org$apache$jmeter$gui$JMeterGUIComponent;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$TestElement;
    static /* synthetic */ Class class$java$lang$Object;

    public JMeterTest(String name) {
        super(name);
    }

    public void testGUIComponents() throws Exception {
        Iterator iter = this.getObjects(class$org$apache$jmeter$gui$JMeterGUIComponent == null ? (class$org$apache$jmeter$gui$JMeterGUIComponent = JMeterTest.class$("org.apache.jmeter.gui.JMeterGUIComponent")) : class$org$apache$jmeter$gui$JMeterGUIComponent).iterator();
        while (iter.hasNext()) {
            JMeterGUIComponent item = (JMeterGUIComponent)iter.next();
            if (item instanceof JMeterTreeNode) continue;
            JMeterTest.assertEquals((String)("Failed on " + item.getClass().getName()), (Object)item.getStaticLabel(), (Object)item.getName());
            TestElement el = item.createTestElement();
            Assert.assertEquals((String)("GUI-CLASS: Failed on " + item.getClass().getName()), (Object)item.getClass().getName(), (Object)el.getProperty("TestElement.gui_class"));
            Assert.assertEquals((String)("NAME: Failed on " + item.getClass().getName()), (Object)item.getName(), (Object)el.getProperty("TestElement.name"));
            Assert.assertEquals((String)("TEST-CLASS: Failed on " + item.getClass().getName()), (Object)el.getClass().getName(), (Object)el.getProperty("TestElement.test_class"));
            el.setProperty("TestElement.name", "hey, new name!:");
            el.setProperty("NOT", "Shouldn't be here");
            TestElement el2 = item.createTestElement();
            Assert.assertNull((String)("GUI-CLASS: Failed on " + item.getClass().getName()), (Object)el2.getProperty("NOT"));
            el = SaveService.createTestElement(SaveService.getConfigForTestElement(null, el));
            item.configure(el);
            Assert.assertEquals((String)("CONFIGURE-TEST: Failed on " + item.getClass().getName()), (Object)el.getProperty("TestElement.name"), (Object)item.getName());
        }
    }

    public void testSerializableElements() throws Exception {
        Iterator iter = this.getObjects(class$java$io$Serializable == null ? (class$java$io$Serializable = JMeterTest.class$("java.io.Serializable")) : class$java$io$Serializable).iterator();
        while (iter.hasNext()) {
            Serializable serObj = (Serializable)iter.next();
            if (serObj.getClass().getName().endsWith("_Stub")) continue;
            try {
                log.debug("serializing class: " + serObj.getClass().getName());
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(bytes);
                out.writeObject(serObj);
                out.close();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
                Object readObject = in.readObject();
                in.close();
                Assert.assertEquals((String)("deserializing class: " + serObj.getClass().getName()), serObj.getClass(), readObject.getClass());
            }
            catch (Exception e) {
                log.error("Trying to serialize object: " + serObj.getClass().getName(), (Throwable)e);
                throw e;
            }
        }
    }

    public void testTestElements() throws Exception {
        Iterator iter = this.getObjects(class$org$apache$jmeter$testelement$TestElement == null ? (class$org$apache$jmeter$testelement$TestElement = JMeterTest.class$("org.apache.jmeter.testelement.TestElement")) : class$org$apache$jmeter$testelement$TestElement).iterator();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            this.checkElementCloning(item);
            Assert.assertTrue((String)(item.getClass().getName() + " must implement Serializable"), (boolean)(item instanceof Serializable));
        }
    }

    protected Collection getObjects(Class extendsClass) throws Exception {
        Iterator classes = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{extendsClass}).iterator();
        LinkedList objects = new LinkedList();
        while (classes.hasNext()) {
            Class<?> c = Class.forName((String)classes.next());
            try {
                try {
                    objects.add(c.newInstance());
                }
                catch (InstantiationException e) {
                    try {
                        objects.add(c.getConstructor(class$java$lang$Object == null ? JMeterTest.class$("java.lang.Object") : class$java$lang$Object).newInstance(new Object[]{this}));
                    }
                    catch (NoSuchMethodException f) {}
                }
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return objects;
    }

    private void cloneTesting(TestElement item, TestElement clonedItem) {
        JMeterTest.assertTrue((item != clonedItem ? 1 : 0) != 0);
        JMeterTest.assertEquals((String)("CLONE-SAME-CLASS: testing " + item.getClass().getName()), (Object)item.getClass().getName(), (Object)clonedItem.getClass().getName());
    }

    private void checkElementCloning(TestElement item) {
        TestElement clonedItem = (TestElement)item.clone();
        this.cloneTesting(item, clonedItem);
        Iterator iter2 = item.getPropertyNames().iterator();
        while (iter2.hasNext()) {
            Object item2 = iter2.next();
            if (!(item2 instanceof TestElement)) continue;
            this.checkElementCloning((TestElement)item2);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

