/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.reporters;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.Remoteable;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveService;
import org.apache.jmeter.testelement.TestListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.io.TextFile;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public class ResultCollector
extends AbstractListenerElement
implements SampleListener,
Clearable,
Serializable,
TestListener,
Remoteable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");
    private static final String COLLECTED = "collected";
    public static final String FILENAME = "filename";
    private static boolean functionalMode;
    public static final String ERROR_LOGGING = "ResultCollector.error_logging";
    private int current = -1;
    private transient DefaultConfigurationSerializer serializer;
    private boolean inLoading = false;
    private transient PrintWriter out;
    private boolean inTest = false;
    private static Map files;
    private Set hosts = new HashSet();

    public ResultCollector() {
        this.serializer = new DefaultConfigurationSerializer();
        this.setErrorLogging(false);
    }

    private void setFilenameProperty(String f) {
        this.setProperty(FILENAME, f);
    }

    public String getFilename() {
        return this.getPropertyAsString(FILENAME);
    }

    public boolean isErrorLogging() {
        return this.getPropertyAsBoolean(ERROR_LOGGING);
    }

    public void setErrorLogging(boolean errorLogging) {
        this.setProperty(ERROR_LOGGING, new Boolean(errorLogging));
    }

    public void setFilename(String f) throws IOException, IllegalUserActionException {
        if (this.inTest) {
            throw new IllegalUserActionException(JMeterUtils.getResString("busy_testing"));
        }
        try {
            this.setFilenameProperty(f);
            this.loadExistingFile();
        }
        catch (SAXException e) {
            log.error("", (Throwable)e);
            throw new IOException("File " + f + " was improperly formatted");
        }
        catch (ConfigurationException e) {
            throw new IOException("File " + f + " was improperly formatted");
        }
    }

    public void testEnded(String host) {
        this.hosts.remove(host);
        if (this.hosts.size() == 0) {
            this.finalizeFileOutput();
            this.inTest = false;
        }
    }

    public void testStarted(String host) {
        this.hosts.add(host);
        try {
            this.initializeFileOutput();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        this.inTest = true;
    }

    public void testEnded() {
        this.testEnded("local");
    }

    public void testStarted() {
        this.testStarted("local");
    }

    public void loadExistingFile() throws SAXException, IOException, ConfigurationException {
        this.inLoading = true;
        if (new File(this.getFilename()).exists()) {
            this.clear();
            try {
                Configuration savedSamples = this.getConfiguration(this.getFilename());
                this.readSamples(savedSamples);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
        }
        this.inLoading = false;
    }

    private static void writeFileStart(PrintWriter writer) {
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        writer.println("<testResults>");
    }

    private void writeFileEnd() {
        this.out.print("</testResults>");
    }

    private static synchronized PrintWriter getFileWriter(String filename) throws IOException {
        if (filename == null || filename.length() == 0) {
            return null;
        }
        PrintWriter writer = (PrintWriter)files.get(filename);
        boolean trimmed = true;
        if (writer == null) {
            trimmed = ResultCollector.trimLastLine(filename);
            writer = new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filename, trimmed)), "UTF-8"));
            files.put(filename, writer);
        }
        if (!trimmed) {
            ResultCollector.writeFileStart(writer);
        }
        return writer;
    }

    private static boolean trimLastLine(String filename) {
        try {
            TextFile text = new TextFile(filename);
            if (!text.exists()) {
                return false;
            }
            String xml = text.getText();
            xml = xml.substring(0, xml.indexOf("</testResults>"));
            text.setText(xml);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void enableFunctionalMode(boolean mode) {
        functionalMode = mode;
    }

    public boolean getFunctionalMode() {
        return functionalMode || this.isErrorLogging();
    }

    private String getSerializedSampleResult(SampleResult result) throws SAXException, IOException, ConfigurationException {
        ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
        this.serializer.serialize((OutputStream)tempOut, SaveService.getConfiguration(result, this.getFunctionalMode()));
        String serVer = tempOut.toString();
        return serVer.substring(serVer.indexOf(System.getProperty("line.separator")));
    }

    private void readSamples(Configuration testResults) throws IOException, SAXException, ConfigurationException {
        Configuration[] samples = testResults.getChildren();
        int i = 0;
        while (i < samples.length) {
            SampleResult result = SaveService.getSampleResult(samples[i]);
            this.sendToVisualizer(result);
            this.recordResult(result);
            ++i;
        }
    }

    private Configuration getConfiguration(String filename) throws SAXException, IOException, ConfigurationException {
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        return builder.buildFromFile(filename);
    }

    public void clear() {
        this.current = -1;
        if (this.getVisualizer() != null && this.getVisualizer() instanceof Clearable) {
            ((Clearable)((Object)this.getVisualizer())).clear();
        }
        this.finalizeFileOutput();
    }

    public void setListener(Object l) {
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public void sampleOccurred(SampleEvent e) {
        if (!this.isErrorLogging() || !e.getResult().isSuccessful()) {
            this.sendToVisualizer(e.getResult());
            try {
                this.recordResult(e.getResult());
            }
            catch (Exception err) {
                log.error("", (Throwable)err);
            }
        }
    }

    protected void sendToVisualizer(SampleResult r) {
        if (this.getVisualizer() != null) {
            this.getVisualizer().add(r);
        }
    }

    private void recordResult(SampleResult result) throws SAXException, IOException, ConfigurationException {
        if (this.out != null && !this.isResultMarked(result)) {
            this.out.print(this.getSerializedSampleResult(result));
        }
    }

    private synchronized boolean isResultMarked(SampleResult res) {
        boolean marked = res.isMarked(this.getFilename());
        if (!marked) {
            res.setMarked(this.getFilename());
        }
        return marked;
    }

    private void initializeFileOutput() throws IOException, ConfigurationException, SAXException {
        if (this.out == null && this.getFilename() != null && this.out == null) {
            try {
                this.out = ResultCollector.getFileWriter(this.getFilename());
            }
            catch (FileNotFoundException e) {
                this.out = null;
            }
        }
    }

    private synchronized void finalizeFileOutput() {
        if (this.out != null) {
            this.writeFileEnd();
            this.out.close();
            files.remove(this.getFilename());
            this.out = null;
        }
    }

    static {
        COLLECTED = COLLECTED;
        FILENAME = FILENAME;
        functionalMode = false;
        ERROR_LOGGING = ERROR_LOGGING;
        files = new HashMap();
    }
}

