/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SampleResult
implements Serializable {
    public static final String TAG_NAME = "sampleResult";
    public static final String TEXT = "text";
    public static final String BINARY = "bin";
    private byte[] responseData;
    private String responseCode;
    private String label;
    private TestElement samplerData;
    private String threadName;
    private String responseMessage;
    private long timeStamp = 0L;
    private List assertionResults = new ArrayList();
    private List subResults = new ArrayList();
    private String dataType;
    private boolean success;
    private boolean mark = false;
    private Set files = new HashSet();
    Map map = new HashMap();
    long time = 0L;
    private static final String SAMPLE_LABEL = "displayName";
    private static final String SAMPLER_CONFIG = "samplerConfig";
    private static final String DATA_TYPE = "dataType";
    private static final String RESPONSE_CODE = "responseCode";
    private static final String RESPONSE_MESSAGE = "responseMessage";
    private static final String THREAD_NAME = "threadName";
    private static final String TIME_STAMP = "timeStamp";
    private static final String ASSERTION_RESULTS = "assertionResults";
    private static final String RESPONSE_DATA = "responseData";
    private static final String SUCCESS = "success";
    private static final String TOTAL_TIME = "totalTime";
    private static transient Logger log;

    public void setMarked(String filename) {
        this.files.add(filename);
    }

    public boolean isMarked(String filename) {
        return this.files.contains(filename);
    }

    public String getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(String code) {
        this.responseCode = code;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String msg) {
        this.responseMessage = msg;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getSampleLabel() {
        return this.label;
    }

    public void setSampleLabel(String label) {
        this.label = label;
    }

    public void addAssertionResult(AssertionResult assertResult) {
        this.assertionResults.add(assertResult);
    }

    public AssertionResult[] getAssertionResults() {
        return this.assertionResults.toArray(new AssertionResult[0]);
    }

    public void addSubResult(SampleResult subResult) {
        this.subResults.add(subResult);
    }

    public SampleResult[] getSubResults() {
        return this.subResults.toArray(new SampleResult[0]);
    }

    public void configure(Configuration info) {
        this.setTime(info.getAttributeAsLong(TOTAL_TIME, 0L));
    }

    public void setTime(long t) {
        this.time = t;
    }

    public void setResponseData(byte[] response) {
        this.responseData = response;
    }

    public byte[] getResponseData() {
        return this.responseData;
    }

    public void setSamplerData(TestElement s) {
        this.samplerData = s;
    }

    public TestElement getSamplerData() {
        return this.samplerData;
    }

    public long getTime() {
        return this.time;
    }

    public boolean isSuccessful() {
        return this.success;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setSuccessful(boolean success) {
        this.success = success;
    }

    public String toString() {
        return this.getSampleLabel();
    }

    static {
        TAG_NAME = TAG_NAME;
        TEXT = TEXT;
        BINARY = BINARY;
        SAMPLE_LABEL = SAMPLE_LABEL;
        SAMPLER_CONFIG = SAMPLER_CONFIG;
        DATA_TYPE = DATA_TYPE;
        RESPONSE_CODE = RESPONSE_CODE;
        RESPONSE_MESSAGE = RESPONSE_MESSAGE;
        THREAD_NAME = THREAD_NAME;
        TIME_STAMP = TIME_STAMP;
        ASSERTION_RESULTS = ASSERTION_RESULTS;
        RESPONSE_DATA = RESPONSE_DATA;
        SUCCESS = SUCCESS;
        TOTAL_TIME = TOTAL_TIME;
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    }
}

