/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.save;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.configuration.DefaultConfigurationSerializer;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.save.SaveServiceConstants;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.xml.sax.SAXException;

public class SaveService
implements SaveServiceConstants {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.util");
    protected static final int SAVE_NO_ASSERTIONS = 0;
    protected static final int SAVE_FIRST_ASSERTION = 1;
    protected static final int SAVE_ALL_ASSERTIONS = 2;
    protected static SimpleDateFormat formatter;
    protected static boolean saveDataType;
    protected static boolean saveLabel;
    protected static boolean saveResponseCode;
    protected static boolean saveResponseData;
    protected static boolean saveResponseMessage;
    protected static boolean saveSuccessful;
    protected static boolean saveThreadName;
    protected static boolean saveTime;
    protected static String timeStampFormat;
    protected static boolean printMilliseconds;
    protected static String whichAssertionResults;
    protected static int assertionsResultsToSave;
    private static DefaultConfigurationBuilder builder;

    protected static void readAndSetSaveProperties() {
        Properties systemProps = System.getProperties();
        Properties props = new Properties(systemProps);
        try {
            props = JMeterUtils.getProperties("jmeter.properties");
        }
        catch (Exception e) {
            log.error("SaveService.readAndSetSaveProperties: Problem loading properties file jmeter.properties", (Throwable)e);
        }
        saveDataType = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.data_type", "true"));
        saveLabel = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.label", "true"));
        saveResponseCode = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.response_code", "true"));
        saveResponseData = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.response_data", "false"));
        saveResponseMessage = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.response_message", "true"));
        saveSuccessful = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.successful", "true"));
        saveThreadName = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.thread_name", "true"));
        saveTime = "true".equalsIgnoreCase(props.getProperty("jmeter.save.saveservice.time", "true"));
        timeStampFormat = props.getProperty("jmeter.save.saveservice.timestamp_format", "ms");
        printMilliseconds = "ms".equalsIgnoreCase(timeStampFormat);
        if (!printMilliseconds && !"none".equalsIgnoreCase(timeStampFormat) && timeStampFormat != null) {
            formatter = new SimpleDateFormat(timeStampFormat);
        }
        if ("none".equals(whichAssertionResults = props.getProperty("jmeter.save.saveservice.assertion_results", "none"))) {
            assertionsResultsToSave = 0;
        } else if ("first".equals(whichAssertionResults)) {
            assertionsResultsToSave = 1;
        } else if ("all".equals(whichAssertionResults)) {
            assertionsResultsToSave = 2;
        }
    }

    public static void saveSubTree(HashTree subTree, OutputStream writer) throws IOException {
        Configuration config = (Configuration)SaveService.getConfigsFromTree(subTree).get(0);
        DefaultConfigurationSerializer saver = new DefaultConfigurationSerializer();
        saver.setIndent(true);
        try {
            saver.serialize(writer, config);
        }
        catch (SAXException e) {
            throw new IOException("SAX implementation problem");
        }
        catch (ConfigurationException e) {
            throw new IOException("Problem using Avalon Configuration tools");
        }
    }

    public static SampleResult getSampleResult(Configuration config) {
        SampleResult result = new SampleResult();
        result.setThreadName(config.getAttribute("threadName", ""));
        result.setDataType(config.getAttribute("dataType", ""));
        result.setResponseCode(config.getAttribute("responseCode", ""));
        result.setResponseMessage(config.getAttribute("responseMessage", ""));
        result.setTime(config.getAttributeAsLong("time", 0L));
        result.setTimeStamp(config.getAttributeAsLong("timeStamp", 0L));
        result.setSuccessful(config.getAttributeAsBoolean("success", false));
        result.setSampleLabel(config.getAttribute("label", ""));
        result.setResponseData(SaveService.getBinaryData(config.getChild("binary")));
        Configuration[] subResults = config.getChildren("sampleResult");
        int i = 0;
        while (i < subResults.length) {
            result.addSubResult(SaveService.getSampleResult(subResults[i]));
            ++i;
        }
        Configuration[] assResults = config.getChildren("assertionResult");
        int i2 = 0;
        while (i2 < assResults.length) {
            result.addAssertionResult(SaveService.getAssertionResult(assResults[i2]));
            ++i2;
        }
        return result;
    }

    private static List getConfigsFromTree(HashTree subTree) {
        Iterator iter = subTree.list().iterator();
        LinkedList<DefaultConfiguration> configs = new LinkedList<DefaultConfiguration>();
        while (iter.hasNext()) {
            TestElement item = (TestElement)iter.next();
            DefaultConfiguration config = new DefaultConfiguration("node", "node");
            config.addChild(SaveService.getConfigForTestElement(null, item));
            List configList = SaveService.getConfigsFromTree(subTree.getTree((Object)item));
            Iterator iter2 = configList.iterator();
            while (iter2.hasNext()) {
                config.addChild((Configuration)iter2.next());
            }
            configs.add(config);
        }
        return configs;
    }

    public static Configuration getConfiguration(byte[] bin) {
        DefaultConfiguration config = new DefaultConfiguration("binary", "JMeter Save Service");
        try {
            config.setValue(new String(bin, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            log.error("", (Throwable)e);
        }
        return config;
    }

    public static byte[] getBinaryData(Configuration config) {
        if (config == null) {
            return new byte[0];
        }
        try {
            return config.getValue("").getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return new byte[0];
        }
    }

    public static AssertionResult getAssertionResult(Configuration config) {
        AssertionResult result = new AssertionResult();
        result.setError(config.getAttributeAsBoolean("error", false));
        result.setFailure(config.getAttributeAsBoolean("failure", false));
        result.setFailureMessage(config.getAttribute("failureMessage", ""));
        return result;
    }

    public static Configuration getConfiguration(AssertionResult assResult) {
        DefaultConfiguration config = new DefaultConfiguration("assertionResult", "JMeter Save Service");
        config.setAttribute("failureMessage", assResult.getFailureMessage());
        config.setAttribute("error", "" + assResult.isError());
        config.setAttribute("failure", "" + assResult.isFailure());
        return config;
    }

    public static Configuration getConfiguration(SampleResult result, boolean funcTest) {
        DefaultConfiguration config = new DefaultConfiguration("sampleResult", "JMeter Save Service");
        if (saveTime) {
            config.setAttribute("time", "" + result.getTime());
        }
        if (saveLabel) {
            config.setAttribute("label", result.getSampleLabel());
        }
        if (saveResponseCode) {
            config.setAttribute("responseCode", result.getResponseCode());
        }
        if (saveResponseMessage) {
            config.setAttribute("responseMessage", result.getResponseMessage());
        }
        if (saveThreadName) {
            config.setAttribute("threadName", result.getThreadName());
        }
        if (saveDataType) {
            config.setAttribute("dataType", result.getDataType());
        }
        if (printMilliseconds) {
            config.setAttribute("timeStamp", "" + result.getTimeStamp());
        } else if (formatter != null) {
            String stamp = formatter.format(new Date(result.getTimeStamp()));
            config.setAttribute("timeStamp", stamp);
        }
        if (saveSuccessful) {
            config.setAttribute("success", new Boolean(result.isSuccessful()).toString());
        }
        SampleResult[] subResults = result.getSubResults();
        int i = 0;
        while (i < subResults.length) {
            config.addChild(SaveService.getConfiguration(subResults[i], funcTest));
            ++i;
        }
        AssertionResult[] assResults = result.getAssertionResults();
        if (funcTest) {
            config.addChild(SaveService.getConfigForTestElement(null, result.getSamplerData()));
            int i2 = 0;
            while (i2 < assResults.length) {
                config.addChild(SaveService.getConfiguration(assResults[i2]));
                ++i2;
            }
            config.addChild(SaveService.getConfiguration(result.getResponseData()));
        } else {
            if (assertionsResultsToSave == 2) {
                config.addChild(SaveService.getConfigForTestElement(null, result.getSamplerData()));
                int i3 = 0;
                while (i3 < assResults.length) {
                    config.addChild(SaveService.getConfiguration(assResults[i3]));
                    ++i3;
                }
            } else if (assertionsResultsToSave == 1 && assResults.length > 0) {
                config.addChild(SaveService.getConfiguration(assResults[0]));
            }
            if (saveResponseData) {
                config.addChild(SaveService.getConfiguration(result.getResponseData()));
            }
        }
        return config;
    }

    public static Configuration getConfigForTestElement(String named, TestElement item) {
        DefaultConfiguration config = new DefaultConfiguration("testelement", "testelement");
        if (named != null) {
            config.setAttribute("name", named);
        }
        if (item.getProperty("TestElement.test_class") != null) {
            config.setAttribute("class", (String)item.getProperty("TestElement.test_class"));
        } else {
            config.setAttribute("class", item.getClass().getName());
        }
        Iterator iter = item.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Object value = item.getProperty(name);
            if (value instanceof TestElement) {
                config.addChild(SaveService.getConfigForTestElement(name, (TestElement)value));
                continue;
            }
            if (value instanceof Collection) {
                config.addChild(SaveService.createConfigForCollection(name, (Collection)value));
                continue;
            }
            if (value == null) continue;
            config.addChild(SaveService.createConfigForString(name, value.toString()));
        }
        return config;
    }

    private static Configuration createConfigForCollection(String propertyName, Collection list) {
        DefaultConfiguration config = new DefaultConfiguration("collection", "collection");
        if (propertyName != null) {
            config.setAttribute("name", propertyName);
        }
        config.setAttribute("class", list.getClass().getName());
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (item instanceof TestElement) {
                config.addChild(SaveService.getConfigForTestElement(null, (TestElement)item));
                continue;
            }
            if (item instanceof Collection) {
                config.addChild(SaveService.createConfigForCollection(null, (Collection)item));
                continue;
            }
            config.addChild(SaveService.createConfigForString(item.toString()));
        }
        return config;
    }

    private static Configuration createConfigForString(String value) {
        DefaultConfiguration config = new DefaultConfiguration("string", "string");
        config.setValue(value);
        config.setAttribute("xml:space", "preserve");
        return config;
    }

    private static Configuration createConfigForString(String name, String value) {
        if (value == null) {
            value = "";
        }
        DefaultConfiguration config = new DefaultConfiguration("property", "property");
        config.setAttribute("name", name);
        config.setValue(value);
        config.setAttribute("xml:space", "preserve");
        return config;
    }

    public static synchronized HashTree loadSubTree(InputStream in) throws IOException {
        try {
            Configuration config = builder.build(in);
            HashTree loadedTree = SaveService.generateNode(config);
            return loadedTree;
        }
        catch (ConfigurationException e) {
            throw new IOException("Problem loading using Avalon Configuration tools");
        }
        catch (SAXException e) {
            throw new IOException("Problem with SAX implementation");
        }
    }

    public static TestElement createTestElement(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        TestElement element = null;
        element = (TestElement)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals("property")) {
                try {
                    element.setProperty(children[i].getAttribute("name"), children[i].getValue());
                }
                catch (Exception ex) {
                    log.error("Problem loading property", (Throwable)ex);
                    element.setProperty(children[i].getAttribute("name"), "");
                }
            } else if (children[i].getName().equals("testelement")) {
                element.setProperty(children[i].getAttribute("name"), SaveService.createTestElement(children[i]));
            } else if (children[i].getName().equals("collection")) {
                element.setProperty(children[i].getAttribute("name"), SaveService.createCollection(children[i]));
            }
            ++i;
        }
        return element;
    }

    private static Collection createCollection(Configuration config) throws ConfigurationException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        Collection coll = (Collection)Class.forName(config.getAttribute("class")).newInstance();
        Configuration[] items = config.getChildren();
        int i = 0;
        while (i < items.length) {
            if (items[i].getName().equals("property")) {
                coll.add(items[i].getValue(""));
            } else if (items[i].getName().equals("testelement")) {
                coll.add(SaveService.createTestElement(items[i]));
            } else if (items[i].getName().equals("collection")) {
                coll.add(SaveService.createCollection(items[i]));
            } else if (items[i].getName().equals("string")) {
                coll.add(items[i].getValue(""));
            }
            ++i;
        }
        return coll;
    }

    private static HashTree generateNode(Configuration config) {
        TestElement element = null;
        try {
            element = SaveService.createTestElement(config.getChild("testelement"));
        }
        catch (Exception e) {
            log.error("Problem loading part of file", (Throwable)e);
            return null;
        }
        ListedHashTree subTree = new ListedHashTree((Object)element);
        Configuration[] subNodes = config.getChildren("node");
        int i = 0;
        while (i < subNodes.length) {
            HashTree t = SaveService.generateNode(subNodes[i]);
            if (t != null) {
                subTree.add((Object)element, t);
            }
            ++i;
        }
        return subTree;
    }

    static {
        SAVE_NO_ASSERTIONS = 0;
        SAVE_FIRST_ASSERTION = 1;
        SAVE_ALL_ASSERTIONS = 2;
        formatter = null;
        saveDataType = true;
        saveLabel = true;
        saveResponseCode = false;
        saveResponseData = false;
        saveResponseMessage = false;
        saveSuccessful = true;
        saveThreadName = true;
        saveTime = true;
        timeStampFormat = "ms";
        printMilliseconds = true;
        whichAssertionResults = "first";
        assertionsResultsToSave = 0;
        builder = new DefaultConfigurationBuilder();
        SaveService.readAndSetSaveProperties();
    }

    public static class Test
    extends TestCase {
        private static final String[] FILES = new String[]{"AssertionTestPlan.jmx", "AuthManagerTestPlan.jmx", "HeaderManagerTestPlan.jmx", "InterleaveTestPlan2.jmx", "InterleaveTestPlan.jmx", "LoopTestPlan.jmx", "Modification Manager.jmx", "OnceOnlyTestPlan.jmx", "proxy.jmx", "ProxyServerTestPlan.jmx", "SimpleTestPlan.jmx"};

        public Test(String name) {
            super(name);
        }

        public void setUp() {
        }

        public void testLoadAndSave() throws IOException {
            byte[] original = new byte[1000000];
            int i = 0;
            while (i < FILES.length) {
                InputStream in = new FileInputStream(new File("testfiles/" + FILES[i]));
                int len = in.read(original);
                in.close();
                in = new ByteArrayInputStream(original, 0, len);
                HashTree tree = SaveService.loadSubTree(in);
                in.close();
                ByteArrayOutputStream out = new ByteArrayOutputStream(1000000);
                SaveService.saveSubTree(tree, out);
                out.close();
                if (len != out.size()) {
                    Assert.fail((String)("Loading file bin/testfiles/" + FILES[i] + " and " + "saving it back changes its contents."));
                }
                ++i;
            }
        }
    }
}

