/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.testelement.TestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class AbstractTestElement
implements TestElement,
Serializable {
    private Map testInfo = Collections.synchronizedMap(new HashMap());
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.elements");

    public Object clone() {
        try {
            TestElement newObject = (TestElement)this.getClass().newInstance();
            this.configureClone(newObject);
            return newObject;
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return null;
        }
    }

    public void removeProperty(String key) {
        this.testInfo.remove(key);
    }

    public boolean equals(Object o) {
        if (o instanceof AbstractTestElement) {
            return ((AbstractTestElement)o).testInfo.equals(this.testInfo);
        }
        return false;
    }

    public void addTestElement(TestElement el) {
        if (el.getClass().equals(this.getClass())) {
            this.mergeIn(el);
        }
    }

    public void setName(String name) {
        this.setProperty("TestElement.name", name);
    }

    public String getName() {
        return (String)this.getProperty("TestElement.name");
    }

    public void setProperty(String key, Object prop) {
        this.testInfo.put(key, prop);
    }

    public Object getProperty(String key) {
        return this.testInfo.get(key);
    }

    public Collection getPropertyNames() {
        return this.testInfo.keySet();
    }

    protected void configureClone(TestElement newObject) {
        Iterator iter = this.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = this.getProperty(key);
            if (value instanceof TestElement) {
                newObject.setProperty(key, ((TestElement)value).clone());
                continue;
            }
            if (value instanceof Collection) {
                try {
                    newObject.setProperty(key, this.cloneCollection(value));
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                }
                continue;
            }
            newObject.setProperty(key, value);
        }
    }

    protected Collection cloneCollection(Object value) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        Iterator collIter = ((Collection)value).iterator();
        Collection newColl = (Collection)value.getClass().newInstance();
        while (collIter.hasNext()) {
            Object val = collIter.next();
            if (val instanceof TestElement) {
                val = ((TestElement)val).clone();
            } else if (val instanceof Collection) {
                try {
                    val = this.cloneCollection(val);
                }
                catch (Exception e) {
                    continue;
                }
            }
            newColl.add(val);
        }
        return newColl;
    }

    private long getLongValue(Object bound) {
        if (bound == null) {
            return 0L;
        }
        if (bound instanceof Long) {
            return (Long)bound;
        }
        return Long.parseLong((String)bound);
    }

    private float getFloatValue(Object bound) {
        if (bound == null) {
            return 0.0f;
        }
        if (bound instanceof Float) {
            return ((Float)bound).floatValue();
        }
        return Float.parseFloat((String)bound);
    }

    private double getDoubleValue(Object bound) {
        if (bound == null) {
            return 0.0;
        }
        if (bound instanceof Double) {
            return (Double)bound;
        }
        return Double.parseDouble((String)bound);
    }

    private String getStringValue(Object bound) {
        if (bound == null) {
            return "";
        }
        return bound.toString();
    }

    private int getIntValue(Object bound) {
        if (bound == null) {
            return 0;
        }
        if (bound instanceof Integer) {
            return (Integer)bound;
        }
        try {
            return Integer.parseInt((String)bound);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private boolean getBooleanValue(Object bound) {
        if (bound == null) {
            return false;
        }
        if (bound instanceof Boolean) {
            return (Boolean)bound;
        }
        return new Boolean((String)bound);
    }

    public int getPropertyAsInt(String key) {
        return this.getIntValue(this.getProperty(key));
    }

    public boolean getPropertyAsBoolean(String key) {
        return this.getBooleanValue(this.getProperty(key));
    }

    public float getPropertyAsFloat(String key) {
        return this.getFloatValue(this.getProperty(key));
    }

    public long getPropertyAsLong(String key) {
        return this.getLongValue(this.getProperty(key));
    }

    public double getPropertyAsDouble(String key) {
        return this.getDoubleValue(this.getProperty(key));
    }

    public String getPropertyAsString(String key) {
        return this.getStringValue(this.getProperty(key));
    }

    protected void mergeIn(TestElement element) {
        Iterator iter = element.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = element.getProperty(key);
            if (this.getProperty(key) == null || this.getProperty(key).equals("")) {
                this.setProperty(key, value);
                continue;
            }
            if (value instanceof TestElement) {
                if (this.getProperty(key) == null) {
                    this.setProperty(key, value);
                    continue;
                }
                if (!(this.getProperty(key) instanceof TestElement)) continue;
                ((TestElement)this.getProperty(key)).addTestElement((TestElement)value);
                continue;
            }
            if (!(value instanceof Collection)) continue;
            Collection localCollection = (Collection)this.getProperty(key);
            if (localCollection == null) {
                this.setProperty(key, value);
                continue;
            }
            Iterator iter2 = ((Collection)value).iterator();
            while (iter2.hasNext()) {
                Object item = iter2.next();
                if (localCollection.contains(item)) continue;
                localCollection.remove(item);
            }
            iter2 = ((Collection)value).iterator();
            while (iter2.hasNext()) {
                localCollection.add(iter2.next());
            }
        }
    }
}

