/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;

public class TestPlan
extends AbstractTestElement
implements Serializable {
    public static final String THREAD_GROUPS = "TestPlan.thread_groups";
    public static final String FUNCTIONAL_MODE = "TestPlan.functional_mode";
    public static final String USER_DEFINED_VARIABLES = "TestPlan.user_defined_variables";
    private List threadGroups = new LinkedList();
    private List configs = new LinkedList();
    private static List itemsCanAdd;
    private static TestPlan plan;
    private Map userDefinedVariables = new HashMap();

    public TestPlan() {
        this("Test Plan");
        this.setFunctionalMode(false);
    }

    public boolean isFunctionalMode() {
        return this.getPropertyAsBoolean(FUNCTIONAL_MODE);
    }

    public void setUserDefinedVariables(Arguments vars) {
        this.setProperty(USER_DEFINED_VARIABLES, vars);
    }

    public Map getUserDefinedVariables() {
        Arguments args = (Arguments)this.getProperty(USER_DEFINED_VARIABLES);
        if (args != null) {
            return args.getArgumentsAsMap();
        }
        return new HashMap();
    }

    public void setFunctionalMode(boolean funcMode) {
        this.setProperty(FUNCTIONAL_MODE, new Boolean(funcMode));
    }

    public TestPlan(String name) {
        this.setName(name);
        this.setProperty(THREAD_GROUPS, this.threadGroups);
    }

    public void addParameter(String name, String value) {
        this.userDefinedVariables.put(name, value);
    }

    public static TestPlan createTestPlan(String name) {
        if (plan == null) {
            plan = name == null ? new TestPlan() : new TestPlan(name);
            plan.setProperty("TestElement.gui_class", "org.apache.jmeter.control.gui.TestPlanGui");
        }
        return plan;
    }

    public void addTestElement(TestElement tg) {
        if (tg instanceof ThreadGroup) {
            this.addThreadGroup((ThreadGroup)tg);
        }
    }

    public void addJMeterComponent(TestElement child) {
        if (child instanceof ThreadGroup) {
            this.addThreadGroup((ThreadGroup)child);
        }
    }

    public Collection getThreadGroups() {
        return this.threadGroups;
    }

    public void addConfigElement(ConfigElement c) {
        this.configs.add(c);
    }

    public void addThreadGroup(ThreadGroup group) {
        this.threadGroups.add(group);
    }

    static {
        THREAD_GROUPS = THREAD_GROUPS;
        FUNCTIONAL_MODE = FUNCTIONAL_MODE;
        USER_DEFINED_VARIABLES = USER_DEFINED_VARIABLES;
        itemsCanAdd = new LinkedList();
        itemsCanAdd.add(JMeterUtils.getResString("threadgroup"));
    }
}

