/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.AssertionResult;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.threads.JMeterThreadMonitor;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.threads.TestCompiler;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.SearchByClass;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JMeterThread
implements Runnable,
Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    static Map samplers = new HashMap();
    int initialDelay = 0;
    Controller controller;
    private boolean running;
    HashTree testTree;
    TestCompiler compiler;
    JMeterThreadMonitor monitor;
    String threadName;
    JMeterVariables threadVars;
    Collection threadListeners;
    ListenerNotifier notifier;
    static /* synthetic */ Class class$org$apache$jmeter$testelement$ThreadListener;

    public JMeterThread() {
    }

    public JMeterThread(HashTree test, JMeterThreadMonitor monitor, ListenerNotifier note) {
        this.monitor = monitor;
        this.threadVars = new JMeterVariables();
        this.testTree = test;
        this.compiler = new TestCompiler(this.testTree, this.threadVars);
        this.controller = (Controller)this.testTree.getArray()[0];
        SearchByClass threadListenerSearcher = new SearchByClass(class$org$apache$jmeter$testelement$ThreadListener == null ? (class$org$apache$jmeter$testelement$ThreadListener = JMeterThread.class$("org.apache.jmeter.testelement.ThreadListener")) : class$org$apache$jmeter$testelement$ThreadListener);
        test.traverse((HashTreeTraverser)threadListenerSearcher);
        this.threadListeners = threadListenerSearcher.getSearchResults();
        this.notifier = note;
    }

    public void setThreadName(String threadName) {
        this.threadName = threadName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            this.initializeThreadListeners();
            this.testTree.traverse((HashTreeTraverser)this.compiler);
            this.running = true;
            Object entry = null;
            this.rampUpDelay();
            log.info("Thread " + Thread.currentThread().getName() + " started");
            block4: while (true) {
                if (!this.running) {
                    Object var5_5 = null;
                    break;
                }
                while (true) {
                    if (!this.controller.hasNext() || !this.running) {
                        if (!this.controller.isDone()) continue block4;
                        this.running = false;
                        continue block4;
                    }
                    try {
                        if (this.controller.isNextFirst()) {
                            this.notifyThreadListeners();
                        }
                        SamplePackage pack = this.compiler.configureSampler(this.controller.next());
                        this.delay(pack.getTimers());
                        SampleResult result = pack.getSampler().sample(null);
                        result.setThreadName(this.threadName);
                        result.setTimeStamp(System.currentTimeMillis());
                        this.checkAssertions(pack.getAssertions(), result);
                        this.notifyListeners(pack.getSampleListeners(), result);
                    }
                    catch (Exception e) {
                        log.error("", (Throwable)e);
                    }
                }
                break;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            log.info("Thread " + this.threadName + " is done");
            this.monitor.threadFinished(this);
            throw throwable;
        }
        log.info("Thread " + this.threadName + " is done");
        this.monitor.threadFinished(this);
    }

    public String getThreadName() {
        return this.threadName;
    }

    public void stop() {
        this.running = false;
        log.info("stopping " + this.threadName);
    }

    private void checkAssertions(List assertions, SampleResult result) {
        Iterator iter = assertions.iterator();
        while (iter.hasNext()) {
            AssertionResult assertion = ((Assertion)iter.next()).getResult(result);
            result.setSuccessful(result.isSuccessful() && !assertion.isError() && !assertion.isFailure());
            result.addAssertionResult(assertion);
        }
    }

    private void delay(List timers) {
        int sum = 0;
        Iterator iter = timers.iterator();
        while (iter.hasNext()) {
            sum = (int)((long)sum + ((Timer)iter.next()).delay());
        }
        if (sum > 0) {
            try {
                Thread.sleep(sum);
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    private void initializeThreadListeners() {
        Iterator iter = this.threadListeners.iterator();
        while (iter.hasNext()) {
            ((ThreadListener)iter.next()).setJMeterVariables(this.threadVars);
        }
    }

    private void notifyThreadListeners() {
        this.threadVars.incIteration();
        Iterator iter = this.threadListeners.iterator();
        while (iter.hasNext()) {
            ((ThreadListener)iter.next()).iterationStarted(this.threadVars.getIteration());
        }
    }

    private void notifyListeners(List listeners, SampleResult result) {
        SampleEvent event = new SampleEvent(result, (String)this.controller.getProperty("TestElement.name"));
        this.compiler.sampleOccurred(event);
        this.notifier.addLast(event, listeners);
    }

    public void setInitialDelay(int delay) {
        this.initialDelay = delay;
    }

    private void rampUpDelay() {
        if (this.initialDelay > 0) {
            try {
                Thread.sleep(this.initialDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

