/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ListenerNotifier
extends LinkedList
implements Runnable {
    private static Logger log = LoggingManager.getLoggerFor((String)"jmeter.engine");
    boolean running = true;
    boolean isStopped = true;
    private static int ABS_MAX = 500;
    private static int MAX = 200;
    int sleepTime = 2000;

    public void run() {
        while (this.running || this.size() > 1) {
            SampleEvent res = (SampleEvent)this.removeFirst();
            if (res != null) {
                List listeners = (List)this.removeFirst();
                this.notifyListeners(res, listeners);
            }
            try {
                Thread.sleep(this.sleepTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.size() <= MAX || Thread.currentThread().getPriority() != 5) continue;
            log.debug("Notifier thread priority going from normal to max, size = " + this.size());
            Thread.currentThread().setPriority(10);
        }
        log.debug("Listener Notifier stopped");
        this.isStopped = true;
    }

    private void notifyListeners(SampleEvent res, List listeners) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            ((SampleListener)iter.next()).sampleOccurred(res);
        }
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public synchronized void addLast(SampleEvent item, List listeners) {
        if (this.size() > ABS_MAX) {
            this.notifyListeners(item, listeners);
        } else {
            super.addLast(item);
            super.addLast(listeners);
            this.sleepTime = 0;
        }
    }

    public synchronized Object removeFirst() {
        try {
            return super.removeFirst();
        }
        catch (RuntimeException e) {
            this.sleepTime = 2000;
            log.debug("Setting notifier thread priority to normal");
            Thread.currentThread().setPriority(5);
            return null;
        }
    }

    public void stop() {
        this.running = false;
    }

    public void start() {
        Thread noteThread = new Thread(this);
        noteThread.start();
        this.isStopped = false;
    }
}

