/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.Modifier;
import org.apache.jmeter.config.ResponseBasedModifier;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.functions.Function;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jmeter.samplers.SampleListener;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.PerSampleClonable;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.threads.SamplePackage;
import org.apache.jmeter.timers.Timer;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class TestCompiler
implements HashTreeTraverser,
SampleListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.engine");
    LinkedList stack = new LinkedList();
    Map samplerConfigMap = new HashMap();
    Set objectsWithFunctions = new HashSet();
    HashTree testTree;
    SampleResult previousResult;
    Sampler currentSampler;
    JMeterVariables threadVars;
    private static Set pairing = new HashSet();

    public TestCompiler(HashTree testTree, JMeterVariables vars) {
        this.threadVars = vars;
        this.testTree = testTree;
    }

    public static void initialize() {
        pairing.clear();
    }

    public void sampleOccurred(SampleEvent e) {
        this.previousResult = e.getResult();
    }

    public void sampleStarted(SampleEvent e) {
    }

    public void sampleStopped(SampleEvent e) {
    }

    public SamplePackage configureSampler(Sampler sampler) {
        this.currentSampler = sampler;
        SamplePackage ret = new SamplePackage();
        Sampler clonedSampler = sampler;
        SamplerConfigs configs = (SamplerConfigs)this.samplerConfigMap.get(sampler);
        if (sampler instanceof PerSampleClonable) {
            clonedSampler = (Sampler)sampler.clone();
        }
        if (this.objectsWithFunctions.contains(sampler)) {
            this.replaceValues(clonedSampler);
        }
        ret.setSampler(clonedSampler);
        this.configureWithConfigElements(clonedSampler, configs.getConfigs());
        this.configureWithResponseModifiers(clonedSampler, configs.getResponseModifiers());
        this.configureWithModifiers(clonedSampler, configs.getModifiers());
        this.configureSamplerPackage(ret, configs);
        return ret;
    }

    public void addNode(Object node, HashTree subTree) {
        this.stack.addLast(node);
        log.debug("Added " + node + " to stack.  Stack size = " + this.stack.size());
    }

    public void subtractNode() {
        ObjectPair pair;
        log.debug("Subtracting node, stack size = " + this.stack.size());
        TestElement child = (TestElement)this.stack.getLast();
        if (child instanceof Sampler) {
            log.debug("Saving configs for sampler: " + child);
            this.saveSamplerConfigs((Sampler)child);
        }
        this.stack.removeLast();
        if (this.stack.size() > 0 && !pairing.contains(pair = new ObjectPair(child, this.stack.getLast()))) {
            ((TestElement)this.stack.getLast()).addTestElement(child);
            pairing.add(pair);
        }
    }

    public void processPath() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSamplerConfigs(Sampler sam) {
        LinkedList<TestElement> configs = new LinkedList<TestElement>();
        LinkedList<TestElement> modifiers = new LinkedList<TestElement>();
        LinkedList<TestElement> responseModifiers = new LinkedList<TestElement>();
        LinkedList<TestElement> listeners = new LinkedList<TestElement>();
        LinkedList<TestElement> timers = new LinkedList<TestElement>();
        LinkedList<TestElement> assertions = new LinkedList<TestElement>();
        log.debug("Full stack = " + this.stack);
        int i = this.stack.size();
        while (i > 0) {
            log.debug("looping, i = " + i);
            log.debug("sub-stack = " + this.stack.subList(0, i));
            Iterator iter = this.testTree.list(this.stack.subList(0, i)).iterator();
            while (iter.hasNext()) {
                TestElement item;
                TestElement testElement = item = (TestElement)iter.next();
                synchronized (testElement) {
                    if (this.hasFunctions(item)) {
                        this.objectsWithFunctions.add(item);
                    }
                }
                if (item instanceof ConfigTestElement) {
                    configs.add(item);
                }
                if (item instanceof Modifier) {
                    modifiers.add(item);
                }
                if (item instanceof ResponseBasedModifier) {
                    responseModifiers.add(item);
                }
                if (item instanceof SampleListener) {
                    listeners.add(item);
                }
                if (item instanceof Timer) {
                    timers.add(item);
                }
                if (!(item instanceof Assertion)) continue;
                assertions.add(item);
            }
            --i;
        }
        Sampler sampler = sam;
        synchronized (sampler) {
            if (this.hasFunctions(sam)) {
                this.objectsWithFunctions.add(sam);
            }
        }
        SamplerConfigs samplerConfigs = new SamplerConfigs(configs, modifiers, responseModifiers, listeners, timers, assertions);
        this.samplerConfigMap.put(sam, samplerConfigs);
    }

    private void configureWithConfigElements(Sampler sam, List configs) {
        Iterator iter = configs.iterator();
        while (iter.hasNext()) {
            ConfigTestElement config = (ConfigTestElement)iter.next();
            TestElement clonedConfig = (TestElement)this.cloneIfNecessary(config);
            if (this.objectsWithFunctions.contains(config)) {
                this.replaceValues(clonedConfig);
            }
            sam.addTestElement(clonedConfig);
        }
    }

    private void configureWithModifiers(Sampler sam, List modifiers) {
        Iterator iter = modifiers.iterator();
        while (iter.hasNext()) {
            Modifier mod = (Modifier)iter.next();
            TestElement cloned = (TestElement)this.cloneIfNecessary(mod);
            if (this.objectsWithFunctions.contains(mod)) {
                this.replaceValues(cloned);
            }
            ((Modifier)((Object)cloned)).modifyEntry(sam);
        }
    }

    private void configureWithResponseModifiers(Sampler sam, List responseModifiers) {
        Iterator iter = responseModifiers.iterator();
        while (iter.hasNext()) {
            ResponseBasedModifier mod = (ResponseBasedModifier)iter.next();
            TestElement cloned = (TestElement)this.cloneIfNecessary(mod);
            if (this.objectsWithFunctions.contains(mod)) {
                this.replaceValues(cloned);
            }
            if (this.previousResult == null) continue;
            ((ResponseBasedModifier)((Object)cloned)).modifyEntry(sam, this.previousResult);
        }
    }

    private Object cloneIfNecessary(Object el) {
        if (el instanceof PerSampleClonable || this.objectsWithFunctions.contains(el)) {
            return ((TestElement)el).clone();
        }
        return el;
    }

    private void configureSamplerPackage(SamplePackage ret, SamplerConfigs configs) {
        TestElement cloned;
        Iterator iter = configs.getAssertions().iterator();
        while (iter.hasNext()) {
            Assertion assertion = (Assertion)iter.next();
            cloned = (TestElement)this.cloneIfNecessary(assertion);
            if (this.objectsWithFunctions.contains(assertion)) {
                this.replaceValues(cloned);
            }
            ret.addAssertion((Assertion)((Object)cloned));
        }
        iter = configs.getTimers().iterator();
        while (iter.hasNext()) {
            Timer timer = (Timer)iter.next();
            cloned = (TestElement)this.cloneIfNecessary(timer);
            if (this.objectsWithFunctions.contains(timer)) {
                this.replaceValues(cloned);
            }
            ret.addTimer((Timer)((Object)cloned));
        }
        iter = configs.getListeners().iterator();
        while (iter.hasNext()) {
            SampleListener lis = (SampleListener)iter.next();
            cloned = (TestElement)this.cloneIfNecessary(lis);
            if (this.objectsWithFunctions.contains(lis)) {
                this.replaceValues(cloned);
            }
            ret.addSampleListener((SampleListener)((Object)cloned));
        }
    }

    private boolean hasFunctions(TestElement el) {
        boolean hasFunctions = false;
        Iterator iter = el.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            Object propValue = el.getProperty(propName);
            if (propValue instanceof Function) {
                ((Function)propValue).setJMeterVariables(this.threadVars);
                hasFunctions = true;
                continue;
            }
            if (propValue instanceof TestElement) {
                if (!this.hasFunctions((TestElement)propValue)) continue;
                hasFunctions = true;
                continue;
            }
            if (!(propValue instanceof Collection) || !this.hasFunctions((Collection)propValue)) continue;
            hasFunctions = true;
        }
        return hasFunctions;
    }

    private boolean hasFunctions(Collection values) {
        Iterator iter = new LinkedList(values).iterator();
        boolean hasFunctions = false;
        while (iter.hasNext()) {
            Object val = iter.next();
            if (val instanceof TestElement) {
                if (!this.hasFunctions((TestElement)val)) continue;
                hasFunctions = true;
                continue;
            }
            if (val instanceof Function) {
                ((Function)val).setJMeterVariables(this.threadVars);
                hasFunctions = true;
                continue;
            }
            if (!(val instanceof Collection) || !this.hasFunctions((Collection)val)) continue;
            hasFunctions = true;
        }
        return hasFunctions;
    }

    private void replaceValues(TestElement el) {
        Iterator iter = el.getPropertyNames().iterator();
        while (iter.hasNext()) {
            String propName = (String)iter.next();
            Object propValue = el.getProperty(propName);
            if (propValue instanceof Function) {
                try {
                    el.setProperty(propName, ((Function)propValue).execute(this.previousResult, this.currentSampler));
                }
                catch (InvalidVariableException e) {}
                continue;
            }
            if (propValue instanceof TestElement) {
                this.replaceValues((TestElement)propValue);
                continue;
            }
            if (!(propValue instanceof Collection)) continue;
            el.setProperty(propName, this.replaceValues((Collection)propValue));
        }
    }

    private Collection replaceValues(Collection values) {
        Collection newColl = null;
        try {
            newColl = (Collection)values.getClass().newInstance();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            return values;
        }
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            Object val = iter.next();
            if (val instanceof TestElement) {
                this.replaceValues((TestElement)val);
            } else if (val instanceof Function) {
                try {
                    val = ((Function)val).execute(this.previousResult, this.currentSampler);
                }
                catch (InvalidVariableException e) {}
            } else if (val instanceof Collection) {
                val = this.replaceValues((Collection)val);
            }
            newColl.add(val);
        }
        return newColl;
    }

    private class ObjectPair {
        Object one;
        Object two;

        public ObjectPair(Object one, Object two) {
            this.one = one;
            this.two = two;
        }

        public int hashCode() {
            return this.one.hashCode() + this.two.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ObjectPair) {
                return this.one == ((ObjectPair)o).one && this.two == ((ObjectPair)o).two;
            }
            return false;
        }
    }

    public static class Test
    extends TestCase {
        public Test(String name) {
            super(name);
        }

        public void testConfigGathering() throws Exception {
            ListedHashTree testing = new ListedHashTree();
            GenericController controller = new GenericController();
            ConfigTestElement config1 = new ConfigTestElement();
            config1.setName("config1");
            config1.setProperty("test.property", "A test value");
            TestSampler sampler = new TestSampler();
            sampler.setName("sampler");
            testing.add((Object)controller, (Object)config1);
            testing.add((Object)controller, (Object)sampler);
            TestCompiler.initialize();
            TestCompiler compiler = new TestCompiler((HashTree)testing, new JMeterVariables());
            testing.traverse((HashTreeTraverser)compiler);
            sampler = (TestSampler)compiler.configureSampler(sampler).getSampler();
            Assert.assertEquals((Object)"A test value", (Object)sampler.getProperty("test.property"));
        }

        class TestSampler
        extends AbstractSampler {
            TestSampler() {
            }

            public void addCustomTestElement(TestElement t) {
            }

            public SampleResult sample(Entry e) {
                return null;
            }

            public Object clone() {
                return new TestSampler();
            }
        }
    }

    private class SamplerConfigs {
        List configs;
        List modifiers;
        List listeners;
        List assertions;
        List timers;
        List responseModifiers;

        public SamplerConfigs(List configs, List modifiers, List responseModifiers, List listeners, List timers, List assertions) {
            this.configs = configs;
            this.modifiers = modifiers;
            this.responseModifiers = responseModifiers;
            this.listeners = listeners;
            this.timers = timers;
            this.assertions = assertions;
        }

        public List getConfigs() {
            return this.configs;
        }

        public List getModifiers() {
            return this.modifiers;
        }

        public List getResponseModifiers() {
            return this.responseModifiers;
        }

        public List getListeners() {
            return this.listeners;
        }

        public List getAssertions() {
            return this.assertions;
        }

        public List getTimers() {
            return this.timers;
        }
    }
}

