/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads.gui;

import java.awt.Font;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.control.LoopController;
import org.apache.jmeter.control.gui.LoopControlPanel;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.FocusRequester;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.gui.util.NumberFieldErrorListener;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.threads.ThreadGroup;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;

public class ThreadGroupGui
extends JPanel
implements JMeterGUIComponent {
    LoopControlPanel loopPanel;
    private static final String THREAD_NAME = "Thread Field";
    private static final String RAMP_NAME = "Ramp Up Field";
    private JTextField threadInput;
    private JTextField rampInput;
    private NamePanel namePanel;
    static /* synthetic */ Class class$org$apache$jmeter$threads$ThreadGroup;

    public ThreadGroupGui() {
        this.init();
        this.setName(this.getStaticLabel());
    }

    public Collection getMenuCategories() {
        return null;
    }

    public void setName(String name) {
        super.setName(name);
        this.namePanel.setName(name);
    }

    public String getName() {
        return this.namePanel.getName();
    }

    public TestElement createTestElement() {
        ThreadGroup tg = new ThreadGroup();
        tg.setProperty("TestElement.gui_class", this.getClass().getName());
        tg.setProperty("TestElement.test_class", (class$org$apache$jmeter$threads$ThreadGroup == null ? (class$org$apache$jmeter$threads$ThreadGroup = ThreadGroupGui.class$("org.apache.jmeter.threads.ThreadGroup")) : class$org$apache$jmeter$threads$ThreadGroup).getName());
        tg.setSamplerController((LoopController)this.loopPanel.createTestElement());
        tg.setProperty("TestElement.name", this.namePanel.getName());
        tg.setProperty("ThreadGroup.num_threads", this.threadInput.getText());
        tg.setProperty("ThreadGroup.ramp_time", this.rampInput.getText());
        return tg;
    }

    public void configure(TestElement tg) {
        this.setName((String)tg.getProperty("TestElement.name"));
        this.threadInput.setText(tg.getProperty("ThreadGroup.num_threads").toString());
        this.rampInput.setText(tg.getProperty("ThreadGroup.ramp_time").toString());
        this.loopPanel.configure((TestElement)tg.getProperty("ThreadGroup.main_controller"));
    }

    public JPopupMenu createPopupMenu() {
        JPopupMenu pop = new JPopupMenu();
        pop.add(MenuFactory.makeMenus(new String[]{"menu_logic_controller", "menu_listener", "menu_generative_controller", "menu_timer", "menu_config_element"}, JMeterUtils.getResString("Add"), "Add"));
        MenuFactory.addEditMenu(pop, true);
        MenuFactory.addFileMenu(pop);
        return pop;
    }

    public JPanel createControllerPanel() {
        this.loopPanel = new LoopControlPanel(false);
        LoopController looper = (LoopController)this.loopPanel.createTestElement();
        looper.setLoops(-1);
        this.loopPanel.configure(looper);
        return this.loopPanel;
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString("ThreadGroup");
    }

    private void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel mainPanel = new JPanel();
        EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
        mainPanel.setBorder(margin);
        mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
        JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString("thread_group_title"));
        Font curFont = panelTitleLabel.getFont();
        int curFontSize = curFont.getSize();
        panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
        mainPanel.add(panelTitleLabel);
        this.namePanel = new NamePanel();
        mainPanel.add(this.namePanel);
        JPanel threadPropsPanel = new JPanel();
        margin = new EmptyBorder(5, 10, 10, 10);
        threadPropsPanel.setLayout((LayoutManager)new VerticalLayout(0, 2));
        threadPropsPanel.setBorder(new CompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString("thread_delay_properties")), margin));
        JPanel threadPanel = new JPanel();
        JLabel threadLabel = new JLabel(JMeterUtils.getResString("number_of_threads"));
        threadPanel.add(threadLabel);
        this.threadInput = new JTextField(5);
        this.threadInput.setText("1");
        this.threadInput.addFocusListener(NumberFieldErrorListener.getNumberFieldErrorListener());
        this.threadInput.setName(THREAD_NAME);
        threadPanel.add(this.threadInput);
        threadPropsPanel.add(threadPanel);
        new FocusRequester(this.threadInput);
        JPanel rampPanel = new JPanel();
        JLabel rampLabel = new JLabel(JMeterUtils.getResString("ramp_up"));
        rampPanel.add(rampLabel);
        this.rampInput = new JTextField(5);
        this.rampInput.setText("1");
        this.rampInput.setName(RAMP_NAME);
        this.rampInput.addFocusListener(NumberFieldErrorListener.getNumberFieldErrorListener());
        rampPanel.add(this.rampInput);
        threadPropsPanel.add(rampPanel);
        threadPropsPanel.add(this.createControllerPanel());
        mainPanel.add(threadPropsPanel);
        this.add(mainPanel);
    }

    public void setNode(JMeterTreeNode node) {
        this.namePanel.setNode(node);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        THREAD_NAME = THREAD_NAME;
        RAMP_NAME = RAMP_NAME;
    }
}

