/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.util;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.test.UnitTestManager;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;
import org.xml.sax.XMLReader;

public class JMeterUtils
implements UnitTestManager {
    private static final String VERSION = "1.8.1";
    private static transient Logger log;
    private static LoggingManager logManager;
    private static String LOG_FILE;
    private static String LOG_PRIORITY;
    private static final SAXParserFactory xmlFactory;
    private static Properties appProperties;
    private static Collection localeChangeListeners;
    private static Locale locale;
    private static ResourceBundle resources;
    private static String jmDir;
    public static final String JMETER = "jmeter";
    public static final String ENGINE = "jmeter.engine";
    public static final String ELEMENTS = "jmeter.elements";
    public static final String GUI = "jmeter.gui";
    public static final String UTIL = "jmeter.util";
    public static final String CLASSFINDER = "jmeter.util.classfinder";
    public static final String TEST = "jmeter.test";
    public static final String HTTP = "jmeter.protocol.http";
    public static final String JDBC = "jmeter.protocol.jdbc";
    public static final String FTP = "jmeter.protocol.ftp";
    public static final String JAVA = "jmeter.protocol.java";
    static /* synthetic */ Class class$org$apache$jmeter$util$JMeterUtils;

    public static Properties getProperties(String file) {
        Properties p = new Properties(System.getProperties());
        try {
            File f = new File(file);
            p.load(new FileInputStream(f));
        }
        catch (Exception e) {
            try {
                (class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils).getClassLoader();
                p.load(ClassLoader.getSystemResourceAsStream("org/apache/jmeter/jmeter.properties"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        appProperties = p;
        LoggingManager.initializeLogging((Map)appProperties);
        log = LoggingManager.getLoggerFor((String)UTIL);
        String loc = appProperties.getProperty("language");
        if (loc != null) {
            JMeterUtils.setLocale(new Locale(loc, ""));
        } else {
            JMeterUtils.setLocale(Locale.getDefault());
        }
        return p;
    }

    public void initializeProperties(String file) {
        System.out.println("Initializing Properties: " + file);
        JMeterUtils.getProperties(file);
        String home = file.substring(0, file.lastIndexOf("/"));
        home = new File(home + "/..").getAbsolutePath();
        System.out.println("Setting JMeter home: " + home);
        JMeterUtils.setJMeterHome(home);
    }

    public static String[] getSearchPaths() {
        return new String[]{JMeterUtils.getJMeterHome() + "/lib/ext"};
    }

    public static void setLocale(Locale loc) {
        locale = loc;
        resources = ResourceBundle.getBundle("org.apache.jmeter.resources.messages", locale);
        JMeterUtils.notifyLocaleChangeListeners();
    }

    public static Locale getLocale() {
        return locale;
    }

    public static void addLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.add(listener);
    }

    public static void removeLocaleChangeListener(LocaleChangeListener listener) {
        localeChangeListeners.remove(listener);
    }

    private static void notifyLocaleChangeListeners() {
        LocaleChangeEvent event = new LocaleChangeEvent(class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils, locale);
        Iterator iterator = localeChangeListeners.iterator();
        while (iterator.hasNext()) {
            LocaleChangeListener listener = (LocaleChangeListener)iterator.next();
            listener.localeChanged(event);
        }
    }

    public static String getResString(String key) {
        if (key == null) {
            return null;
        }
        key = key.replace(' ', '_');
        key = key.toLowerCase();
        String resString = null;
        try {
            resString = resources.getString(key);
        }
        catch (MissingResourceException mre) {
            log.warn("ERROR! Resource string not found: [" + key + "]");
            resString = "";
        }
        return resString;
    }

    public static Properties getJMeterProperties() {
        return appProperties;
    }

    public static ImageIcon getImage(String name) {
        try {
            return new ImageIcon((class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils).getClassLoader().getResource("org/apache/jmeter/images/" + name.trim()));
        }
        catch (NullPointerException e) {
            log.warn("no icon for " + name);
            return null;
        }
    }

    public static String getResourceFileAsText(String name) {
        try {
            String lineEnd = System.getProperty("line.separator");
            BufferedReader fileReader = new BufferedReader(new InputStreamReader((class$org$apache$jmeter$util$JMeterUtils == null ? (class$org$apache$jmeter$util$JMeterUtils = JMeterUtils.class$("org.apache.jmeter.util.JMeterUtils")) : class$org$apache$jmeter$util$JMeterUtils).getClassLoader().getResourceAsStream(name)));
            StringBuffer text = new StringBuffer();
            String line = "NOTNULL";
            while (line != null) {
                line = fileReader.readLine();
                if (line == null) continue;
                text.append(line);
                text.append(lineEnd);
            }
            return text.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    public static Vector getTimers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "timer."), "org.apache.jmeter.timers.Timer");
    }

    public static Vector getVisualizers(Properties properties) {
        return JMeterUtils.instantiate(JMeterUtils.getVector(properties, "visualizer."), "org.apache.jmeter.visualizers.Visualizer");
    }

    public static Vector getControllers(Properties properties) {
        String name = "controller.";
        Vector<Object> v = new Vector<Object>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            Object o = JMeterUtils.instantiate(properties.getProperty(prop), "org.apache.jmeter.control.SamplerController");
            v.addElement(o);
        }
        return v;
    }

    public static String[] getTestSamples(Properties properties, String name) {
        return JMeterUtils.getVector(properties, name + ".testsample").toArray(new String[0]);
    }

    public static XMLReader getXMLParser(Properties properties) {
        return JMeterUtils.getXMLParser();
    }

    public static XMLReader getXMLParser() {
        XMLReader reader = null;
        try {
            reader = (XMLReader)JMeterUtils.instantiate(JMeterUtils.getPropDefault("xml.parser", "org.apache.xerces.parsers.SAXParser"), "org.xml.sax.XMLReader");
        }
        catch (Exception e) {
            reader = (XMLReader)JMeterUtils.instantiate(JMeterUtils.getPropDefault("xml.parser", "org.apache.xerces.parsers.SAXParser"), "org.xml.sax.XMLReader");
        }
        return reader;
    }

    public static Hashtable getAlias(Properties properties) {
        return JMeterUtils.getHashtable(properties, "alias.");
    }

    public static Vector getVector(Properties properties, String name) {
        Vector<String> v = new Vector<String>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            v.addElement(properties.getProperty(prop));
        }
        return v;
    }

    public static Hashtable getHashtable(Properties properties, String name) {
        Hashtable<String, String> t = new Hashtable<String, String>();
        Enumeration<Object> names = properties.keys();
        while (names.hasMoreElements()) {
            String prop = (String)names.nextElement();
            if (!prop.startsWith(name)) continue;
            t.put(prop.substring(name.length()), properties.getProperty(prop));
        }
        return t;
    }

    public static int getPropDefault(String propName, int defaultVal) {
        int ans;
        try {
            ans = Integer.valueOf(appProperties.getProperty(propName, Integer.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static boolean getPropDefault(String propName, boolean defaultVal) {
        boolean ans;
        try {
            String strVal = appProperties.getProperty(propName, new Boolean(defaultVal).toString()).trim();
            ans = strVal.equalsIgnoreCase("true") || strVal.equalsIgnoreCase("t") ? true : (strVal.equalsIgnoreCase("false") || strVal.equalsIgnoreCase("f") ? false : Integer.valueOf(strVal) == 1);
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static long getPropDefault(String propName, long defaultVal) {
        long ans;
        try {
            ans = Long.valueOf(appProperties.getProperty(propName, Long.toString(defaultVal)).trim());
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static String getPropDefault(String propName, String defaultVal) {
        String ans;
        try {
            ans = appProperties.getProperty(propName, defaultVal).trim();
        }
        catch (Exception e) {
            ans = defaultVal;
        }
        return ans;
    }

    public static void selJComboBoxItem(Properties properties, JComboBox combo, Vector namVec, String name) {
        int idx = namVec.indexOf(name);
        combo.setSelectedIndex(idx);
        combo.updateUI();
    }

    public static Object instantiate(String className, String impls) {
        if (className != null) {
            className.trim();
        }
        if (impls != null) {
            className.trim();
        }
        try {
            Class<?> c = Class.forName(impls);
            try {
                Class<?> o = Class.forName(className);
                Object res = o.newInstance();
                if (c.isInstance(res)) {
                    return res;
                }
                throw new IllegalArgumentException(className + " is not an instance of " + impls);
            }
            catch (ClassNotFoundException e) {
                log.error("Error loading class " + className + ": class is not found");
            }
            catch (IllegalAccessException e) {
                log.error("Error loading class " + className + ": does not have access");
            }
            catch (InstantiationException e) {
                log.error("Error loading class " + className + ": could not instantiate");
            }
            catch (NoClassDefFoundError e) {
                log.error("Error loading class " + className + ": couldn't find class " + e.getMessage());
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class " + impls + ": was not found.");
        }
        return null;
    }

    public static Vector instantiate(Vector v, String className) {
        Vector i = new Vector();
        try {
            Class<?> c = Class.forName(className);
            Enumeration elements = v.elements();
            while (elements.hasMoreElements()) {
                String name = (String)elements.nextElement();
                try {
                    Object o = Class.forName(name).newInstance();
                    if (!c.isInstance(o)) continue;
                    i.addElement(o);
                }
                catch (ClassNotFoundException e) {
                    log.error("Error loading class " + name + ": class is not found");
                }
                catch (IllegalAccessException e) {
                    log.error("Error loading class " + name + ": does not have access");
                }
                catch (InstantiationException e) {
                    log.error("Error loading class " + name + ": could not instantiate");
                }
                catch (NoClassDefFoundError e) {
                    log.error("Error loading class " + name + ": couldn't find class " + e.getMessage());
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.error("Error loading class " + className + ": class is not found");
        }
        return i;
    }

    public static Vector tokenize(String string, String separator) {
        Vector<String> v = new Vector<String>();
        StringTokenizer s = new StringTokenizer(string, separator);
        while (s.hasMoreTokens()) {
            v.addElement(s.nextToken());
        }
        return v;
    }

    public static JButton createButton(String name, ActionListener listener) {
        JButton button = new JButton(JMeterUtils.getImage(name + ".on.gif"));
        button.setDisabledIcon(JMeterUtils.getImage(name + ".off.gif"));
        button.setRolloverIcon(JMeterUtils.getImage(name + ".over.gif"));
        button.setPressedIcon(JMeterUtils.getImage(name + ".down.gif"));
        button.setActionCommand(name);
        button.addActionListener(listener);
        button.setRolloverEnabled(true);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setPreferredSize(new Dimension(24, 24));
        return button;
    }

    public static JButton createSimpleButton(String name, ActionListener listener) {
        JButton button = new JButton(JMeterUtils.getImage(name + ".gif"));
        button.setActionCommand(name);
        button.addActionListener(listener);
        button.setFocusPainted(false);
        button.setBorderPainted(false);
        button.setOpaque(false);
        button.setPreferredSize(new Dimension(25, 25));
        return button;
    }

    /*
     * Unable to fully structure code
     */
    public static String[] split(String splittee, String splitChar, String def) {
        if (splittee != null && splitChar != null) ** GOTO lbl4
        return new String[0];
lbl-1000:
        // 1 sources

        {
            splittee = splittee.substring(0, (int)(var5_3 + splitChar.length())) + def + splittee.substring((int)(var5_3 + 1 * splitChar.length()), splittee.length());
lbl4:
            // 2 sources

            ** while ((spot = splittee.indexOf((String)(splitChar + splitChar))) != -1)
        }
lbl5:
        // 1 sources

        returns = new Vector<String>();
        start = 0;
        length = splittee.length();
        spot = 0;
        while (start < length && (spot = splittee.indexOf(splitChar, start)) > -1) {
            if (spot > 0) {
                returns.addElement(splittee.substring(start, spot));
            }
            start = spot + splitChar.length();
        }
        if (start < length) {
            returns.add(splittee.substring(start));
        }
        values = new String[returns.size()];
        returns.copyInto(values);
        return values;
    }

    public static void reportErrorToUser(String errorMsg) {
        JOptionPane.showMessageDialog(GuiPackage.getInstance().getMainFrame(), errorMsg, "Error", 0);
    }

    public static int findInArray(String[] array, String value) {
        int count = -1;
        int index = -1;
        if (array != null && value != null) {
            while (++count < array.length) {
                if (array[count] == null || !array[count].equals(value)) continue;
                index = count;
                break;
            }
        }
        return index;
    }

    public static String unsplit(Object[] splittee, Object splitChar) {
        StringBuffer retVal = new StringBuffer("");
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            }
            if (count + 1 >= splittee.length || splittee[count + 1] == null) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String unsplit(Object[] splittee, Object splitChar, String def) {
        StringBuffer retVal = new StringBuffer("");
        int count = -1;
        while (++count < splittee.length) {
            if (splittee[count] != null) {
                retVal.append(splittee[count]);
            } else {
                retVal.append(def);
            }
            if (count + 1 >= splittee.length) continue;
            retVal.append(splitChar);
        }
        return retVal.toString();
    }

    public static String getJMeterHome() {
        return jmDir;
    }

    public static void setJMeterHome(String home) {
        jmDir = home;
    }

    public static String getJMeterVersion() {
        return VERSION;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        VERSION = VERSION;
        log = Hierarchy.getDefaultHierarchy().getLoggerFor(UTIL);
        LOG_FILE = "log_file";
        LOG_PRIORITY = "log_level";
        SAXParserFactory temp = null;
        try {
            temp = SAXParserFactory.newInstance();
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
            temp = null;
        }
        xmlFactory = temp;
        localeChangeListeners = new HashSet();
        JMETER = JMETER;
        ENGINE = ENGINE;
        ELEMENTS = ELEMENTS;
        GUI = GUI;
        UTIL = UTIL;
        CLASSFINDER = CLASSFINDER;
        TEST = TEST;
        HTTP = HTTP;
        JDBC = JDBC;
        FTP = FTP;
        JAVA = JAVA;
    }
}

