/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.gui;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.util.FilePanel;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.reporters.AbstractListenerElement;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public abstract class AbstractVisualizer
extends AbstractJMeterGuiComponent
implements Visualizer,
ChangeListener {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.gui");
    private FilePanel filePanel = new FilePanel(this, JMeterUtils.getResString("file_visualizer_output_file"));
    private JCheckBox errorLogging = new JCheckBox(JMeterUtils.getResString("log_errors_only"));
    ResultCollector collector;

    protected JCheckBox getErrorLoggingCheckbox() {
        return this.errorLogging;
    }

    protected ResultCollector getModel() {
        return this.collector;
    }

    protected FilePanel getFilePanel() {
        return this.filePanel;
    }

    public void setFile(String filename) {
        this.filePanel.setFilename(filename);
    }

    public String getFile() {
        return this.filePanel.getFilename();
    }

    public JPopupMenu createPopupMenu() {
        return MenuFactory.getDefaultVisualizerMenu();
    }

    public void stateChanged(ChangeEvent e) {
        log.info("getting new collector");
        this.collector = (ResultCollector)this.createTestElement();
    }

    public Collection getMenuCategories() {
        return Arrays.asList("menu_listener");
    }

    public TestElement createTestElement() {
        if (this.collector == null) {
            this.collector = new ResultCollector();
        }
        this.configureTestElement(this.collector);
        this.collector.setErrorLogging(this.errorLogging.isSelected());
        try {
            if (!this.getFile().equals("")) {
                try {
                    this.collector.setFilename(this.getFile());
                }
                catch (IllegalUserActionException e) {
                    JMeterUtils.reportErrorToUser(e.getMessage());
                    this.setFile("");
                }
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        return (TestElement)this.collector.clone();
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.setFile(el.getPropertyAsString("filename"));
        ResultCollector rc = (ResultCollector)el;
        this.errorLogging.setSelected(rc.isErrorLogging());
    }

    protected void configureTestElement(AbstractListenerElement mc) {
        super.configureTestElement(mc);
        mc.setListener(this);
    }
}

