/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.config.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.protocol.java.config.JavaConfig;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.layout.VerticalLayout;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JavaConfigGui
extends AbstractConfigGui {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.java");
    private static String CLASSNAMECOMBO = "classnamecombo";
    private JComboBox classnameCombo;
    protected boolean displayName = true;
    private ArgumentsPanel argsPanel;
    static /* synthetic */ Class class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient;

    public JavaConfigGui() {
        this(true);
    }

    public String getStaticLabel() {
        return JMeterUtils.getResString((String)"Java Request Defaults");
    }

    public JavaConfigGui(boolean displayNameField) {
        this.displayName = displayNameField;
        this.init();
    }

    protected void init() {
        this.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        JPanel classnameRequestPanel = new JPanel();
        classnameRequestPanel.setLayout((LayoutManager)new VerticalLayout(5, 2, 1));
        classnameRequestPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"protocol_java_border")));
        classnameRequestPanel.add(this.getClassnamePanel());
        classnameRequestPanel.add(this.getParameterPanel());
        if (this.displayName) {
            JPanel mainPanel = new JPanel();
            EmptyBorder margin = new EmptyBorder(10, 10, 5, 10);
            mainPanel.setBorder(margin);
            mainPanel.setLayout((LayoutManager)new VerticalLayout(5, 2));
            JLabel panelTitleLabel = new JLabel(JMeterUtils.getResString((String)"protocol_java_config_tile"));
            Font curFont = panelTitleLabel.getFont();
            int curFontSize = curFont.getSize();
            panelTitleLabel.setFont(new Font(curFont.getFontName(), curFont.getStyle(), curFontSize += 4));
            mainPanel.add(panelTitleLabel);
            mainPanel.add((Component)this.getNamePanel());
            mainPanel.add(classnameRequestPanel);
            this.add(mainPanel);
        } else {
            this.add(classnameRequestPanel);
        }
    }

    protected JPanel getClassnamePanel() {
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 10));
        panel.add(new JLabel(JMeterUtils.getResString((String)"protocol_java_classname")));
        List possibleClasses = null;
        try {
            possibleClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient == null ? (class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient = JavaConfigGui.class$("org.apache.jmeter.protocol.java.sampler.JavaSamplerClient")) : class$org$apache$jmeter$protocol$java$sampler$JavaSamplerClient});
            possibleClasses.remove("org.apache.jmeter.protocol.java.sampler.JavaSampler");
        }
        catch (Exception e) {
            log.debug("Exception getting interfaces.", (Throwable)e);
        }
        this.classnameCombo = new JComboBox<Object>(possibleClasses.toArray());
        this.classnameCombo.setName(CLASSNAMECOMBO);
        this.classnameCombo.setEditable(false);
        panel.add(this.classnameCombo);
        return panel;
    }

    protected JPanel getParameterPanel() {
        this.argsPanel = new ArgumentsPanel();
        return this.argsPanel;
    }

    public void configure(TestElement config) {
        super.configure(config);
        this.argsPanel.configure((TestElement)((Arguments)config.getProperty("arguments")));
        this.classnameCombo.setSelectedItem(config.getPropertyAsString("classname"));
    }

    public TestElement createTestElement() {
        JavaConfig config = new JavaConfig();
        this.configureTestElement((TestElement)config);
        config.setArguments((Arguments)this.argsPanel.createTestElement());
        config.setClassname(this.classnameCombo.getSelectedItem().toString());
        return config;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

