/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.sampler;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.protocol.java.config.JavaConfig;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class JavaSampler
extends AbstractSampler
implements JavaSamplerClient {
    public static final String CLASSNAME = "classname";
    public static final String ARGUMENTS = "arguments";
    private transient JavaSamplerClient javaClient = null;
    private static transient Logger log;

    public JavaSampler() {
        this.setArguments(new Arguments());
    }

    public void setArguments(Arguments args) {
        this.setProperty(ARGUMENTS, args);
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS);
    }

    public void addCustomTestElement(TestElement el) {
        if (el instanceof JavaConfig) {
            this.mergeIn(el);
        }
    }

    public void releaseJavaClient() {
        if (this.javaClient != null) {
            this.javaClient.teardownTest(this.createArgumentsHashMap(this.getArguments()));
        }
        this.javaClient = null;
    }

    public void setClassname(String classname) {
        this.setProperty(CLASSNAME, classname);
    }

    public String getClassname() {
        return this.getPropertyAsString(CLASSNAME);
    }

    public SampleResult sample(Entry entry) {
        return this.createJavaClient().runTest(this.createArgumentsHashMap(this.getArguments()));
    }

    public HashMap createArgumentsHashMap(Arguments args) {
        HashMap<String, Object> newArgs = new HashMap<String, Object>();
        Iterator iter = args.iterator();
        while (iter.hasNext()) {
            Argument item = (Argument)iter.next();
            newArgs.put(item.getName(), item.getValue());
        }
        return newArgs;
    }

    public JavaSamplerClient createJavaClient() {
        if (this.javaClient == null) {
            try {
                Class<?> javaClass = Class.forName(this.getClassname().trim(), false, Thread.currentThread().getContextClassLoader());
                Constructor<?>[] constructors = javaClass.getConstructors();
                int i = 0;
                while (i < constructors.length) {
                    Class<?>[] params = constructors[i].getParameterTypes();
                    if (params.length == 0) {
                        Object[] args = new Object[]{};
                        this.javaClient = (JavaSamplerClient)constructors[i].newInstance(args);
                        this.javaClient.setupTest(this.createArgumentsHashMap(this.getArguments()));
                        if (log.isDebugEnabled()) {
                            log.debug(this.whoAmI() + "\tCreated:\t" + this.getClassname() + "@" + Integer.toHexString(this.javaClient.hashCode()));
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                log.error(this.whoAmI() + "\tException creating: " + this.getClassname(), (Throwable)e);
                this.javaClient = this;
            }
        }
        return this.javaClient;
    }

    public JavaSamplerClient retrieveJavaClient() {
        return this.javaClient;
    }

    public void setupTest(HashMap arguments) {
        log.debug(this.whoAmI() + "\tsetupTest");
    }

    public void teardownTest(HashMap arguments) {
        log.debug(this.whoAmI() + "\tteardownTest");
        this.javaClient = null;
    }

    public SampleResult runTest(HashMap arguments) {
        log.debug(this.whoAmI() + "\trunTest");
        Thread.yield();
        SampleResult results = new SampleResult();
        results.setTime(0L);
        results.setSuccessful(false);
        results.setResponseData(new String("Class not found: " + this.getClassname()).getBytes());
        results.setSampleLabel("ERROR: " + this.getClassname());
        return results;
    }

    private String whoAmI() {
        StringBuffer sb = new StringBuffer();
        sb.append(Thread.currentThread().getName());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    static {
        CLASSNAME = CLASSNAME;
        ARGUMENTS = ARGUMENTS;
        log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.java");
    }
}

