/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.java.test;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.jmeter.protocol.java.sampler.JavaSamplerClient;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.log.Hierarchy;
import org.apache.log.Logger;

public class SleepTest
implements JavaSamplerClient,
Serializable {
    private static transient Logger log = Hierarchy.getDefaultHierarchy().getLoggerFor("jmeter.protocol.java");
    private long sleepTime = 1000L;
    private long sleepMask = 1023L;

    public SleepTest() {
        log.debug(this.whoAmI() + "\tConstruct");
    }

    public void setupTest(HashMap arguments) {
        log.debug(this.whoAmI() + "\tsetupTest()");
        Iterator argsIt = arguments.entrySet().iterator();
        while (argsIt.hasNext()) {
            Map.Entry entry = argsIt.next();
            log.debug(entry.getKey().toString() + "=" + entry.getValue().toString());
        }
        if (arguments.containsKey("SleepTime")) {
            this.setSleepTime(arguments.get("SleepTime"));
        }
        if (arguments.containsKey("SleepMask")) {
            this.setSleepMask(arguments.get("SleepMask"));
        }
    }

    public void teardownTest(HashMap arguments) {
        log.debug(this.whoAmI() + "\tteardownTest()");
        Iterator argsIt = arguments.entrySet().iterator();
        while (argsIt.hasNext()) {
            Map.Entry entry = argsIt.next();
            log.debug(entry.getKey().toString() + "=" + entry.getValue().toString());
        }
    }

    public SampleResult runTest(HashMap arguments) {
        SampleResult results = new SampleResult();
        try {
            long ct = System.currentTimeMillis();
            long start = System.currentTimeMillis();
            Thread.sleep(this.getSleepTime() + (ct %= this.getSleepMask()));
            long end = System.currentTimeMillis();
            results.setTime(end - start);
            results.setSuccessful(true);
            results.setSampleLabel("Sleep Test: time = " + this.getSleepTime() + ct);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (log.isDebugEnabled()) {
            log.debug(this.whoAmI() + "\trunTest()" + "\tTime:\t" + results.getTime());
            Iterator argsIt = arguments.entrySet().iterator();
            while (argsIt.hasNext()) {
                Map.Entry entry = argsIt.next();
                log.debug(entry.getKey().toString() + "=" + entry.getValue().toString());
            }
        }
        return results;
    }

    private String whoAmI() {
        StringBuffer sb = new StringBuffer();
        sb.append(Thread.currentThread().toString());
        sb.append("@");
        sb.append(Integer.toHexString(this.hashCode()));
        return sb.toString();
    }

    private long getSleepTime() {
        return this.sleepTime;
    }

    private long getSleepMask() {
        return this.sleepMask;
    }

    private void setSleepTime(Object arg) {
        try {
            this.sleepTime = Long.parseLong((String)arg);
        }
        catch (Exception e) {
            log.debug("Exception getting sleepTime:\t", (Throwable)e);
            this.sleepTime = 1000L;
        }
    }

    private void setSleepMask(Object arg) {
        try {
            this.sleepMask = Long.parseLong((String)arg);
        }
        catch (Exception e) {
            log.debug("Exception getting sleepMask:\t", (Throwable)e);
            this.sleepMask = 1023L;
        }
    }
}

