/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.util.Enumeration;
import javax.servlet.http.Cookie;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.util.CookieTools;
import org.apache.tomcat.util.HttpDate;

public class FixHeaders
extends BaseInterceptor
implements RequestInterceptor {
    public int beforeBody(Request request, Response response) {
        int contentLength;
        HttpDate date = new HttpDate(System.currentTimeMillis());
        response.setHeader("Date", date.toString());
        response.setHeader("Status", Integer.toString(response.getStatus()));
        response.setHeader("Content-Type", response.getContentType());
        String contentLanguage = response.getLocale().getLanguage();
        if (contentLanguage != null) {
            response.setHeader("Content-Language", contentLanguage);
        }
        if (request.getContext() != null) {
            response.setHeader("Servlet-Engine", request.getContext().getEngineHeader());
        }
        if ((contentLength = response.getContentLength()) != -1) {
            response.setHeader("Content-Length", Integer.toString(contentLength));
        }
        Enumeration cookieEnum = response.getCookies();
        while (cookieEnum.hasMoreElements()) {
            Cookie c = (Cookie)cookieEnum.nextElement();
            response.addHeader(CookieTools.getCookieHeaderName(c), CookieTools.getCookieHeaderValue(c));
            if (c.getVersion() != 1) continue;
            Cookie c0 = (Cookie)c.clone();
            c0.setVersion(0);
            response.addHeader(CookieTools.getCookieHeaderName(c0), CookieTools.getCookieHeaderValue(c0));
        }
        return 0;
    }
}

