/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service.connector;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.service.TcpConnection;
import org.apache.tomcat.service.TcpConnectionHandler;
import org.apache.tomcat.service.connector.AJP12RequestAdapter;
import org.apache.tomcat.service.connector.AJP12ResponseAdapter;
import org.apache.tomcat.util.StringManager;

public class Ajp12ConnectionHandler
implements TcpConnectionHandler {
    StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    ContextManager contextM;

    public Object[] init() {
        return null;
    }

    public void processConnection(TcpConnection connection, Object[] theData) {
        try {
            if (connection == null) {
                return;
            }
            Socket socket = connection.getSocket();
            if (socket == null) {
                return;
            }
            socket.setSoLinger(true, 100);
            AJP12RequestAdapter reqA = new AJP12RequestAdapter(this.contextM, socket);
            reqA.setContextManager(this.contextM);
            AJP12ResponseAdapter resA = new AJP12ResponseAdapter();
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            resA.setOutputStream(socket.getOutputStream());
            reqA.setResponse(resA);
            resA.setRequest(reqA);
            reqA.readNextRequest();
            if (reqA.isPing) {
                return;
            }
            if (reqA.shutdown) {
                return;
            }
            if (resA.getStatus() >= 400) {
                resA.finish();
                socket.close();
                return;
            }
            int contentLength = reqA.getFacade().getIntHeader("content-length");
            if (contentLength != -1) {
                BufferedServletInputStream sis = (BufferedServletInputStream)reqA.getInputStream();
                sis.setLimit(contentLength);
            }
            this.contextM.service(reqA, resA);
            resA.finish();
            socket.close();
        }
        catch (Exception e) {
            System.out.println("HANDLER THREAD PROBLEM: " + e);
            e.printStackTrace();
        }
    }

    public void setAttribute(String name, Object value) {
        if ("context.manager".equals(name)) {
            this.contextM = (ContextManager)value;
        }
    }

    public void setContextManager(ContextManager contextM) {
        this.contextM = contextM;
    }
}

