/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import com.sun.xml.tree.XmlDocument;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.TagCache;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class TagLibraryInfoImpl
extends TagLibraryInfo {
    private static final String TLD = "META-INF/taglib.tld";
    private static final String WEBAPP_INF = "/WEB-INF/web.xml";
    XmlDocument tld;
    Hashtable jarEntries;
    Hashtable tagCaches = new Hashtable();
    JspCompilationContext ctxt;

    TagLibraryInfoImpl(JspCompilationContext ctxt, String prefix, String uriIn) throws IOException, JasperException {
        super(prefix, uriIn);
        this.ctxt = ctxt;
        InputStream in = null;
        URL url = null;
        boolean relativeURL = false;
        this.uri = uriIn;
        if (!uriIn.endsWith("jar")) {
            URL dtdURL;
            XmlDocument webtld;
            NodeList nList;
            InputStream is = this.getResourceAsStream(WEBAPP_INF);
            if (is != null && (nList = (webtld = JspUtil.parseXMLDoc(is, dtdURL = ((Object)((Object)this)).getClass().getResource("/org/apache/tomcat/deployment/web.dtd"), "-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN")).getElementsByTagName("taglib")).getLength() != 0) {
                int i = 0;
                while (i < nList.getLength()) {
                    Element e = (Element)nList.item(i);
                    NodeList list = e.getChildNodes();
                    String tagLoc = null;
                    boolean match = false;
                    int j = 0;
                    while (j < list.getLength()) {
                        String tmpUri;
                        Text t;
                        Element em = (Element)list.item(j);
                        String tname = em.getNodeName();
                        if (tname.equals("taglib-location") && (t = (Text)em.getFirstChild()) != null && (tagLoc = t.getData()) != null) {
                            tagLoc = tagLoc.trim();
                        }
                        if (tname.equals("taglib-uri") && (t = (Text)em.getFirstChild()) != null && (tmpUri = t.getData()) != null && (tmpUri = tmpUri.trim()).equals(uriIn)) {
                            match = true;
                        }
                        ++j;
                    }
                    if (match && tagLoc != null) {
                        this.uri = tagLoc;
                        if (!this.uri.startsWith("/")) {
                            this.uri = "/WEB-INF/" + this.uri;
                        }
                    }
                    ++i;
                }
            }
            if (!this.uri.startsWith("/")) {
                this.uri = ctxt.resolveRelativeUri(this.uri);
            }
            if ((in = this.getResourceAsStream(this.uri)) == null) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
            this.parseTLD(in);
        }
        if (uriIn.endsWith("jar")) {
            ZipEntry entry;
            if (!uriIn.startsWith("/")) {
                url = new URL(uriIn);
                in = url.openStream();
            } else {
                relativeURL = true;
                in = this.getResourceAsStream(uriIn);
            }
            ZipInputStream zin = new ZipInputStream(in);
            this.jarEntries = new Hashtable();
            this.ctxt = ctxt;
            File jspFile = new File(ctxt.getJspFile());
            String parent = jspFile.getParent();
            String jarFileName = ctxt.getOutputDir();
            if (parent != null) {
                jarFileName = String.valueOf(jarFileName) + File.separatorChar + parent;
            }
            File jspDir = new File(jarFileName);
            jspDir.mkdirs();
            jarFileName = relativeURL ? String.valueOf(jarFileName) + File.separatorChar + new File(this.uri).getName() : String.valueOf(jarFileName) + File.separatorChar + new File(url.getFile()).getName();
            Constants.message("jsp.message.copyinguri", new Object[]{this.uri, jarFileName}, 4);
            if (relativeURL) {
                TagLibraryInfoImpl.copy(this.getResourceAsStream(this.uri), jarFileName);
            } else {
                TagLibraryInfoImpl.copy(url.openStream(), jarFileName);
            }
            ctxt.getClassLoader().addJar(jarFileName);
            boolean tldFound = false;
            while ((entry = zin.getNextEntry()) != null) {
                ByteArrayOutputStream baos;
                if (entry.getName().equals(TLD)) {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        int b = ((InflaterInputStream)zin).read();
                        if (b == -1) break;
                        baos.write(b);
                    }
                    baos.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    tldFound = true;
                    this.parseTLD(bais);
                } else {
                    baos = new ByteArrayOutputStream();
                    while (zin.available() != 0) {
                        int b = ((InflaterInputStream)zin).read();
                        if (b == -1) break;
                        baos.write(b);
                    }
                    baos.close();
                    this.jarEntries.put(entry.getName(), baos.toByteArray());
                }
                zin.closeEntry();
            }
            if (!tldFound) {
                throw new JasperException(Constants.getString("jsp.error.tld_not_found", new Object[]{TLD}));
            }
        }
    }

    static void copy(InputStream in, String fileName) throws IOException, FileNotFoundException {
        int nRead;
        byte[] buf = new byte[1024];
        FileOutputStream out = new FileOutputStream(fileName);
        while ((nRead = in.read(buf, 0, buf.length)) != -1) {
            out.write(buf, 0, nRead);
        }
    }

    TagAttributeInfo createAttribute(Element elem) {
        String name = null;
        boolean required = false;
        boolean rtexprvalue = false;
        boolean reqTime = false;
        String type = null;
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Text t;
            Element e = (Element)list.item(i);
            String tname = e.getTagName();
            if (tname.equals("name")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    name = t.getData();
                }
            } else if (tname.equals("required")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    required = Boolean.valueOf(t.getData());
                }
            } else if (tname.equals("rtexprvalue")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    rtexprvalue = Boolean.valueOf(t.getData());
                }
            } else if (tname.equals("type")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    type = t.getData();
                }
            } else {
                Constants.message("jsp.warning.unknown.element.in.attribute", new Object[]{e.getTagName()}, 2);
            }
            ++i;
        }
        return new TagAttributeInfo(name, required, type, rtexprvalue);
    }

    private TagInfo createTagInfo(Element elem) throws JasperException {
        String name = null;
        String tagclass = null;
        String teiclass = null;
        String bodycontent = "JSP";
        String info = null;
        Vector<TagAttributeInfo> attributeVector = new Vector<TagAttributeInfo>();
        NodeList list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Text t;
            Element e = (Element)list.item(i);
            String tname = e.getTagName();
            if (tname.equals("name")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    name = t.getData();
                }
            } else if (tname.equals("tagclass")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    tagclass = t.getData();
                }
            } else if (tname.equals("teiclass")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    teiclass = t.getData();
                }
            } else if (tname.equals("bodycontent")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    bodycontent = t.getData();
                }
            } else if (tname.equals("info")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    info = t.getData();
                }
            } else if (tname.equals("attribute")) {
                attributeVector.addElement(this.createAttribute(e));
            } else {
                Constants.message("jsp.warning.unknown.element.in.tag", new Object[]{e.getTagName()}, 2);
            }
            ++i;
        }
        Object[] tagAttributeInfo = new TagAttributeInfo[attributeVector.size()];
        attributeVector.copyInto(tagAttributeInfo);
        TagExtraInfo tei = null;
        if (teiclass != null && !teiclass.equals("")) {
            try {
                Class<?> teiClass = this.ctxt.getClassLoader().loadClass(teiclass);
                tei = (TagExtraInfo)teiClass.newInstance();
            }
            catch (ClassNotFoundException cex) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, cex.getMessage()}, 2);
            }
            catch (IllegalAccessException iae) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, iae.getMessage()}, 2);
            }
            catch (InstantiationException ie) {
                Constants.message("jsp.warning.teiclass.is.null", new Object[]{teiclass, ie.getMessage()}, 2);
            }
        }
        TagInfo taginfo = new TagInfo(name, tagclass, bodycontent, info, (TagLibraryInfo)this, tei, (TagAttributeInfo[])tagAttributeInfo);
        return taginfo;
    }

    private InputStream getResourceAsStream(String uri) throws FileNotFoundException {
        if (uri.indexOf(":") > 0) {
            return this.ctxt.getResourceAsStream(uri);
        }
        return new FileInputStream(this.ctxt.getRealPath(uri));
    }

    TagCache getTagCache(String shortTagName) {
        return (TagCache)this.tagCaches.get(shortTagName);
    }

    private void parseTLD(InputStream in) throws JasperException {
        URL tagUrl = ((Object)((Object)this)).getClass().getResource("/org/apache/jasper/resources/web-jsptaglib_1_1.dtd");
        this.tld = JspUtil.parseXMLDoc(in, tagUrl, "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN");
        Vector<TagInfo> tagVector = new Vector<TagInfo>();
        NodeList list = this.tld.getElementsByTagName("taglib");
        if (list.getLength() != 1) {
            throw new JasperException(Constants.getString("jsp.error.more.than.one.taglib"));
        }
        Element elem = (Element)list.item(0);
        list = elem.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Text t;
            Element e = (Element)list.item(i);
            String tname = e.getTagName();
            if (tname.equals("tlibversion")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    this.tlibversion = t.getData();
                }
            } else if (tname.equals("jspversion")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    this.jspversion = t.getData();
                }
            } else if (tname.equals("shortname")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    this.shortname = t.getData();
                }
            } else if (tname.equals("urn")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    this.urn = t.getData();
                }
            } else if (tname.equals("info")) {
                t = (Text)e.getFirstChild();
                if (t != null) {
                    this.info = t.getData();
                }
            } else if (tname.equals("tag")) {
                tagVector.addElement(this.createTagInfo(e));
            } else {
                Constants.message("jsp.warning.unknown.element.in.TLD", new Object[]{e.getTagName()}, 2);
            }
            ++i;
        }
        this.tags = new TagInfo[tagVector.size()];
        tagVector.copyInto(this.tags);
    }

    private final void print(String name, String value, PrintWriter w) {
        if (value != null) {
            w.print(String.valueOf(name) + " = {\n\t");
            w.print(value);
            w.print("\n}\n");
        }
    }

    void putTagCache(String shortTagName, TagCache tc) {
        this.tagCaches.put(shortTagName, tc);
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        this.print("tlibversion", this.tlibversion, out);
        this.print("jspversion", this.jspversion, out);
        this.print("shortname", this.shortname, out);
        this.print("urn", this.urn, out);
        this.print("info", this.info, out);
        int i = 0;
        while (i < this.tags.length) {
            out.println(this.tags[i].toString());
            ++i;
        }
        return sw.toString();
    }
}

