/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.runtime;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jasper.Constants;
import org.apache.jasper.Options;

public class JspLoader
extends ClassLoader {
    ClassLoader parent;
    Options options;
    private Vector jars = new Vector();

    public JspLoader(ClassLoader cl, Options options) {
        this.parent = cl;
        this.options = options;
    }

    public void addJar(String jarFileName) throws IOException {
        if (!this.jars.contains(jarFileName)) {
            Constants.message("jsp.message.adding_jar", new Object[]{jarFileName}, 3);
            this.jars.addElement(jarFileName);
        }
    }

    private final Class defClass(String className, byte[] classData) {
        return this.defineClass(className, classData, 0, classData.length);
    }

    protected Class findClass(String className) throws ClassNotFoundException {
        try {
            int beg = className.lastIndexOf(".") == -1 ? 0 : className.lastIndexOf(".") + 1;
            int end = className.lastIndexOf("_jsp_");
            if (end <= 0) {
                byte[] classBytes = this.loadClassDataFromJar(className);
                if (classBytes == null) {
                    throw new ClassNotFoundException(className);
                }
                return this.defClass(className, classBytes);
            }
            String fileName = null;
            String outputDir = this.options.getScratchDir().toString();
            if (className.indexOf(36, end) != -1) {
                fileName = String.valueOf(outputDir) + File.separatorChar + className.replace('.', File.separatorChar) + ".class";
            } else {
                fileName = String.valueOf(className.substring(beg, end)) + ".class";
                fileName = String.valueOf(outputDir) + File.separatorChar + fileName;
            }
            FileInputStream fin = new FileInputStream(fileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fin.read(buf)) != -1) {
                baos.write(buf, 0, i);
            }
            fin.close();
            baos.close();
            byte[] classBytes = baos.toByteArray();
            return this.defClass(className, classBytes);
        }
        catch (Exception exception) {
            throw new ClassNotFoundException(Constants.getString("jsp.error.unable.loadclass", new Object[]{className}));
        }
    }

    private byte[] getClassData(InputStream istream) throws IOException {
        byte[] buf = new byte[1024];
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        return bout.toByteArray();
    }

    public String getClassPath() {
        StringBuffer cpath = new StringBuffer();
        String sep = System.getProperty("path.separator");
        int i = 0;
        while (i < this.jars.size()) {
            cpath.append(String.valueOf((String)this.jars.elementAt(i)) + sep);
            ++i;
        }
        return cpath.toString();
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            try {
                c = this.parent != null ? this.parent.loadClass(name) : this.findSystemClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    private byte[] loadClassDataFromJar(String className) {
        String entryName = String.valueOf(className.replace('.', '/')) + ".class";
        InputStream classStream = null;
        int i = 0;
        while (i < this.jars.size()) {
            File thisFile = new File((String)this.jars.elementAt(i));
            try {
                if (thisFile.exists()) {
                    if (thisFile.isFile()) {
                        ZipFile zip = new ZipFile(thisFile);
                        ZipEntry entry = zip.getEntry(entryName);
                        if (entry != null) {
                            classStream = zip.getInputStream(entry);
                            byte[] classData = this.getClassData(classStream);
                            zip.close();
                            return classData;
                        }
                        zip.close();
                    } else {
                        File classFile = new File(thisFile, entryName.replace('/', File.separatorChar));
                        if (classFile.exists()) {
                            classStream = new FileInputStream(classFile);
                            byte[] classData = this.getClassData(classStream);
                            classStream.close();
                            return classData;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                return null;
            }
            ++i;
        }
        return null;
    }
}

