/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.DOMParserWrapper;
import org.apache.xerces.dom.TextImpl;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import util.Arguments;

public class DOMCount {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setDeferredDOM = true;
    private long elements;
    private long attributes;
    private long characters;
    private long ignorableWhitespace;

    public static void count(String string, String string2) {
        try {
            DOMParserWrapper dOMParserWrapper = (DOMParserWrapper)Class.forName(string).newInstance();
            DOMCount dOMCount = new DOMCount();
            long l = System.currentTimeMillis();
            dOMParserWrapper.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", setDeferredDOM);
            dOMParserWrapper.setFeature("http://xml.org/sax/features/validation", setValidation);
            dOMParserWrapper.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
            dOMParserWrapper.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
            Document document = dOMParserWrapper.parse(string2);
            dOMCount.traverse(document);
            long l2 = System.currentTimeMillis();
            dOMCount.printResults(string2, l2 - l);
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                sAXException.getException().printStackTrace(System.err);
            } else {
                sAXException.printStackTrace(System.err);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void traverse(Node node) {
        if (node == null) {
            return;
        }
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                this.elements = 0L;
                this.attributes = 0L;
                this.characters = 0L;
                this.ignorableWhitespace = 0L;
                this.traverse(((Document)node).getDocumentElement());
                break;
            }
            case 1: {
                NodeList nodeList;
                ++this.elements;
                NamedNodeMap namedNodeMap = node.getAttributes();
                if (namedNodeMap != null) {
                    this.attributes += (long)namedNodeMap.getLength();
                }
                if ((nodeList = node.getChildNodes()) == null) break;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    this.traverse(nodeList.item(n2));
                    ++n2;
                }
                break;
            }
            case 5: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n3 = 0;
                while (n3 < n) {
                    this.traverse(nodeList.item(n3));
                    ++n3;
                }
                break;
            }
            case 4: {
                this.characters += (long)node.getNodeValue().length();
                break;
            }
            case 3: {
                if (node instanceof TextImpl) {
                    if (((TextImpl)node).isIgnorableWhitespace()) {
                        this.ignorableWhitespace += (long)node.getNodeValue().length();
                        break;
                    }
                    this.characters += (long)node.getNodeValue().length();
                    break;
                }
                this.characters += (long)node.getNodeValue().length();
            }
        }
    }

    public void printResults(String string, long l) {
        System.out.print(string);
        System.out.print(": ");
        System.out.print(l);
        System.out.print(" ms (");
        System.out.print(this.elements);
        System.out.print(" elems, ");
        System.out.print(this.attributes);
        System.out.print(" attrs, ");
        System.out.print(this.ignorableWhitespace);
        System.out.print(" spaces, ");
        System.out.print(this.characters);
        System.out.print(" chars)");
        System.out.println();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static void main(String[] var0) {
        var1_1 = new Arguments();
        var1_1.setUsage(new String[]{"usage: java dom.DOMCount (options) uri ...", "", "options:", "  -p name  Specify DOM parser wrapper by name.", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=off]", "  -s | -S  Turn on/off Schema support [default=on]", "  -d | -D  Turn on/off deferred DOM [default=on]", "  -h       This help screen."});
        if (var0.length == 0) {
            var1_1.printUsage();
            System.exit(1);
        }
        var2_2 = "dom.wrappers.DOMParser";
        var1_1.parseArgumentTokens(var0, new char[]{'p'});
        var4_3 = null;
        ** GOTO lbl47
        {
            switch (var3_4) {
                case 118: {
                    DOMCount.setValidation = true;
                    break;
                }
                case 86: {
                    DOMCount.setValidation = false;
                    break;
                }
                case 78: {
                    DOMCount.setNameSpaces = false;
                    break;
                }
                case 110: {
                    DOMCount.setNameSpaces = true;
                    break;
                }
                case 112: {
                    var2_2 = var1_1.getStringParameter();
                    break;
                }
                case 100: {
                    DOMCount.setDeferredDOM = true;
                    break;
                }
                case 68: {
                    DOMCount.setDeferredDOM = false;
                    break;
                }
                case 115: {
                    DOMCount.setSchemaSupport = true;
                    break;
                }
                case 83: {
                    DOMCount.setSchemaSupport = false;
                    break;
                }
                case 45: 
                case 63: 
                case 104: {
                    var1_1.printUsage();
                    System.exit(1);
                    break;
                }
                case -1: {
                    ** GOTO lbl46
                }
            }
            do {
                if ((var3_4 = var1_1.getArguments()) != -1) continue block13;
lbl46:
                // 2 sources

                DOMCount.count(var2_2, var4_3);
lbl47:
                // 2 sources

            } while ((var4_3 = var1_1.getlistFiles()) != null);
        }
    }
}

