/*
 * Decompiled with CFR 0.152.
 */
package dom;

import dom.DOMParserWrapper;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import util.Arguments;

public class DOMFilter {
    private static final String DEFAULT_PARSER_NAME = "dom.wrappers.DOMParser";
    private static boolean setValidation = false;
    private static boolean setNameSpaces = true;
    private static boolean setSchemaSupport = true;
    private static boolean setDeferredDOM = true;

    public static void print(String string, String string2, String string3, String string4) {
        try {
            DOMParserWrapper dOMParserWrapper = (DOMParserWrapper)Class.forName(string).newInstance();
            dOMParserWrapper.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", setDeferredDOM);
            dOMParserWrapper.setFeature("http://xml.org/sax/features/validation", setValidation);
            dOMParserWrapper.setFeature("http://xml.org/sax/features/namespaces", setNameSpaces);
            dOMParserWrapper.setFeature("http://apache.org/xml/features/validation/schema", setSchemaSupport);
            Document document = dOMParserWrapper.parse(string2);
            NodeList nodeList = document.getElementsByTagName(string3);
            DOMFilter.print(nodeList, string4);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    private static void print(NodeList nodeList, String string) {
        if (nodeList == null) {
            return;
        }
        if (string == null) {
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Element element = (Element)nodeList.item(n2);
                DOMFilter.print(element, element.getAttributes());
                ++n2;
            }
        } else {
            int n = nodeList.getLength();
            int n3 = 0;
            while (n3 < n) {
                Element element = (Element)nodeList.item(n3);
                NamedNodeMap namedNodeMap = element.getAttributes();
                if (namedNodeMap.getNamedItem(string) != null) {
                    DOMFilter.print(element, namedNodeMap);
                }
                ++n3;
            }
        }
    }

    private static void print(Element element, NamedNodeMap namedNodeMap) {
        System.out.print('<');
        System.out.print(element.getNodeName());
        if (namedNodeMap != null) {
            int n = namedNodeMap.getLength();
            int n2 = 0;
            while (n2 < n) {
                Attr attr = (Attr)namedNodeMap.item(n2);
                System.out.print(' ');
                System.out.print(attr.getNodeName());
                System.out.print("=\"");
                System.out.print(DOMFilter.normalize(attr.getNodeValue()));
                System.out.print('\"');
                ++n2;
            }
        }
        System.out.println('>');
    }

    private static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\n': 
                case '\r': {
                    stringBuffer.append("&#");
                    stringBuffer.append(Integer.toString(c));
                    stringBuffer.append(';');
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public static void main(String[] var0) {
        var1_1 = new Arguments();
        var1_1.setUsage(new String[]{"usage: java dom.DOMFilter (options) uri ...", "", "options:", "  -p name  Specify DOM parser wrapper by name.", "  -e name  Specify element name to search for. Default is \"*\".", "  -a name  Specify attribute name of specified elements.", "  -p name  Specify DOM parser wrapper by name.", "  -n | -N  Turn on/off namespace [default=on]", "  -v | -V  Turn on/off validation [default=on]", "  -s | -S  Turn on/off Schema support [default=on]", "  -d | -D  Turn on/off deferred DOM [default=on]", "  -h       This help screen."});
        if (var0.length == 0) {
            var1_1.printUsage();
            System.exit(1);
        }
        var2_2 = "dom.wrappers.DOMParser";
        var3_3 = "*";
        var4_4 = null;
        var1_1.parseArgumentTokens(var0, new char[]{'p', 'e', 'a'});
        var6_5 = null;
        ** GOTO lbl56
        {
            switch (var5_6) {
                case 118: {
                    DOMFilter.setValidation = true;
                    break;
                }
                case 86: {
                    DOMFilter.setValidation = false;
                    break;
                }
                case 78: {
                    DOMFilter.setNameSpaces = false;
                    break;
                }
                case 110: {
                    DOMFilter.setNameSpaces = true;
                    break;
                }
                case 112: {
                    var2_2 = var1_1.getStringParameter();
                    break;
                }
                case 100: {
                    DOMFilter.setDeferredDOM = true;
                    break;
                }
                case 68: {
                    DOMFilter.setDeferredDOM = false;
                    break;
                }
                case 115: {
                    DOMFilter.setSchemaSupport = true;
                    break;
                }
                case 83: {
                    DOMFilter.setSchemaSupport = false;
                    break;
                }
                case 101: {
                    var3_3 = var1_1.getStringParameter();
                    break;
                }
                case 97: {
                    var4_4 = var1_1.getStringParameter();
                    break;
                }
                case 45: 
                case 63: 
                case 104: {
                    var1_1.printUsage();
                    System.exit(1);
                    break;
                }
                case -1: {
                    ** GOTO lbl54
                }
            }
            do {
                if ((var5_6 = var1_1.getArguments()) != -1) continue block15;
lbl54:
                // 2 sources

                System.err.println(var6_5 + ':');
                DOMFilter.print(var2_2, var6_5, var3_3, var4_4);
lbl56:
                // 2 sources

            } while ((var6_5 = var1_1.getlistFiles()) != null);
        }
    }
}

