/*
 * Decompiled with CFR 0.152.
 */
package dom.wrappers;

import dom.DOMParserWrapper;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class DOMParser
implements DOMParserWrapper,
ErrorHandler {
    org.apache.xerces.parsers.DOMParser parser = new org.apache.xerces.parsers.DOMParser();

    public DOMParser() {
        try {
            this.parser.setFeature("http://xml.org/sax/features/validation", true);
        }
        catch (SAXException sAXException) {
            System.out.println("error in setting up parser feature");
        }
        this.parser.setErrorHandler((ErrorHandler)this);
    }

    public Document parse(String string) throws Exception {
        this.parser.parse(string);
        return this.parser.getDocument();
    }

    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.parser.setFeature(string, bl);
    }

    public void warning(SAXParseException sAXParseException) {
        System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) {
        System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        throw sAXParseException;
    }

    private String getLocationString(SAXParseException sAXParseException) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = sAXParseException.getSystemId();
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getLineNumber());
        stringBuffer.append(':');
        stringBuffer.append(sAXParseException.getColumnNumber());
        return stringBuffer.toString();
    }
}

