/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.LCount;
import org.apache.xerces.dom.NodeImpl;
import org.apache.xerces.dom.events.MutationEventImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class CharacterDataImpl
extends ChildNode {
    static final long serialVersionUID = 7931170150428474230L;
    protected String data;
    private static transient NodeList singletonNodeList = new NodeList(){

        public Node item(int n) {
            return null;
        }

        public int getLength() {
            return 0;
        }
    };

    protected CharacterDataImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.data = string;
    }

    public NodeList getChildNodes() {
        return singletonNodeList;
    }

    public String getNodeValue() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    void setNodeValueInternal(String string) {
        this.setValueCalled(true);
        this.setNodeValue(string);
        this.setValueCalled(false);
    }

    public void setNodeValue(String string) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        String string2 = this.data;
        NodeImpl.EnclosingAttr enclosingAttr = null;
        LCount lCount = LCount.lookup("DOMAttrModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            enclosingAttr = this.getEnclosingAttr();
        }
        this.data = string;
        if (!this.setValueCalled()) {
            this.ownerDocument().replacedText(this);
        }
        lCount = LCount.lookup("DOMCharacterDataModified");
        if (lCount.captures + lCount.bubbles + lCount.defaults > 0) {
            MutationEventImpl mutationEventImpl = new MutationEventImpl();
            mutationEventImpl.initMutationEvent("DOMCharacterDataModified", true, false, null, string2, string, null);
            this.dispatchEvent(mutationEventImpl);
        }
        this.dispatchAggregateEvents(enclosingAttr);
    }

    public String getData() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data;
    }

    public int getLength() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.data.length();
    }

    public void appendData(String string) {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        this.setNodeValue(this.data + string);
    }

    public void deleteData(int n, int n2) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (n2 < 0) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = Math.max(this.data.length() - n2 - n, 0);
        try {
            this.setNodeValueInternal(this.data.substring(0, n) + (n3 > 0 ? this.data.substring(n + n2, n + n2 + n3) : ""));
            this.ownerDocument().deletedText(this, n, n2);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
    }

    public void insertData(int n, String string) throws DOMException {
        if (this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        try {
            this.setNodeValueInternal(new StringBuffer(this.data).insert(n, string).toString());
            this.ownerDocument().insertedText(this, n, string.length());
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
    }

    public void replaceData(int n, int n2, String string) throws DOMException {
        this.deleteData(n, n2);
        this.insertData(n, string);
    }

    public void setData(String string) throws DOMException {
        this.setNodeValue(string);
    }

    public String substringData(int n, int n2) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        int n3 = this.data.length();
        if (n2 < 0 || n < 0 || n > n3 - 1) {
            throw new DOMException(1, "DOM004 Index out of bounds");
        }
        int n4 = Math.min(n + n2, n3);
        return this.data.substring(n, n4);
    }
}

