/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;

public class Property
extends Task {
    String name;
    String value;
    String file;
    String resource;
    boolean userProperty = false;

    private void addProperties(Properties props) {
        this.resolveAllProperties(props);
        Enumeration e = ((Hashtable)props).keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            String v = ProjectHelper.replaceProperties(value, this.project.getProperties());
            this.addProperty(name, value);
        }
    }

    private void addProperty(String n, String v) {
        if (this.userProperty) {
            if (this.project.getUserProperty(n) == null) {
                this.project.setUserProperty(n, v);
            } else {
                this.log("Override ignored for " + this.name, 3);
            }
        } else if (this.project.getProperty(n) == null) {
            this.project.setProperty(n, v);
        } else {
            this.log("Override ignored for " + this.name, 3);
        }
    }

    private boolean extractProperties(String source, Vector properties) {
        int pos;
        boolean i = false;
        int prev = 0;
        while ((pos = source.indexOf("$", prev)) >= 0) {
            if (pos == source.length() - 1) {
                prev = pos + 1;
                continue;
            }
            if (source.charAt(pos + 1) != '{') {
                prev = pos + 2;
                continue;
            }
            int endName = source.indexOf(125, pos);
            String n = source.substring(pos + 2, endName);
            properties.addElement(n);
            prev = endName + 1;
        }
        return properties.size() > 0;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void init() throws BuildException {
        try {
            if (this.name != null && this.value != null) {
                this.addProperty(this.name, this.value);
            }
            if (this.file != null) {
                this.loadFile(this.file);
            }
            if (this.resource != null) {
                this.loadResource(this.resource);
            }
        }
        catch (Exception e) {
            throw new BuildException(e);
        }
    }

    private void loadFile(String name) throws BuildException {
        Properties props = new Properties();
        this.log("Loading " + name, 3);
        try {
            if (new File(name).exists()) {
                props.load(new FileInputStream(name));
                this.addProperties(props);
            } else {
                this.log("Unable to find " + name, 3);
            }
        }
        catch (Exception ex) {
            throw new BuildException(ex.getMessage(), ex, this.location);
        }
    }

    private void loadResource(String name) {
        Properties props = new Properties();
        this.log("Resource Loading " + name, 3);
        try {
            InputStream is = this.getClass().getResourceAsStream(name);
            if (is != null) {
                props.load(is);
                this.addProperties(props);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void resolveAllProperties(Hashtable props) {
        toResolve = new Hashtable<String, String>();
        e = props.keys();
        more = true;
        ** GOTO lbl34
        {
            propsInValue = new Vector<E>();
            name = (String)e.nextElement();
            value = (String)props.get(name);
            if (this.extractProperties(value, propsInValue)) {
                i = 0;
                while (i < propsInValue.size()) {
                    elem = (String)propsInValue.elementAt(i);
                    if (this.project.getProperties().containsKey(elem) || props.containsKey(elem)) {
                        toResolve.put(name, value);
                        break;
                    }
                    ++i;
                }
            }
            if (toResolve.size() > 0) {
                tre = toResolve.keys();
                while (tre.hasMoreElements()) {
                    name2 = (String)tre.nextElement();
                    value2 = (String)toResolve.get(name2);
                    v = ProjectHelper.replaceProperties(value2, this.project.getProperties());
                    v = ProjectHelper.replaceProperties(v, props);
                    props.put(name, v);
                }
                toResolve.clear();
                e = props.keys();
            } else {
                more = false;
            }
            do {
                if (e.hasMoreElements()) continue block0;
lbl34:
                // 2 sources

            } while (more);
        }
    }

    public void setFile(String file) {
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setUserProperty(boolean userP) {
        this.userProperty = userP;
    }

    public void setValue(String value) {
        this.value = value;
    }
}

