/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Touch;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarInputStream;

public class Untar
extends Task {
    private String dest;
    private String source;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute() throws BuildException {
        Touch touch = (Touch)this.project.createTask("touch");
        touch.setOwningTarget(this.target);
        File srcF = this.project.resolveFile(this.source);
        TarInputStream tis = null;
        try {
            try {
                if (this.source == null) {
                    throw new BuildException("No source specified", this.location);
                }
                if (!srcF.exists()) {
                    throw new BuildException("source " + srcF + " doesn't exist", this.location);
                }
                if (this.dest == null) {
                    throw new BuildException("No destination specified", this.location);
                }
                File dir = this.project.resolveFile(this.dest);
                this.log("Expanding: " + srcF + " into " + dir, 2);
                tis = new TarInputStream(new FileInputStream(srcF));
                TarEntry te = null;
                while ((te = tis.getNextEntry()) != null) {
                    try {
                        File f = new File(dir, Project.translatePath(te.getName()));
                        this.log("expand-file " + te.getName(), 3);
                        File dirF = new File(f.getParent());
                        dirF.mkdirs();
                        if (te.isDirectory()) {
                            f.mkdirs();
                        } else {
                            byte[] buffer = new byte[1024];
                            int length = 0;
                            FileOutputStream fos = new FileOutputStream(f);
                            while ((length = tis.read(buffer)) >= 0) {
                                fos.write(buffer, 0, length);
                            }
                            fos.close();
                        }
                        if (Project.getJavaVersion() == "1.1") continue;
                        touch.setFile(f.getAbsolutePath());
                        touch.setMillis(te.getModTime().getTime());
                        touch.touch();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        this.log("FileNotFoundException: " + te.getName(), 1);
                    }
                }
            }
            catch (IOException ioe) {
                throw new BuildException("Error while expanding " + srcF.getPath(), ioe, this.location);
            }
            Object var5_12 = null;
            if (tis == null) return;
        }
        catch (Throwable throwable) {
            Object var5_13 = null;
            if (tis == null) throw throwable;
            try {
                tis.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            tis.close();
            return;
        }
        catch (IOException iOException) {}
    }

    public void setDest(String d) {
        this.dest = d;
    }

    public void setSrc(String s) {
        this.source = s;
    }
}

