/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.taskdefs.XSLTLiaison;

public class XSLTProcess
extends MatchingTask {
    private File destDir = null;
    private File baseDir = null;
    private File xslFile = null;
    private String targetExtension = "html";
    private XSLTLiaison liaison;

    public void execute() throws BuildException {
        if (this.baseDir == null) {
            this.baseDir = this.project.resolveFile(".");
        }
        if (this.destDir == null) {
            String msg = "destdir attributes must be set!";
            throw new BuildException(msg);
        }
        DirectoryScanner scanner = this.getDirectoryScanner(this.baseDir);
        this.log("Transforming into " + this.destDir, 2);
        if (this.liaison == null) {
            try {
                this.setProcessor("xslp");
            }
            catch (Throwable throwable) {
                try {
                    this.setProcessor("xalan");
                }
                catch (Throwable e2) {
                    throw new BuildException(e2);
                }
            }
        }
        this.log("Using " + this.liaison.getClass().toString(), 3);
        try {
            if (this.xslFile != null) {
                String file = new File(this.baseDir, this.xslFile.toString()).toString();
                this.log("Loading stylesheet " + file, 2);
                this.liaison.setStylesheet(file);
            }
        }
        catch (Exception ex) {
            this.log("Failed to read stylesheet " + this.xslFile, 2);
            throw new BuildException(ex);
        }
        String[] list = scanner.getIncludedFiles();
        int i = 0;
        while (i < list.length) {
            this.process(this.baseDir, list[i], this.destDir);
            ++i;
        }
        String[] dirs = scanner.getIncludedDirectories();
        int j = 0;
        while (j < dirs.length) {
            list = new File(this.baseDir, dirs[j]).list();
            int i2 = 0;
            while (i2 < list.length) {
                this.process(this.baseDir, list[i2], this.destDir);
                ++i2;
            }
            ++j;
        }
    }

    private void process(File baseDir, String xmlFile, File destDir) throws BuildException {
        String fileExt = this.targetExtension;
        File outFile = null;
        File inFile = null;
        try {
            inFile = new File(baseDir, xmlFile);
            outFile = new File(destDir, String.valueOf(xmlFile.substring(0, xmlFile.lastIndexOf(46))) + fileExt);
            if (inFile.lastModified() > outFile.lastModified()) {
                this.log("Processing " + xmlFile + " to " + outFile, 3);
                this.liaison.transform(inFile.toString(), outFile.toString());
            }
        }
        catch (Exception ex) {
            this.log("Failed to process " + inFile, 2);
            outFile.delete();
            throw new BuildException(ex);
        }
    }

    public void setBasedir(String dirName) {
        this.baseDir = this.project.resolveFile(dirName);
    }

    public void setDestdir(String dirName) {
        this.destDir = this.project.resolveFile(dirName);
    }

    public void setExtension(String name) {
        this.targetExtension = name;
    }

    public void setProcessor(String processor) throws Exception {
        this.liaison = processor.equals("xslp") ? (XSLTLiaison)Class.forName("org.apache.tools.ant.taskdefs.optional.XslpLiaison").newInstance() : (processor.equals("xalan") ? (XSLTLiaison)Class.forName("org.apache.tools.ant.taskdefs.optional.XalanLiaison").newInstance() : (XSLTLiaison)Class.forName(processor).newInstance());
    }

    public void setStyle(String xslFile) {
        this.xslFile = new File(xslFile);
    }
}

