/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.Serializable;
import org.jdom.Comment;
import org.jdom.Element;

public class Entity
implements Serializable,
Cloneable {
    protected String name;
    protected List content;

    protected Entity() {
    }

    public Entity(String name) {
        this.name = name;
        this.content = new LinkedList();
    }

    public Entity addChild(String s) {
        this.content.add((Object)s);
        return this;
    }

    public Entity addChild(Element element) {
        this.content.add((Object)element);
        return this;
    }

    public Entity addText(String text) {
        this.content.add((Object)text);
        return this;
    }

    public final Object clone() {
        Entity entity = new Entity(this.name);
        entity.content = (List)((LinkedList)this.content).clone();
        return entity;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public List getChildren() {
        LinkedList childElements = new LinkedList();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof Element)) continue;
            childElements.add(obj);
        }
        return childElements;
    }

    public String getContent() {
        StringBuffer textContent = new StringBuffer();
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (!(obj instanceof String)) continue;
            textContent.append((String)obj);
        }
        return textContent.toString();
    }

    public List getMixedContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    public final String getSerializedForm() {
        return "&" + this.name + ";";
    }

    public boolean hasMixedContent() {
        boolean hasText = false;
        boolean hasElements = false;
        boolean hasComments = false;
        Iterator i = this.content.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof String) {
                if (hasElements || hasComments) {
                    return true;
                }
                hasText = true;
                continue;
            }
            if (obj instanceof Element) {
                if (hasText || hasComments) {
                    return true;
                }
                hasElements = true;
                continue;
            }
            if (!(obj instanceof Comment)) continue;
            if (hasText || hasElements) {
                return true;
            }
            hasComments = true;
        }
        return false;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Entity setChildren(List children) {
        return this.setMixedContent(children);
    }

    public Entity setContent(String textContent) {
        this.content.clear();
        this.content.add((Object)textContent);
        return this;
    }

    public Entity setMixedContent(List mixedContent) {
        this.content = mixedContent;
        return this;
    }

    public final String toString() {
        return "[Entity: " + this.getSerializedForm() + "]";
    }
}

