/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.IllegalNameException;
import org.jdom.Verifier;

public final class Namespace {
    private static HashMap namespaces;
    private static HashMap mappings;
    public static final Namespace NO_NAMESPACE;
    public static final Namespace XML_NAMESPACE;
    private String prefix;
    private String uri;

    static {
        NO_NAMESPACE = new Namespace("", "");
        XML_NAMESPACE = new Namespace("xml", "http://www.w3.org/XML/1998/namespace");
        namespaces = new HashMap();
        mappings = new HashMap();
        namespaces.put((Object)"", (Object)NO_NAMESPACE);
        mappings.put((Object)"", (Object)"");
        mappings.put((Object)"xml", (Object)"http://www.w3.org/XML/1998/namespace");
        namespaces.put((Object)"xml&http://www.w3.org/XML/1998/namespace", (Object)XML_NAMESPACE);
    }

    private Namespace(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
    }

    public boolean equals(Object ob) {
        Namespace ns;
        if (ob == null) {
            return false;
        }
        return ob instanceof Namespace && (ns = (Namespace)ob).getURI().equals(this.uri) && ns.getPrefix().equals(this.prefix);
    }

    public static Namespace getNamespace(String uri) {
        return Namespace.getNamespace("", uri);
    }

    public static Namespace getNamespace(String prefix, String uri) {
        if (prefix == null || prefix.trim().equals("")) {
            prefix = "";
        }
        if (uri == null || uri.trim().equals("")) {
            uri = "";
        }
        if (prefix.equals("xml")) {
            return XML_NAMESPACE;
        }
        if (namespaces.containsKey((Object)uri)) {
            return (Namespace)namespaces.get((Object)uri);
        }
        String reason = Verifier.checkNamespacePrefix(prefix);
        if (reason != null) {
            throw new IllegalNameException(prefix, "Namespace prefix", reason);
        }
        reason = Verifier.checkNamespaceURI(uri);
        if (reason != null) {
            throw new IllegalNameException(uri, "Namespace URI", reason);
        }
        if (!prefix.equals("") && uri.equals("")) {
            throw new IllegalNameException("", "namespace", "Namespace URIs must be non-null and non-empty Strings.");
        }
        if (namespaces.containsKey((Object)uri)) {
            return (Namespace)namespaces.get((Object)(String.valueOf(prefix) + "&" + uri));
        }
        mappings.put((Object)prefix, (Object)uri);
        Namespace ns = new Namespace(prefix, uri);
        namespaces.put((Object)(String.valueOf(prefix) + "&" + uri), (Object)ns);
        return ns;
    }

    public static Namespace getNamespace(String prefix, Element context) {
        if (context == null) {
            return null;
        }
        Namespace ns = context.getNamespace();
        if (ns.getPrefix().equals(prefix)) {
            return ns;
        }
        List attributes = context.getAttributes();
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute a = (Attribute)iterator.next();
            ns = a.getNamespace();
            if (!ns.getPrefix().equals(prefix)) continue;
            return ns;
        }
        return Namespace.getNamespace(prefix, context.getParent());
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getURI() {
        return this.uri;
    }

    public int hashCode() {
        return (String.valueOf(this.prefix) + this.uri).hashCode();
    }

    public String toString() {
        return "[Namespace: prefix " + this.prefix + " is mapped to URI \"" + this.uri + "\"]";
    }
}

