/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import org.jdom.Element;

class PartialList
extends LinkedList {
    protected List backingList;
    protected Element parent;

    public PartialList(List backingList) {
        this(backingList, null);
    }

    public PartialList(List backingList, Element parent) {
        this.backingList = backingList;
        this.parent = parent;
    }

    public void add(int index, Object current) {
        if (index == this.size()) {
            this.addLast(current);
        } else {
            this.backingList.add(this.backingList.indexOf(this.get(index)), current);
            if (current instanceof Element) {
                ((Element)current).setParent(this.parent);
            }
            super.add(index, current);
        }
    }

    public boolean add(Object o) {
        this.backingList.add(o);
        if (o instanceof Element) {
            ((Element)o).setParent(this.parent);
        }
        return super.add(o);
    }

    public boolean addAll(int index, Collection c) {
        int insertIndex = this.backingList.indexOf(this.get(index));
        if (insertIndex != -1) {
            this.backingList.addAll(insertIndex, c);
        } else {
            this.backingList.addAll(c);
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Element)) continue;
            ((Element)o).setParent(this.parent);
        }
        return super.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        int index = this.backingList.indexOf(this.getLast());
        if (index != -1) {
            this.backingList.addAll(index, c);
        } else {
            this.backingList.addAll(c);
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Element)) continue;
            ((Element)o).setParent(this.parent);
        }
        return super.addAll(c);
    }

    protected boolean addAllPartial(Collection c) {
        Iterator i = c.iterator();
        while (i.hasNext()) {
            this.addPartial(i.next());
        }
        return true;
    }

    public void addFirst(Object o) {
        int index = this.backingList.indexOf(this.getFirst());
        super.addFirst(o);
        if (index != -1) {
            this.backingList.add(index, o);
        } else {
            this.backingList.add(o);
        }
        if (o instanceof Element) {
            ((Element)o).setParent(this.parent);
        }
    }

    public void addLast(Object o) {
        int index = this.backingList.indexOf(this.getLast());
        super.addLast(o);
        if (index != -1 && index < this.backingList.size()) {
            this.backingList.add(index + 1, o);
        } else {
            this.backingList.add(o);
        }
        if (o instanceof Element) {
            ((Element)o).setParent(this.parent);
        }
    }

    protected void addPartial(Object o) {
        super.add(o);
    }

    public void clear() {
        Iterator i = this.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            this.backingList.remove(o);
            if (!(o instanceof Element)) continue;
            ((Element)o).setParent(null);
        }
        super.clear();
    }

    public Object remove(int index) {
        Object o = super.remove(index);
        this.backingList.remove(o);
        if (o instanceof Element) {
            ((Element)o).setParent(null);
        }
        return o;
    }

    public boolean remove(Object o) {
        this.backingList.remove(o);
        if (o instanceof Element) {
            ((Element)o).setParent(null);
        }
        return super.remove(o);
    }

    public Object removeFirst() {
        Object o = super.removeFirst();
        this.backingList.remove(o);
        if (o instanceof Element) {
            ((Element)o).setParent(null);
        }
        return o;
    }

    public Object removeLast() {
        Object o = super.removeLast();
        this.backingList.remove(o);
        if (o instanceof Element) {
            ((Element)o).setParent(null);
        }
        return o;
    }

    public Object set(int index, Object current) {
        Object old = this.get(index);
        int backingIndex = this.backingList.indexOf(old);
        if (backingIndex != -1) {
            this.backingList.set(backingIndex, current);
        }
        if (old instanceof Element) {
            ((Element)old).setParent(null);
        }
        if (current instanceof Element) {
            ((Element)current).setParent(this.parent);
        }
        return super.set(index, current);
    }
}

