/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import java.io.Serializable;
import java.util.StringTokenizer;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;

public class ProcessingInstruction
implements Serializable,
Cloneable {
    protected String target;
    protected String rawData;
    protected Map mapData;

    protected ProcessingInstruction() {
    }

    public ProcessingInstruction(String target, Map data) {
        String reason = Verifier.checkProcessingInstructionTarget(target);
        if (reason != null) {
            throw new IllegalTargetException(target, reason);
        }
        this.target = target;
        this.setData(data);
    }

    public ProcessingInstruction(String target, String data) {
        String reason = Verifier.checkProcessingInstructionTarget(target);
        if (reason != null) {
            throw new IllegalTargetException(target, reason);
        }
        this.target = target;
        this.setData(data);
    }

    public final Object clone() {
        ProcessingInstruction pi = new ProcessingInstruction(this.target, this.rawData);
        return pi;
    }

    public final boolean equals(Object ob) {
        return ob == this;
    }

    public String getData() {
        return this.rawData;
    }

    public final String getSerializedForm() {
        return "<?" + this.target + " " + this.rawData + "?>";
    }

    public String getTarget() {
        return this.target;
    }

    public String getValue(String name) {
        if (this.mapData.containsKey((Object)name)) {
            return (String)this.mapData.get((Object)name);
        }
        return "";
    }

    public final int hashCode() {
        return super.hashCode();
    }

    private Map parseData(String rawData) {
        HashMap data = new HashMap();
        StringTokenizer s = new StringTokenizer(rawData);
        while (s.hasMoreTokens()) {
            StringTokenizer t = new StringTokenizer(s.nextToken(), "='\"");
            if (t.countTokens() < 2) continue;
            String name = t.nextToken();
            String value = t.nextToken();
            data.put((Object)name, (Object)value);
        }
        return data;
    }

    public boolean removeValue(String name) {
        if (this.mapData.remove((Object)name) != null) {
            this.rawData = this.toString(this.mapData);
            return true;
        }
        return false;
    }

    public ProcessingInstruction setData(Map data) {
        this.rawData = this.toString(data);
        this.mapData = data;
        return this;
    }

    public ProcessingInstruction setData(String data) {
        this.rawData = data;
        this.mapData = this.parseData(data);
        return this;
    }

    public ProcessingInstruction setValue(String name, String value) {
        this.mapData.put((Object)name, (Object)value);
        this.rawData = this.toString(this.mapData);
        return this;
    }

    public final String toString() {
        return "[Processing Instruction: " + this.getSerializedForm() + "]";
    }

    private String toString(Map mapData) {
        StringBuffer rawData = new StringBuffer();
        Iterator i = mapData.keySet().iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            String value = (String)mapData.get((Object)name);
            rawData.append(name).append("=\"").append(value).append("\" ");
        }
        rawData.setLength(rawData.length() - 1);
        return rawData.toString();
    }
}

