/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.adapters.DOMAdapter;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMBuilder {
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";
    private boolean validate;
    private String adapterClass;
    private Map prefixedNamespaces;

    public DOMBuilder() {
        this(DEFAULT_ADAPTER_CLASS, false);
    }

    public DOMBuilder(String adapterClass) {
        this(adapterClass, false);
    }

    public DOMBuilder(String adapterClass, boolean validate) {
        this.adapterClass = adapterClass;
        this.validate = validate;
        this.prefixedNamespaces = new HashMap();
        this.prefixedNamespaces.put((Object)"xml", (Object)Namespace.XML_NAMESPACE);
    }

    public DOMBuilder(boolean validate) {
        this(DEFAULT_ADAPTER_CLASS, validate);
    }

    public Document build(File file) throws JDOMException {
        try {
            FileInputStream in = new FileInputStream(file);
            return this.build(in);
        }
        catch (FileNotFoundException e) {
            throw new JDOMException(e.getMessage(), e);
        }
    }

    public Document build(InputStream in) throws JDOMException {
        Document doc = new Document(null);
        try {
            DOMAdapter adapter = (DOMAdapter)Class.forName(this.adapterClass).newInstance();
            org.w3c.dom.Document domDoc = adapter.getDocument(in, this.validate);
            this.buildTree(domDoc, doc, null, true);
        }
        catch (Exception e) {
            throw new JDOMException(e.getMessage(), e);
        }
        return doc;
    }

    public Document build(URL url) throws JDOMException {
        try {
            return this.build(url.openStream());
        }
        catch (IOException e) {
            throw new JDOMException(e.getMessage(), e);
        }
    }

    public Document build(org.w3c.dom.Document domDocument) {
        Document doc = new Document(null);
        this.buildTree(domDocument, doc, null, true);
        return doc;
    }

    public Element build(org.w3c.dom.Element domElement) {
        Document doc = new Document(null);
        this.buildTree(domElement, doc, null, true);
        return doc.getRootElement();
    }

    private void buildTree(Node node, Document doc, Element current, boolean atRoot) {
        switch (node.getNodeType()) {
            case 9: {
                NodeList nodes = node.getChildNodes();
                int i = 0;
                int size = nodes.getLength();
                while (i < size) {
                    this.buildTree(nodes.item(i), doc, current, true);
                    ++i;
                }
                break;
            }
            case 1: {
                String prefix;
                NamedNodeMap attributeList = node.getAttributes();
                LinkedList elementAttributes = new LinkedList();
                int i = 0;
                int size = attributeList.getLength();
                while (i < size) {
                    Node att = attributeList.item(i);
                    if (att.getNodeName().startsWith("xmlns:")) {
                        String uri = att.getNodeValue();
                        int colon = att.getNodeName().indexOf(":");
                        prefix = colon != -1 ? att.getNodeName().substring(colon + 1) : "";
                        Namespace ns = Namespace.getNamespace(prefix, uri);
                        if (!prefix.equals("")) {
                            this.prefixedNamespaces.put((Object)prefix, (Object)ns);
                        }
                    } else {
                        elementAttributes.add((Object)att);
                    }
                    ++i;
                }
                Element element = null;
                String qualifiedName = node.getNodeName();
                int split = qualifiedName.indexOf(":");
                if (split != -1) {
                    prefix = qualifiedName.substring(0, split);
                    String localName = qualifiedName.substring(split + 1);
                    String uri = ((Namespace)this.prefixedNamespaces.get((Object)prefix)).getURI();
                    element = new Element(localName, prefix, uri);
                } else {
                    element = new Element(qualifiedName);
                }
                if (atRoot) {
                    doc.setRootElement(element);
                } else {
                    current.addContent(element);
                }
                int i2 = 0;
                int size2 = elementAttributes.size();
                while (i2 < size2) {
                    Node att = (Node)elementAttributes.get(i2);
                    if (!att.getNodeName().startsWith("xmlns:")) {
                        element.addAttribute(att.getNodeName(), att.getNodeValue());
                    }
                    ++i2;
                }
                NodeList children = node.getChildNodes();
                int i3 = 0;
                int size3 = children.getLength();
                while (i3 < size3) {
                    this.buildTree(children.item(i3), doc, element, false);
                    ++i3;
                }
                break;
            }
            case 3: {
                String text = node.getNodeValue();
                current.addContent(text);
                break;
            }
            case 4: {
                String cdata = node.getNodeValue();
                current.addContent(new CDATA(cdata));
                break;
            }
            case 7: {
                if (atRoot) {
                    doc.addContent(new ProcessingInstruction(node.getNodeName(), node.getNodeValue()));
                    break;
                }
                current.addContent(new ProcessingInstruction(node.getNodeName(), node.getNodeValue()));
                break;
            }
            case 8: {
                if (atRoot) {
                    doc.addContent(new Comment(node.getNodeValue()));
                    break;
                }
                current.addContent(new Comment(node.getNodeValue()));
                break;
            }
            case 5: {
                Entity entity = new Entity(node.getNodeName());
                entity.setContent(node.getFirstChild().getNodeValue());
                current.addContent(entity);
                break;
            }
            case 10: {
                DocumentType domDocType = (DocumentType)node;
                String publicID = domDocType.getPublicId();
                String systemID = domDocType.getSystemId();
                DocType docType = new DocType(domDocType.getName());
                if (publicID != null && !publicID.equals("")) {
                    docType.setPublicID(publicID);
                }
                if (systemID != null && !systemID.equals("")) {
                    docType.setSystemID(systemID);
                }
                doc.setDocType(docType);
                break;
            }
        }
    }
}

