/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Entity;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.adapters.DOMAdapter;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.EntityReference;
import org.w3c.dom.Text;

public class DOMOutputter {
    private static final String DEFAULT_ADAPTER_CLASS = "org.jdom.adapters.XercesDOMAdapter";

    protected void buildDOMTree(Object content, org.w3c.dom.Document doc, org.w3c.dom.Element current, boolean atRoot, LinkedList namespaces) {
        boolean printedNS = false;
        if (content instanceof Element) {
            Element element = (Element)content;
            org.w3c.dom.Element domElement = doc.createElement(element.getQualifiedName());
            Namespace ns = element.getNamespace();
            if (ns != Namespace.NO_NAMESPACE && ns != Namespace.XML_NAMESPACE && !namespaces.contains((Object)ns)) {
                String attrName = this.getXmlnsTagFor(ns);
                printedNS = true;
                namespaces.add((Object)ns);
                domElement.setAttribute(attrName, ns.getURI());
            }
            List attributes = element.getAttributes();
            int i = 0;
            int size = attributes.size();
            while (i < size) {
                Attribute attribute = (Attribute)attributes.get(i);
                Namespace ns1 = attribute.getNamespace();
                if (ns1 != Namespace.NO_NAMESPACE && ns1 != Namespace.XML_NAMESPACE && !namespaces.contains((Object)ns1)) {
                    String attrName = this.getXmlnsTagFor(ns1);
                    printedNS = true;
                    namespaces.add((Object)ns1);
                    domElement.setAttribute(attrName, ns1.getURI());
                }
                domElement.setAttribute(attribute.getQualifiedName(), attribute.getValue());
                ++i;
            }
            if (atRoot) {
                doc.appendChild(domElement);
            } else {
                current.appendChild(domElement);
            }
            List children = ((Element)content).getMixedContent();
            int i2 = 0;
            while (i2 < children.size()) {
                this.buildDOMTree(children.get(i2), doc, domElement, false, namespaces);
                ++i2;
            }
        } else if (content instanceof String) {
            Text domText = doc.createTextNode((String)content);
            current.appendChild(domText);
        } else if (content instanceof ProcessingInstruction) {
            ProcessingInstruction pi = (ProcessingInstruction)content;
            org.w3c.dom.ProcessingInstruction domPI = doc.createProcessingInstruction(pi.getTarget(), pi.getData());
            current.appendChild(domPI);
        } else if (content instanceof Comment) {
            org.w3c.dom.Comment domComment = doc.createComment(((Comment)content).getText());
            current.appendChild(domComment);
        } else if (content instanceof Entity) {
            EntityReference domEntity = doc.createEntityReference(((Entity)content).getName());
            doc.appendChild(domEntity);
        } else if (content instanceof CDATA) {
            CDATASection domCdata = doc.createCDATASection(((CDATA)content).getText());
            current.appendChild(domCdata);
        }
        if (printedNS) {
            namespaces.removeLast();
        }
    }

    public String getXmlnsTagFor(Namespace ns) {
        String attrName = "xmlns";
        if (!ns.getPrefix().equals("")) {
            attrName = String.valueOf(attrName) + ":";
            attrName = String.valueOf(attrName) + ns.getPrefix();
        }
        return attrName;
    }

    public Attr output(Attribute attribute) throws JDOMException {
        return this.output(attribute, DEFAULT_ADAPTER_CLASS);
    }

    public Attr output(Attribute attribute, String domAdapterClass) throws JDOMException {
        org.w3c.dom.Document domDoc = null;
        Attr domAttr = null;
        try {
            DOMAdapter adapter = (DOMAdapter)Class.forName(domAdapterClass).newInstance();
            domDoc = adapter.createDocument();
            domAttr = domDoc.createAttributeNS(attribute.getNamespaceURI(), attribute.getQualifiedName());
            domAttr.setValue(attribute.getValue());
        }
        catch (Exception e) {
            throw new JDOMException("Exception outputting Attribute " + attribute.getQualifiedName(), e);
        }
        return domAttr;
    }

    public org.w3c.dom.Document output(Document document) throws JDOMException {
        return this.output(document, DEFAULT_ADAPTER_CLASS);
    }

    public org.w3c.dom.Document output(Document document, String domAdapterClass) throws JDOMException {
        LinkedList namespaces = new LinkedList();
        org.w3c.dom.Document domDoc = null;
        try {
            DOMAdapter adapter = (DOMAdapter)Class.forName(domAdapterClass).newInstance();
            domDoc = adapter.createDocument();
            List docContent = document.getMixedContent();
            int i = 0;
            while (i < docContent.size()) {
                Object docObject = docContent.get(i);
                if (docObject instanceof Comment) {
                    org.w3c.dom.Comment domComment = domDoc.createComment(((Comment)docObject).getText());
                    domDoc.appendChild(domComment);
                } else if (docObject instanceof ProcessingInstruction) {
                    ProcessingInstruction pi = (ProcessingInstruction)docObject;
                    org.w3c.dom.ProcessingInstruction domPI = domDoc.createProcessingInstruction(pi.getTarget(), pi.getData());
                    domDoc.appendChild(domPI);
                } else if (docObject instanceof Element) {
                    this.buildDOMTree(docObject, domDoc, null, true, namespaces);
                } else if (docObject instanceof CDATA) {
                    CDATA cdata = (CDATA)docObject;
                    CDATASection domCdata = domDoc.createCDATASection(cdata.getText());
                    domDoc.appendChild(domCdata);
                }
                ++i;
            }
        }
        catch (Exception e) {
            throw new JDOMException("Exception outputting Document", e);
        }
        return domDoc;
    }

    public org.w3c.dom.Element output(Element element) throws JDOMException {
        return this.output(element, DEFAULT_ADAPTER_CLASS);
    }

    public org.w3c.dom.Element output(Element element, String domAdapterClass) throws JDOMException {
        LinkedList namespaces = new LinkedList();
        org.w3c.dom.Document domDoc = null;
        try {
            DOMAdapter adapter = (DOMAdapter)Class.forName(domAdapterClass).newInstance();
            domDoc = adapter.createDocument();
            this.buildDOMTree(element, domDoc, null, true, namespaces);
        }
        catch (Exception e) {
            throw new JDOMException("Exception outputting Element " + element.getQualifiedName(), e);
        }
        return domDoc.getDocumentElement();
    }
}

