/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.utils.XMLCharacterProperties;

final class StringReader
extends XMLEntityReader {
    public static final byte[] fgAsciiEntityValueChar = new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 4, 4, 0, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 0, 0, 1, 0, 0, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final char[] cdata_string = new char[]{'C', 'D', 'A', 'T', 'A', '['};
    private StringPool fStringPool = null;
    private String fData = null;
    private int fEndOffset;
    private boolean hadTrailingSpace = false;
    private boolean oweTrailingSpace = false;
    private int fMostRecentChar;
    private StringReader fNextFreeReader = null;
    private static StringReader fgFreeReaders = null;
    private boolean fCalledCharPropInit = false;
    static /* synthetic */ Class class$org$apache$xerces$readers$StringReader;

    public static StringReader createStringReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, int n, int n2, int n3, StringPool stringPool, boolean bl2) {
        StringReader stringReader = null;
        Class clazz = class$org$apache$xerces$readers$StringReader == null ? (class$org$apache$xerces$readers$StringReader = StringReader.class$("org.apache.xerces.readers.StringReader")) : class$org$apache$xerces$readers$StringReader;
        synchronized (clazz) {
            stringReader = fgFreeReaders;
            if (stringReader == null) {
                StringReader stringReader2 = new StringReader(xMLEntityHandler, xMLErrorReporter, bl, n, n2, n3, stringPool, bl2);
                return stringReader2;
            }
            fgFreeReaders = stringReader.fNextFreeReader;
        }
        stringReader.init(xMLEntityHandler, xMLErrorReporter, bl, n, n2, n3, stringPool, bl2);
        return stringReader;
    }

    private StringReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, int n, int n2, int n3, StringPool stringPool, boolean bl2) {
        super(xMLEntityHandler, xMLErrorReporter, bl, n, n2);
        this.fStringPool = stringPool;
        this.fData = this.fStringPool.toString(n3);
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        if (bl2) {
            this.fMostRecentChar = 32;
            --this.fCurrentOffset;
            this.hadTrailingSpace = true;
            this.oweTrailingSpace = true;
        } else {
            this.fMostRecentChar = this.fEndOffset == 0 ? -1 : (int)this.fData.charAt(0);
        }
    }

    private void init(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, int n, int n2, int n3, StringPool stringPool, boolean bl2) {
        super.init(xMLEntityHandler, xMLErrorReporter, bl, n, n2);
        this.fStringPool = stringPool;
        this.fData = this.fStringPool.toString(n3);
        this.fCurrentOffset = 0;
        this.fEndOffset = this.fData.length();
        this.fNextFreeReader = null;
        if (bl2) {
            this.fMostRecentChar = 32;
            --this.fCurrentOffset;
            this.hadTrailingSpace = true;
            this.oweTrailingSpace = true;
        } else {
            this.fMostRecentChar = this.fEndOffset == 0 ? -1 : (int)this.fData.charAt(0);
            this.hadTrailingSpace = false;
            this.oweTrailingSpace = false;
        }
    }

    public int addString(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addString(this.fData.substring(n, n + n2));
    }

    public int addSymbol(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        return this.fStringPool.addSymbol(this.fData.substring(n, n + n2));
    }

    public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            try {
                charBuffer.append(this.fData.charAt(n++));
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                if (n == this.fEndOffset + 1 && this.hadTrailingSpace) {
                    charBuffer.append(' ');
                }
                System.err.println("StringReader.append()");
                throw stringIndexOutOfBoundsException;
            }
            ++n3;
        }
    }

    private int loadNextChar() {
        if (++this.fCurrentOffset >= this.fEndOffset) {
            if (this.oweTrailingSpace) {
                this.oweTrailingSpace = false;
                this.fMostRecentChar = 32;
            } else {
                this.fMostRecentChar = -1;
            }
        } else {
            this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
        }
        return this.fMostRecentChar;
    }

    public XMLEntityHandler.EntityReader changeReaders() throws Exception {
        XMLEntityHandler.EntityReader entityReader = super.changeReaders();
        Class clazz = class$org$apache$xerces$readers$StringReader == null ? (class$org$apache$xerces$readers$StringReader = StringReader.class$("org.apache.xerces.readers.StringReader")) : class$org$apache$xerces$readers$StringReader;
        synchronized (clazz) {
            this.fNextFreeReader = fgFreeReaders;
            fgFreeReaders = this;
        }
        return entityReader;
    }

    public boolean lookingAtChar(char c, boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n != c) {
            if (n == -1) {
                return this.changeReaders().lookingAtChar(c, bl);
            }
            return false;
        }
        if (bl) {
            if (++this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    this.fMostRecentChar = 32;
                } else {
                    this.fMostRecentChar = -1;
                }
            } else {
                this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
            }
        }
        return true;
    }

    public boolean lookingAtValidChar(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 55296) {
            if (n < 32 && n != 9 && n != 10 && n != 13) {
                if (n == -1) {
                    return this.changeReaders().lookingAtValidChar(bl);
                }
                return false;
            }
            if (bl) {
                if (++this.fCurrentOffset >= this.fEndOffset) {
                    if (this.oweTrailingSpace) {
                        this.oweTrailingSpace = false;
                        this.fMostRecentChar = 32;
                    } else {
                        this.fMostRecentChar = -1;
                    }
                } else {
                    this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
                }
            }
            return true;
        }
        if (n > 65533) {
            return false;
        }
        if (n < 56320) {
            if (this.fCurrentOffset + 1 >= this.fEndOffset) {
                return false;
            }
            n = this.fData.charAt(this.fCurrentOffset + 1);
            if (n < 56320 || n >= 57344) {
                return false;
            }
            if (!bl) {
                return true;
            }
            ++this.fCurrentOffset;
        } else if (n < 57344) {
            return false;
        }
        if (bl) {
            if (++this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    this.fMostRecentChar = 32;
                } else {
                    this.fMostRecentChar = -1;
                }
            } else {
                this.fMostRecentChar = this.fData.charAt(this.fCurrentOffset);
            }
        }
        return true;
    }

    public boolean lookingAtSpace(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n > 32) {
            return false;
        }
        if (n == 32 || n == 10 || n == 13 || n == 9) {
            if (bl) {
                this.loadNextChar();
            }
            return true;
        }
        if (n == -1) {
            return this.changeReaders().lookingAtSpace(bl);
        }
        return false;
    }

    public void skipToChar(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (n != c) {
            if (n == -1) {
                this.changeReaders().skipToChar(c);
                return;
            }
            n = this.loadNextChar();
        }
        return;
    }

    public void skipPastSpaces() throws Exception {
        int n = this.fMostRecentChar;
        if (n == -1) {
            this.changeReaders().skipPastSpaces();
            return;
        }
        while (true) {
            if (n > 32 || n != 32 && n != 10 && n != 9 && n != 13) {
                this.fMostRecentChar = n;
                return;
            }
            if (++this.fCurrentOffset >= this.fEndOffset) {
                this.changeReaders().skipPastSpaces();
                return;
            }
            n = this.fData.charAt(this.fCurrentOffset);
        }
    }

    public void skipPastName(char c) throws Exception {
        int n = this.fMostRecentChar;
        if (n < 128) {
            if (n == -1 || XMLCharacterProperties.fgAsciiInitialNameChar[n] == 0) {
                return;
            }
        } else {
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
                return;
            }
        }
        while (true) {
            if (c == (n = this.loadNextChar())) {
                return;
            }
            if (n < 128) {
                if (n != -1 && XMLCharacterProperties.fgAsciiNameChar[n] != 0) continue;
                return;
            }
            if (!this.fCalledCharPropInit) {
                XMLCharacterProperties.initCharFlags();
                this.fCalledCharPropInit = true;
            }
            if ((XMLCharacterProperties.fgCharFlags[n] & 4) == 0) break;
        }
    }

    public void skipPastNmtoken(char c) throws Exception {
        int n = this.fMostRecentChar;
        while (c != n) {
            if (n < 128) {
                if (n == -1 || XMLCharacterProperties.fgAsciiNameChar[n] == 0) {
                    return;
                }
            } else {
                if (!this.fCalledCharPropInit) {
                    XMLCharacterProperties.initCharFlags();
                    this.fCalledCharPropInit = true;
                }
                if ((XMLCharacterProperties.fgCharFlags[n] & 4) == 0) {
                    return;
                }
            }
            n = this.loadNextChar();
        }
        return;
    }

    public boolean skippedString(char[] cArray) throws Exception {
        int n = this.fMostRecentChar;
        if (n != cArray[0]) {
            if (n == -1) {
                return this.changeReaders().skippedString(cArray);
            }
            return false;
        }
        if (this.fCurrentOffset + cArray.length > this.fEndOffset) {
            return false;
        }
        int n2 = 1;
        while (n2 < cArray.length) {
            if (this.fData.charAt(this.fCurrentOffset + n2) != cArray[n2]) {
                return false;
            }
            ++n2;
        }
        this.fCurrentOffset += cArray.length - 1;
        this.loadNextChar();
        return true;
    }

    public int scanInvalidChar() throws Exception {
        int n = this.fMostRecentChar;
        if (n == -1) {
            return this.changeReaders().scanInvalidChar();
        }
        this.loadNextChar();
        return n;
    }

    public int scanCharRef(boolean bl) throws Exception {
        int n = this.fMostRecentChar;
        if (n == -1) {
            return this.changeReaders().scanCharRef(bl);
        }
        int n2 = 0;
        if (bl) {
            if (n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) {
                return -2;
            }
            n2 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
        } else {
            if (n < 48 || n > 57) {
                return -2;
            }
            n2 = n - 48;
        }
        boolean bl2 = false;
        while (true) {
            int n3;
            if ((n = this.loadNextChar()) == -1) {
                return -1;
            }
            if (!bl ? n < 48 || n > 57 : n > 102 || XMLCharacterProperties.fgAsciiXDigitChar[n] == 0) break;
            if (bl) {
                n3 = n - (n < 65 ? 48 : (n < 97 ? 65 : 97) - 10);
                n2 = (n2 << 4) + n3;
            } else {
                n3 = n - 48;
                n2 = n2 * 10 + n3;
            }
            if (n2 <= 0x10FFFF) continue;
            bl2 = true;
            n2 = 0;
        }
        if (n != 59) {
            return -1;
        }
        this.loadNextChar();
        if (bl2) {
            return -3;
        }
        return n2;
    }

    public int scanStringLiteral() throws Exception {
        boolean bl = this.lookingAtChar('\'', true);
        if (!bl && !this.lookingAtChar('\"', true)) {
            return -1;
        }
        int n = this.fCurrentOffset;
        char c = bl ? (char)'\'' : '\"';
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtValidChar(true)) continue;
            return -2;
        }
        int n2 = this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanAttValue(char c, boolean bl) throws Exception {
        int n = this.fCurrentOffset;
        while (!this.lookingAtChar(c, false)) {
            if (this.lookingAtChar(' ', true)) continue;
            if (this.lookingAtSpace(false)) {
                return -1;
            }
            if (this.lookingAtChar('&', false)) {
                return -1;
            }
            if (this.lookingAtChar('<', false)) {
                return -2;
            }
            if (this.lookingAtValidChar(true)) continue;
            return -3;
        }
        int n2 = bl ? this.addSymbol(n, this.fCurrentOffset - n) : this.addString(n, this.fCurrentOffset - n);
        this.lookingAtChar(c, true);
        return n2;
    }

    public int scanEntityValue(int n, boolean bl) throws Exception {
        int n2 = this.fCurrentOffset;
        int n3 = this.fMostRecentChar;
        block7: while (true) {
            if (n3 == -1) {
                this.changeReaders();
                return -5;
            }
            if (n3 < 128) {
                switch (fgAsciiEntityValueChar[n3]) {
                    case 1: {
                        if (n3 == n) {
                            if (!bl) {
                                return -1;
                            }
                            int n4 = this.fCurrentOffset - n2;
                            int n5 = n4 == 0 ? 0 : this.addString(n2, n4);
                            this.loadNextChar();
                            return n5;
                        }
                    }
                    case 0: {
                        if (++this.fCurrentOffset >= this.fEndOffset) {
                            if (this.oweTrailingSpace) {
                                this.oweTrailingSpace = false;
                                this.fMostRecentChar = 32;
                                n3 = 32;
                                continue block7;
                            }
                            this.fMostRecentChar = -1;
                            n3 = -1;
                            continue block7;
                        }
                        char c = this.fData.charAt(this.fCurrentOffset);
                        this.fMostRecentChar = c;
                        n3 = c;
                        continue block7;
                    }
                    case 2: {
                        return -2;
                    }
                    case 3: {
                        return -3;
                    }
                    case 4: {
                        return -4;
                    }
                }
                continue;
            }
            if (n3 < 55296) {
                n3 = this.loadNextChar();
                continue;
            }
            if (n3 < 57344 || n3 > 65533 && (n3 < 65536 || n3 > 0x10FFFF)) break;
            n3 = this.loadNextChar();
        }
        return -4;
    }

    public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws Exception {
        int n = this.fMostRecentChar;
        if (n == -1) {
            return this.changeReaders().scanExpectedName(c, charArrayRange);
        }
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int n2 = this.fCurrentOffset;
        if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
            return false;
        }
        while (c != (n = this.loadNextChar()) && n != -1 && (XMLCharacterProperties.fgCharFlags[n] & 4) != 0) {
        }
        int n3 = this.fStringPool.addSymbol(this.fData.substring(n2, this.fCurrentOffset));
        return true;
    }

    public void scanQName(char c, QName qName) throws Exception {
        int n = this.fMostRecentChar;
        if (n == -1) {
            this.changeReaders().scanQName(c, qName);
            return;
        }
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int n2 = this.fCurrentOffset;
        if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
            qName.clear();
            return;
        }
        while (c != (n = this.loadNextChar()) && n != -1 && (XMLCharacterProperties.fgCharFlags[n] & 4) != 0) {
        }
        qName.clear();
        qName.rawname = this.fStringPool.addSymbol(this.fData.substring(n2, this.fCurrentOffset));
        int n3 = this.fData.indexOf(58, n2);
        if (n3 != -1) {
            String string;
            qName.prefix = this.fStringPool.addSymbol(this.fData.substring(n2, n3));
            int n4 = this.fData.indexOf(32, n3 + 1);
            if (n4 != -1) {
                string = this.fData.substring(n3 + 1, n4);
                qName.localpart = this.fStringPool.addSymbol(string);
            } else {
                int n5 = this.fData.length();
                string = this.fData.substring(n3 + 1, n5);
                qName.localpart = this.fStringPool.addSymbol(string);
            }
            qName.localpart = this.fStringPool.addSymbol(string);
        } else {
            qName.localpart = qName.rawname;
        }
    }

    public int scanName(char c) throws Exception {
        char c2;
        int n = this.fMostRecentChar;
        if (n == -1) {
            return this.changeReaders().scanName(c);
        }
        if (!this.fCalledCharPropInit) {
            XMLCharacterProperties.initCharFlags();
            this.fCalledCharPropInit = true;
        }
        int n2 = this.fCurrentOffset;
        if ((XMLCharacterProperties.fgCharFlags[n] & 2) == 0) {
            return -1;
        }
        do {
            if (++this.fCurrentOffset >= this.fEndOffset) {
                if (this.oweTrailingSpace) {
                    this.oweTrailingSpace = false;
                    this.fMostRecentChar = 32;
                    break;
                }
                this.fMostRecentChar = -1;
                break;
            }
            c2 = this.fData.charAt(this.fCurrentOffset);
            this.fMostRecentChar = c2;
        } while (c != (n = (int)c2) && (XMLCharacterProperties.fgCharFlags[n] & 4) != 0);
        int n3 = this.fStringPool.addSymbol(this.fData.substring(n2, this.fCurrentOffset));
        return n3;
    }

    private int recognizeMarkup(int n) throws Exception {
        if (n == -1) {
            return 11;
        }
        switch (n) {
            case 63: {
                this.loadNextChar();
                return 0;
            }
            case 33: {
                n = this.loadNextChar();
                if (n == -1) {
                    this.fCurrentOffset -= 2;
                    this.loadNextChar();
                    return 11;
                }
                if (n == 45) {
                    n = this.loadNextChar();
                    if (n == -1) {
                        this.fCurrentOffset -= 3;
                        this.loadNextChar();
                        return 11;
                    }
                    if (n != 45) break;
                    this.loadNextChar();
                    return 1;
                }
                if (n != 91) break;
                int n2 = 0;
                while (n2 < 6) {
                    n = this.loadNextChar();
                    if (n == -1) {
                        this.fCurrentOffset -= 3 + n2;
                        this.loadNextChar();
                        return 11;
                    }
                    if (n != cdata_string[n2]) {
                        return 10;
                    }
                    ++n2;
                }
                this.loadNextChar();
                return 2;
            }
            case 47: {
                this.loadNextChar();
                return 4;
            }
            default: {
                return 6;
            }
        }
        return 10;
    }

    private int recognizeReference(int n) throws Exception {
        if (n == -1) {
            return 11;
        }
        if (n == 35) {
            this.loadNextChar();
            return 7;
        }
        return 8;
    }

    public int scanContent(QName qName) throws Exception {
        int n = this.fMostRecentChar;
        if (n == -1) {
            return this.changeReaders().scanContent(qName);
        }
        int n2 = this.fCurrentOffset;
        if (n < 128) {
            block0 : switch (XMLCharacterProperties.fgAsciiWSCharData[n]) {
                case 0: {
                    n = this.loadNextChar();
                    break;
                }
                case 1: {
                    n = this.loadNextChar();
                    if (this.fInCDSect) break;
                    return this.recognizeMarkup(n);
                }
                case 2: {
                    n = this.loadNextChar();
                    if (this.fInCDSect) break;
                    return this.recognizeReference(n);
                }
                case 3: {
                    n = this.loadNextChar();
                    if (n != 93 || this.fCurrentOffset + 1 >= this.fEndOffset || this.fData.charAt(this.fCurrentOffset + 1) != '>') break;
                    this.loadNextChar();
                    this.loadNextChar();
                    return 3;
                }
                case 4: {
                    return 9;
                }
                case 5: {
                    do {
                        if ((n = this.loadNextChar()) != -1) continue;
                        this.callCharDataHandler(n2, this.fEndOffset, true);
                        return this.changeReaders().scanContent(qName);
                    } while (n == 32 || n == 10 || n == 13 || n == 9);
                    if (n < 128) {
                        switch (XMLCharacterProperties.fgAsciiCharData[n]) {
                            case 0: {
                                n = this.loadNextChar();
                                break block0;
                            }
                            case 1: {
                                n = this.loadNextChar();
                                if (this.fInCDSect) break;
                                this.callCharDataHandler(n2, this.fCurrentOffset - 1, true);
                                return this.recognizeMarkup(n);
                            }
                            case 2: {
                                n = this.loadNextChar();
                                if (this.fInCDSect) break;
                                this.callCharDataHandler(n2, this.fCurrentOffset - 1, true);
                                return this.recognizeReference(n);
                            }
                            case 3: {
                                n = this.loadNextChar();
                                if (n != 93 || this.fCurrentOffset + 1 >= this.fEndOffset || this.fData.charAt(this.fCurrentOffset + 1) != '>') break;
                                this.callCharDataHandler(n2, this.fCurrentOffset - 1, true);
                                this.loadNextChar();
                                this.loadNextChar();
                                return 3;
                            }
                            case 4: {
                                this.callCharDataHandler(n2, this.fCurrentOffset, true);
                                return 9;
                            }
                        }
                        break;
                    }
                    if (n == 65534 || n == 65535) {
                        this.callCharDataHandler(n2, this.fCurrentOffset, true);
                        return 9;
                    }
                    n = this.loadNextChar();
                }
            }
        } else {
            if (n == 65534 || n == 65535) {
                this.callCharDataHandler(n2, this.fCurrentOffset, false);
                return 9;
            }
            n = this.loadNextChar();
        }
        while (true) {
            if (n == -1) {
                this.callCharDataHandler(n2, this.fEndOffset, false);
                return this.changeReaders().scanContent(qName);
            }
            if (n >= 128 || XMLCharacterProperties.fgAsciiCharData[n] != 0) break;
            n = this.loadNextChar();
        }
        do {
            if (n < 128) {
                switch (XMLCharacterProperties.fgAsciiCharData[n]) {
                    case 0: {
                        n = this.loadNextChar();
                        break;
                    }
                    case 1: {
                        n = this.loadNextChar();
                        if (this.fInCDSect) break;
                        this.callCharDataHandler(n2, this.fCurrentOffset - 1, false);
                        return this.recognizeMarkup(n);
                    }
                    case 2: {
                        n = this.loadNextChar();
                        if (this.fInCDSect) break;
                        this.callCharDataHandler(n2, this.fCurrentOffset - 1, false);
                        return this.recognizeReference(n);
                    }
                    case 3: {
                        n = this.loadNextChar();
                        if (n != 93 || this.fCurrentOffset + 1 >= this.fEndOffset || this.fData.charAt(this.fCurrentOffset + 1) != '>') break;
                        this.callCharDataHandler(n2, this.fCurrentOffset - 1, false);
                        this.loadNextChar();
                        this.loadNextChar();
                        return 3;
                    }
                    case 4: {
                        this.callCharDataHandler(n2, this.fCurrentOffset, false);
                        return 9;
                    }
                }
                continue;
            }
            if (n == 65534 || n == 65535) {
                this.callCharDataHandler(n2, this.fCurrentOffset, false);
                return 9;
            }
            n = this.loadNextChar();
        } while (n != -1);
        this.callCharDataHandler(n2, this.fCurrentOffset, false);
        return this.changeReaders().scanContent(qName);
    }

    private void callCharDataHandler(int n, int n2, boolean bl) throws Exception {
        int n3 = n2 - n;
        if (!this.fSendCharDataAsCharArray) {
            int n4 = this.addString(n, n3);
            if (bl) {
                this.fCharDataHandler.processWhitespace(n4);
            } else {
                this.fCharDataHandler.processCharacters(n4);
            }
            return;
        }
        if (bl) {
            this.fCharDataHandler.processWhitespace(this.fData.toCharArray(), n, n3);
        } else {
            this.fCharDataHandler.processCharacters(this.fData.toCharArray(), n, n3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

