/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.validators.schema;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.framework.XMLContentSpec;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.utils.NamespacesScope;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;
import org.apache.xerces.validators.common.Grammar;
import org.apache.xerces.validators.common.GrammarResolver;
import org.apache.xerces.validators.common.GrammarResolverImpl;
import org.apache.xerces.validators.common.XMLAttributeDecl;
import org.apache.xerces.validators.common.XMLElementDecl;
import org.apache.xerces.validators.datatype.DatatypeValidator;
import org.apache.xerces.validators.datatype.DatatypeValidatorFactoryImpl;
import org.apache.xerces.validators.datatype.InvalidDatatypeValueException;
import org.apache.xerces.validators.schema.SchemaGrammar;
import org.apache.xerces.validators.schema.SchemaMessageProvider;
import org.apache.xerces.validators.schema.XUtil;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class TraverseSchema
implements NamespacesScope.NamespacesHandler {
    private static final int TOP_LEVEL_SCOPE = -1;
    private static boolean DEBUGGING = false;
    private XMLErrorReporter fErrorReporter = null;
    private StringPool fStringPool = null;
    private GrammarResolver fGrammarResolver = null;
    private SchemaGrammar fSchemaGrammar = null;
    private Element fSchemaRootElement;
    private DatatypeValidatorFactoryImpl fDatatypeRegistry = DatatypeValidatorFactoryImpl.getDatatypeRegistry();
    private Hashtable fComplexTypeRegistry = new Hashtable();
    private Hashtable fAttributeDeclRegistry = new Hashtable();
    private Vector fIncludeLocations = new Vector();
    private Vector fImportLocations = new Vector();
    private int fAnonTypeCount = 0;
    private int fScopeCount = 0;
    private int fCurrentScope = -1;
    private int fSimpleTypeAnonCount = 0;
    private Stack fCurrentTypeNameStack = new Stack();
    private Hashtable fElementRecurseComplex = new Hashtable();
    private boolean fElementDefaultQualified = false;
    private boolean fAttributeDefaultQualified = false;
    private int fTargetNSURI;
    private String fTargetNSURIString = "";
    private NamespacesScope fNamespacesScope = null;
    private String fCurrentSchemaURL = "";
    private XMLAttributeDecl fTempAttributeDecl = new XMLAttributeDecl();
    private XMLElementDecl fTempElementDecl = new XMLElementDecl();
    public static final String SchemaForSchemaURI = "http://www.w3.org/TR-1/Schema";

    private TraverseSchema() {
    }

    public void setGrammarResolver(GrammarResolver grammarResolver) {
        this.fGrammarResolver = grammarResolver;
    }

    public void startNamespaceDeclScope(int n, int n2) {
    }

    public void endNamespaceDeclScope(int n) {
    }

    private String resolvePrefixToURI(String string) throws Exception {
        String string2 = this.fStringPool.toString(this.fNamespacesScope.getNamespaceForPrefix(this.fStringPool.addSymbol(string)));
        if (string2 == null) {
            this.reportGenericSchemaError("prefix : [" + string + "] can not be resolved to a URI");
            return "";
        }
        if (string.length() == 0 && string2.equals("http://www.w3.org/1999/XMLSchema") && this.fTargetNSURIString.length() == 0) {
            string2 = "";
        }
        return string2;
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver, XMLErrorReporter xMLErrorReporter, String string) throws Exception {
        this.fErrorReporter = xMLErrorReporter;
        this.fCurrentSchemaURL = string;
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public TraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        this.doTraverseSchema(element, stringPool, schemaGrammar, grammarResolver);
    }

    public void doTraverseSchema(Element element, StringPool stringPool, SchemaGrammar schemaGrammar, GrammarResolver grammarResolver) throws Exception {
        String string;
        Object object;
        Object object2;
        this.fNamespacesScope = new NamespacesScope(this);
        this.fSchemaRootElement = element;
        this.fStringPool = stringPool;
        this.fSchemaGrammar = schemaGrammar;
        this.fGrammarResolver = grammarResolver;
        if (element == null) {
            return;
        }
        String string2 = element.getPrefix();
        if ((string2 == null || string2.length() == 0) && ((String)(object2 = element.getAttribute("xmlns"))).length() == 0) {
            element.setAttribute("xmlns", "http://www.w3.org/1999/XMLSchema");
        }
        this.fTargetNSURIString = element.getAttribute("targetNamespace");
        if (this.fTargetNSURIString == null) {
            this.fTargetNSURIString = "";
        }
        this.fTargetNSURI = this.fStringPool.addSymbol(this.fTargetNSURIString);
        if (this.fGrammarResolver == null) {
            this.reportGenericSchemaError("Internal error: don't have a GrammarResolver for TraverseSchema");
        } else {
            if (this.fSchemaGrammar.getComplexTypeRegistry() == null) {
                this.fSchemaGrammar.setComplexTypeRegistry(this.fComplexTypeRegistry);
            } else {
                this.fComplexTypeRegistry = this.fSchemaGrammar.getComplexTypeRegistry();
            }
            if (this.fSchemaGrammar.getAttirubteDeclRegistry() == null) {
                this.fSchemaGrammar.setAttributeDeclRegistry(this.fAttributeDeclRegistry);
            } else {
                this.fAttributeDeclRegistry = this.fSchemaGrammar.getAttirubteDeclRegistry();
            }
            if (this.fSchemaGrammar.getNamespacesScope() == null) {
                this.fSchemaGrammar.setNamespacesScope(this.fNamespacesScope);
            } else {
                this.fNamespacesScope = this.fSchemaGrammar.getNamespacesScope();
            }
            this.fSchemaGrammar.setDatatypeRegistry(this.fDatatypeRegistry);
            this.fSchemaGrammar.setTargetNamespaceURI(this.fTargetNSURIString);
            this.fGrammarResolver.putGrammar(this.fTargetNSURIString, this.fSchemaGrammar);
        }
        object2 = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)object2.item(n++)) != null) {
            object = attr.getName();
            if (((String)object).startsWith("xmlns:")) {
                string = attr.getValue();
                String string3 = ((String)object).substring(((String)object).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string3), this.fStringPool.addSymbol(string));
            }
            if (!((String)object).equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            string = object.getNodeName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("element")) {
                this.traverseElementDecl((Element)object);
            } else if (!string.equals("attributeGroup")) {
                if (string.equals("attribute")) {
                    this.traverseAttributeDecl((Element)object, null);
                } else if (!(string.equals("group") && object.getAttribute("ref").equals("") || string.equals("notation"))) {
                    if (string.equals("include")) {
                        this.traverseInclude((Element)object);
                    } else if (string.equals("import")) {
                        this.traverseImport((Element)object);
                    }
                }
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    private void checkTopLevelDuplicateNames(Element element) {
    }

    private void extractTopLevel3Components(Element element) {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            String string = element2.getNodeName();
            if (string.equals("attributeGroup")) {
                this.fSchemaGrammar.topLevelAttrGrpDecls.put(string, element2);
            } else if (string.equals("attribute")) {
                this.fSchemaGrammar.topLevelAttrDecls.put(string, element2);
            } else if (string.equals("group") && element2.getAttribute("ref").equals("")) {
                this.fSchemaGrammar.topLevelGroupDecls.put(string, element2);
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
    }

    private String expandSystemId(String string, String string2) throws Exception {
        URL uRL;
        String string3 = string;
        if (string3 == null || string3.length() == 0) {
            return string;
        }
        try {
            uRL = new URL(string3);
            if (uRL != null) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        string3 = TraverseSchema.fixURI(string3);
        uRL = null;
        URL uRL2 = null;
        try {
            if (string2 == null) {
                String string4;
                try {
                    string4 = TraverseSchema.fixURI(System.getProperty("user.dir"));
                }
                catch (SecurityException securityException) {
                    string4 = "";
                }
                if (!string4.endsWith("/")) {
                    string4 = string4 + "/";
                }
                uRL = new URL("file", "", string4);
            } else {
                uRL = new URL(string2);
            }
            uRL2 = new URL(uRL, string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uRL2 == null) {
            return string;
        }
        return uRL2.toString();
    }

    private static String fixURI(String string) {
        char c;
        char c2;
        if ((string = string.replace(File.separatorChar, '/')).length() >= 2 && (c2 = string.charAt(1)) == ':' && (c = Character.toUpperCase(string.charAt(0))) >= 'A' && c <= 'Z') {
            string = "/" + string;
        }
        return string;
    }

    private void traverseInclude(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        if (this.fIncludeLocations.contains(string = this.expandSystemId(string, this.fCurrentSchemaURL))) {
            return;
        }
        this.fIncludeLocations.addElement(string);
        DOMParser dOMParser = new DOMParser(){

            public void ignorableWhitespace(char[] cArray, int n, int n2) {
            }

            public void ignorableWhitespace(int n) {
            }
        };
        dOMParser.setEntityResolver(new Resolver());
        dOMParser.setErrorHandler(new ErrorHandler());
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            dOMParser.parse(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        Document document = dOMParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string2 = element2.getAttribute("targetNamespace");
            if (string2.length() > 0 && !string2.equals(this.fTargetNSURIString)) {
                this.reportGenericSchemaError("included schema '" + string + "' has a different targetNameSpace '" + string2 + "'");
            } else {
                boolean bl = this.fElementDefaultQualified;
                boolean bl2 = this.fAttributeDefaultQualified;
                int n = this.fCurrentScope;
                String string3 = this.fCurrentSchemaURL;
                Element element3 = this.fSchemaRootElement;
                this.fSchemaRootElement = element2;
                this.fCurrentSchemaURL = string;
                this.traverseIncludedSchema(element2);
                this.fCurrentSchemaURL = string3;
                this.fCurrentScope = n;
                this.fElementDefaultQualified = bl;
                this.fAttributeDefaultQualified = bl2;
                this.fSchemaRootElement = element3;
            }
        }
    }

    private void traverseIncludedSchema(Element element) throws Exception {
        String string;
        Object object;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = 0;
        Attr attr = null;
        boolean bl = false;
        while ((attr = (Attr)namedNodeMap.item(n++)) != null) {
            object = attr.getName();
            if (((String)object).startsWith("xmlns:")) {
                string = attr.getValue();
                String string2 = ((String)object).substring(((String)object).indexOf(":") + 1);
                this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(string2), this.fStringPool.addSymbol(string));
            }
            if (!((String)object).equals("xmlns")) continue;
            string = attr.getValue();
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(string));
            bl = true;
        }
        if (!bl && this.fTargetNSURIString.length() == 0) {
            this.fNamespacesScope.setNamespaceForPrefix(this.fStringPool.addSymbol(""), this.fStringPool.addSymbol(""));
        }
        this.fElementDefaultQualified = element.getAttribute("elementFormDefault").equals("qualified");
        this.fAttributeDefaultQualified = element.getAttribute("attributeFormDefault").equals("qualified");
        if (this.fTargetNSURI == 0) {
            this.fElementDefaultQualified = true;
        }
        this.fCurrentScope = -1;
        this.checkTopLevelDuplicateNames(element);
        this.extractTopLevel3Components(element);
        object = XUtil.getFirstChildElement(element);
        while (object != null) {
            string = object.getNodeName();
            if (string.equals("annotation")) {
                this.traverseAnnotationDecl((Element)object);
            } else if (string.equals("simpleType")) {
                this.traverseSimpleTypeDecl((Element)object);
            } else if (string.equals("complexType")) {
                this.traverseComplexTypeDecl((Element)object);
            } else if (string.equals("element")) {
                this.traverseElementDecl((Element)object);
            } else if (!string.equals("attributeGroup")) {
                if (string.equals("attribute")) {
                    this.traverseAttributeDecl((Element)object, null);
                } else if (!(string.equals("group") && object.getAttribute("ref").equals("") || string.equals("notation"))) {
                    if (string.equals("include")) {
                        this.traverseInclude((Element)object);
                    } else if (string.equals("import")) {
                        this.traverseImport((Element)object);
                    }
                }
            }
            object = XUtil.getNextSiblingElement((Node)object);
        }
    }

    private void traverseImport(Element element) throws Exception {
        String string = element.getAttribute("schemaLocation");
        string = this.expandSystemId(string, this.fCurrentSchemaURL);
        String string2 = element.getAttribute("namespace");
        SchemaGrammar schemaGrammar = new SchemaGrammar();
        if (this.fGrammarResolver.getGrammar(string2) != null) {
            schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        }
        if (this.fImportLocations.contains(string)) {
            return;
        }
        this.fImportLocations.addElement(string);
        DOMParser dOMParser = new DOMParser(){

            public void ignorableWhitespace(char[] cArray, int n, int n2) {
            }

            public void ignorableWhitespace(int n) {
            }
        };
        dOMParser.setEntityResolver(new Resolver());
        dOMParser.setErrorHandler(new ErrorHandler());
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://xml.org/sax/features/namespaces", true);
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            dOMParser.parse(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = dOMParser.getDocument();
        Element element2 = null;
        if (document != null) {
            element2 = document.getDocumentElement();
        }
        if (element2 != null) {
            String string3 = element2.getAttribute("targetNamespace");
            if (!string3.equals(string2)) {
                this.reportGenericSchemaError("imported schema '" + string + "' has a different targetNameSpace '" + string3 + "' from what is declared '" + string2 + "'.");
            } else {
                new TraverseSchema(element2, this.fStringPool, schemaGrammar, this.fGrammarResolver, this.fErrorReporter, string);
            }
        } else {
            this.reportGenericSchemaError("Could not get the doc root for imported Schema file: " + string);
        }
    }

    private void traverseAnnotationDecl(Element element) {
    }

    private int traverseSimpleTypeDecl(Element element) throws Exception {
        Object object;
        String string;
        Object object2;
        String string2 = element.getAttribute("derivedBy");
        if (string2.length() == 0) {
            string2 = "restriction";
        }
        String string3 = element.getAttribute("name");
        String string4 = element.getAttribute("base");
        String string5 = element.getAttribute("abstract");
        int n = -1;
        n = string3.equals("") ? this.fStringPool.addSymbol("#S#" + this.fSimpleTypeAnonCount++) : this.fStringPool.addSymbol(string3);
        DatatypeValidator datatypeValidator = null;
        if (string4 != null) {
            int n2 = this.fStringPool.addSymbol(string4);
            object2 = "";
            String string6 = string4;
            int n3 = string4.indexOf(":");
            if (n3 > 0) {
                object2 = string4.substring(0, n3);
                string6 = string4.substring(n3 + 1);
            }
            if ((datatypeValidator = this.getDatatypeValidator(string = this.resolvePrefixToURI((String)object2), string6)) == null) {
                object = this.getTopLevelComponentByName("simpleType", string6);
                if (object != null) {
                    this.traverseSimpleTypeDecl((Element)object);
                    datatypeValidator = this.getDatatypeValidator(string, string6);
                    if (datatypeValidator == null) {
                        this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
                        return -1;
                    }
                } else {
                    this.reportSchemaError(15, new Object[]{element.getAttribute("base"), element.getAttribute("name")});
                    return -1;
                }
            }
        }
        object2 = XUtil.getFirstChildElement(element);
        int n4 = 0;
        Hashtable<String, Object> hashtable = null;
        if (object2 != null) {
            if (object2.getNodeName().equals("annotation")) {
                this.traverseAnnotationDecl((Element)object2);
                object2 = XUtil.getNextSiblingElement((Node)object2);
            }
            int n5 = 0;
            hashtable = new Hashtable<String, Object>();
            object = new Vector();
            while (object2 != null) {
                if (object2.getNodeType() == 1) {
                    Object object3 = object2;
                    ++n4;
                    if (object3.getNodeName().equals("enumeration")) {
                        ++n5;
                        String string7 = object3.getAttribute("value");
                        ((Vector)object).addElement(string7);
                        Element element2 = XUtil.getFirstChildElement((Node)object3);
                        if (element2 != null && element2 != null && element2.getNodeName().equals("annotation")) {
                            this.traverseAnnotationDecl((Element)object2);
                        }
                    } else {
                        hashtable.put(object3.getNodeName(), object3.getAttribute("value"));
                    }
                }
                object2 = XUtil.getNextSiblingElement((Node)object2);
            }
            if (n5 > 0) {
                hashtable.put("enumeration", object);
            }
        }
        string = this.fStringPool.toString(n);
        if (this.fTargetNSURIString.length() != 0) {
            string = this.fTargetNSURIString + "," + string;
        }
        try {
            object = this.fDatatypeRegistry.getDatatypeValidator(string);
            if (object == null) {
                boolean bl = string2.equals("list");
                this.fDatatypeRegistry.createDatatypeValidator(string, datatypeValidator, hashtable, bl);
            }
        }
        catch (Exception exception) {
            this.reportSchemaError(21, new Object[]{exception.getMessage()});
        }
        return this.fStringPool.addSymbol(string);
    }

    private int traverseAny(Element element) throws Exception {
        int n = -1;
        String string = element.getAttribute("namespace").trim();
        String string2 = element.getAttribute("processContents").trim();
        int n2 = 6;
        int n3 = 7;
        int n4 = 8;
        if (string2.length() > 0 && !string2.equals("strict")) {
            if (string2.equals("lax")) {
                n2 = 22;
                n3 = 23;
                n4 = 24;
            } else if (string2.equals("skip")) {
                n2 = 38;
                n3 = 39;
                n4 = 40;
            }
        }
        if (string.length() == 0 || string.equals("##any")) {
            n = this.fSchemaGrammar.addContentSpecNode(n2, -1, -1, false);
        } else if (string.equals("##other")) {
            String string3 = element.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
            int n5 = this.fStringPool.addSymbol(string3);
            n = this.fSchemaGrammar.addContentSpecNode(n3, -1, n5, false);
        } else if (string.equals("##local")) {
            n = this.fSchemaGrammar.addContentSpecNode(n4, -1, -1, false);
        } else if (string.length() > 0) {
            int n6;
            String string4;
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            Vector<String> vector = new Vector<String>();
            while (stringTokenizer.hasMoreElements()) {
                string4 = stringTokenizer.nextToken();
                if (string4.equals("##targetNamespace")) {
                    string4 = element.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
                }
                vector.addElement(string4);
            }
            string4 = (String)vector.elementAt(0);
            int n7 = this.fStringPool.addSymbol(string4);
            int n8 = n6 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n7, false);
            int n9 = vector.size();
            if (n9 > 1) {
                string4 = (String)vector.elementAt(1);
                n7 = this.fStringPool.addSymbol(string4);
                int n10 = n6 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n7, false);
                int n11 = this.fSchemaGrammar.addContentSpecNode(4, n8, n10, false);
                int n12 = 2;
                while (n12 < n9) {
                    string4 = (String)vector.elementAt(n12);
                    n7 = this.fStringPool.addSymbol(string4);
                    n10 = n6 = this.fSchemaGrammar.addContentSpecNode(n2, -1, n7, false);
                    n11 = this.fSchemaGrammar.addContentSpecNode(4, n11, n10, false);
                    ++n12;
                }
                n = n11;
            } else {
                n = n6;
            }
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for any element");
        }
        return n;
    }

    public DatatypeValidator getDatatypeValidator(String string, String string2) {
        DatatypeValidator datatypeValidator = null;
        datatypeValidator = string.length() == 0 || string.equals("http://www.w3.org/1999/XMLSchema") ? this.fDatatypeRegistry.getDatatypeValidator(string2) : this.fDatatypeRegistry.getDatatypeValidator(string + "," + string2);
        return datatypeValidator;
    }

    private XMLAttributeDecl traverseAnyAttribute(Element element) throws Exception {
        XMLAttributeDecl xMLAttributeDecl = new XMLAttributeDecl();
        String string = element.getAttribute("processContents").trim();
        String string2 = element.getAttribute("namespace").trim();
        String string3 = element.getOwnerDocument().getDocumentElement().getAttribute("targetNamespace");
        if (string2.length() == 0 || string2.equals("##any")) {
            xMLAttributeDecl.type = 8;
        } else if (string2.equals("##other")) {
            xMLAttributeDecl.type = 9;
            xMLAttributeDecl.name.uri = this.fStringPool.addSymbol(string3);
        } else if (string2.equals("##local")) {
            xMLAttributeDecl.type = 10;
        } else if (string2.length() > 0) {
            xMLAttributeDecl.type = 11;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            int n = this.fStringPool.startStringList();
            Vector vector = new Vector();
            while (stringTokenizer.hasMoreElements()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equals("##targetNamespace")) {
                    string4 = string3;
                }
                if (this.fStringPool.addStringToList(n, this.fStringPool.addSymbol(string4))) continue;
                this.reportGenericSchemaError("Internal StringPool error when reading the namespace attribute for anyattribute declaration");
            }
            this.fStringPool.finishStringList(n);
            xMLAttributeDecl.enumeration = n;
        } else {
            this.reportGenericSchemaError("Empty namespace attribute for anyattribute declaration");
        }
        xMLAttributeDecl.defaultType = 4;
        if (string.equals("skip")) {
            xMLAttributeDecl.defaultType = 6;
        } else if (string.equals("lax")) {
            xMLAttributeDecl.defaultType = 5;
        }
        return xMLAttributeDecl;
    }

    private XMLAttributeDecl mergeTwoAnyAttribute(XMLAttributeDecl xMLAttributeDecl, XMLAttributeDecl xMLAttributeDecl2) {
        if (xMLAttributeDecl.type == -1) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl2.type == -1) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl.type == 8) {
            return xMLAttributeDecl2;
        }
        if (xMLAttributeDecl2.type == 8) {
            return xMLAttributeDecl;
        }
        if (xMLAttributeDecl.type == 9) {
            if (xMLAttributeDecl2.type == 9) {
                if (xMLAttributeDecl2.name.uri == xMLAttributeDecl.name.uri) {
                    return xMLAttributeDecl;
                }
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 10) {
                return xMLAttributeDecl2;
            }
            if (xMLAttributeDecl2.type == 11) {
                if (!this.fStringPool.stringInList(xMLAttributeDecl2.enumeration, xMLAttributeDecl.name.uri)) {
                    return xMLAttributeDecl2;
                }
                int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration);
                int n = this.fStringPool.startStringList();
                int n2 = 0;
                while (n2 < nArray.length) {
                    if (nArray[n2] != xMLAttributeDecl.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n2]);
                    }
                    ++n2;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl2.enumeration = n;
                return xMLAttributeDecl2;
            }
        }
        if (xMLAttributeDecl.type == 10) {
            if (xMLAttributeDecl2.type == 9 || xMLAttributeDecl2.type == 10) {
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 11) {
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
        }
        if (xMLAttributeDecl.type == 11) {
            if (xMLAttributeDecl2.type == 9) {
                if (!this.fStringPool.stringInList(xMLAttributeDecl.enumeration, xMLAttributeDecl2.name.uri)) {
                    return xMLAttributeDecl;
                }
                int[] nArray = this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration);
                int n = this.fStringPool.startStringList();
                int n3 = 0;
                while (n3 < nArray.length) {
                    if (nArray[n3] != xMLAttributeDecl2.name.uri) {
                        this.fStringPool.addStringToList(n, nArray[n3]);
                    }
                    ++n3;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl.enumeration = n;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 10) {
                xMLAttributeDecl.type = -1;
                return xMLAttributeDecl;
            }
            if (xMLAttributeDecl2.type == 11) {
                int[] nArray = this.intersect2sets(this.fStringPool.stringListAsIntArray(xMLAttributeDecl.enumeration), this.fStringPool.stringListAsIntArray(xMLAttributeDecl2.enumeration));
                int n = this.fStringPool.startStringList();
                int n4 = 0;
                while (n4 < nArray.length) {
                    this.fStringPool.addStringToList(n, nArray[n4]);
                    ++n4;
                }
                this.fStringPool.finishStringList(n);
                xMLAttributeDecl.enumeration = n;
                return xMLAttributeDecl;
            }
        }
        return xMLAttributeDecl;
    }

    int[] intersect2sets(int[] nArray, int[] nArray2) {
        int[] nArray3 = new int[nArray.length > nArray2.length ? nArray.length : nArray2.length];
        int n = 0;
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                if (nArray[n2] == nArray2[n3]) {
                    nArray3[n++] = nArray[n2];
                }
                ++n3;
            }
            ++n2;
        }
        int[] nArray4 = new int[n];
        System.arraycopy(nArray3, 0, nArray4, 0, n);
        return nArray4;
    }

    /*
     * Unable to fully structure code
     */
    private int traverseComplexTypeDecl(Element var1_1) throws Exception {
        block112: {
            var2_2 = var1_1.getAttribute("abstract");
            var3_3 = var1_1.getAttribute("base");
            var4_4 = var1_1.getAttribute("block");
            var5_5 = var1_1.getAttribute("content");
            var6_6 = var1_1.getAttribute("derivedBy");
            var7_7 = var1_1.getAttribute("final");
            var8_8 = var1_1.getAttribute("ID");
            var9_9 = var1_1.getAttribute("name");
            var10_10 = false;
            if (TraverseSchema.DEBUGGING) {
                System.out.println("traversing complex Type : " + var9_9 + "," + var3_3 + "," + var5_5 + ".");
            }
            if (var9_9.equals("")) {
                var9_9 = "#" + this.fAnonTypeCount++;
            } else {
                this.fCurrentTypeNameStack.push(var9_9);
                var10_10 = true;
            }
            if (this.isTopLevel(var1_1) && (var12_13 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(var11_11 = this.fTargetNSURIString + "," + var9_9)) != null) {
                return this.fStringPool.addSymbol(var11_11);
            }
            var11_12 = this.fScopeCount++;
            var12_14 = this.fCurrentScope;
            this.fCurrentScope = var11_12;
            var13_15 = null;
            var14_16 = -1;
            var15_17 = 0;
            var16_18 = -2;
            var17_19 = -2;
            var18_20 = null;
            var19_21 = null;
            var20_22 = null;
            var21_23 = -1;
            var22_24 = "";
            var23_25 = false;
            var24_26 = false;
            var25_27 = false;
            var26_28 = null;
            var27_29 = true;
            var28_30 = false;
            var29_31 = -1;
            var30_32 = null;
            if (var3_3.length() > 0) {
                if (var6_6.length() == 0) {
                    this.reportGenericSchemaError("derivedBy must be present when base is present in complexType " + var9_9);
                    var6_6 = "extension";
                }
                if (var6_6.equals("extension")) {
                    var27_29 = false;
                }
                var31_33 = "";
                var32_38 = var3_3;
                var33_42 = var3_3.indexOf(":");
                if (var33_42 > 0) {
                    var31_33 = var3_3.substring(0, var33_42);
                    var32_38 = var3_3.substring(var33_42 + 1);
                }
                var34_44 = this.fStringPool.addSymbol(var32_38);
                var35_46 = this.resolvePrefixToURI(var31_33);
                if (!var35_46.equals(this.fTargetNSURIString) && !var35_46.equals("http://www.w3.org/1999/XMLSchema") && var35_46.length() != 0) {
                    var25_27 = true;
                    var26_28 = var35_46;
                    var18_20 = this.getTypeInfoFromNS((String)var35_46, var32_38);
                    if (var18_20 == null) {
                        var19_21 = this.getTypeValidatorFromNS((String)var35_46, var32_38);
                        if (var19_21 == null) {
                            System.out.println("Could not find base type " + var32_38 + " in schema " + (String)var35_46);
                        } else {
                            var23_25 = true;
                        }
                    }
                } else {
                    var22_24 = (String)var35_46 + "," + var32_38;
                    var18_20 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(var22_24);
                    if (var18_20 == null) {
                        var19_21 = this.getDatatypeValidator((String)var35_46, var32_38);
                        if (var19_21 == null) {
                            var30_32 = this.getTopLevelComponentByName("complexType", var32_38);
                            if (var30_32 != null) {
                                var21_23 = this.traverseComplexTypeDecl(var30_32);
                                var18_20 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(var21_23));
                            } else {
                                var30_32 = this.getTopLevelComponentByName("simpleType", var32_38);
                                if (var30_32 != null) {
                                    var21_23 = this.traverseSimpleTypeDecl(var30_32);
                                    var19_21 = this.getDatatypeValidator((String)var35_46, var32_38);
                                    var20_22 = var19_21;
                                    if (var20_22 == null) {
                                        // empty if block
                                    }
                                    var23_25 = true;
                                } else {
                                    this.reportGenericSchemaError("Base type could not be found : " + var3_3);
                                }
                            }
                        } else {
                            var20_22 = var19_21;
                            var23_25 = true;
                        }
                    }
                }
                if (var23_25 && var27_29) {
                    this.reportGenericSchemaError("base is a simpledType, can't derive by restriction in " + var9_9);
                }
                if (var18_20 != null) {
                    if (var27_29) {
                        // empty if block
                    }
                    if (var18_20.contentSpecHandle > -1) {
                        if (var27_29) {
                            this.checkParticleDerivationOK(var1_1, var30_32);
                        }
                        var29_31 = var18_20.contentSpecHandle;
                    } else if (var18_20.datatypeValidator != null) {
                        var19_21 = var18_20.datatypeValidator;
                        var24_26 = true;
                    }
                }
                if (var24_26 && !var27_29) {
                    this.reportGenericSchemaError("base is ComplexSimple, can't derive by extension in " + var9_9);
                }
            }
            var13_15 = null;
            if (var24_26) {
                var14_16 = 4;
                var31_34 = 0;
                var32_39 = 0;
                var33_43 = new Hashtable<String, Object>();
                var34_45 = new Vector<String>();
                var13_15 = XUtil.getFirstChildElement(var1_1);
                while (var13_15 != null && (var13_15.getNodeName().equals("minExclusive") || var13_15.getNodeName().equals("minInclusive") || var13_15.getNodeName().equals("maxExclusive") || var13_15.getNodeName().equals("maxInclusive") || var13_15.getNodeName().equals("precision") || var13_15.getNodeName().equals("scale") || var13_15.getNodeName().equals("length") || var13_15.getNodeName().equals("minLength") || var13_15.getNodeName().equals("maxLength") || var13_15.getNodeName().equals("encoding") || var13_15.getNodeName().equals("period") || var13_15.getNodeName().equals("duration") || var13_15.getNodeName().equals("enumeration") || var13_15.getNodeName().equals("pattern") || var13_15.getNodeName().equals("annotation"))) {
                    if (var13_15.getNodeType() == 1) {
                        var35_46 = var13_15;
                        ++var32_39;
                        if (var35_46.getNodeName().equals("enumeration")) {
                            ++var31_34;
                            var34_45.addElement(var35_46.getAttribute("value"));
                            var36_49 = XUtil.getFirstChildElement((Node)var35_46);
                            if (var36_49 != null && var36_49.getNodeName().equals("annotation")) {
                                this.traverseAnnotationDecl(var13_15);
                            }
                        } else {
                            var33_43.put(var35_46.getNodeName(), var35_46.getAttribute("value"));
                        }
                    }
                    var13_15 = XUtil.getNextSiblingElement(var13_15);
                }
                if (var31_34 > 0) {
                    var33_43.put("enumeration", var34_45);
                }
                var20_22 = var32_39 > 0 ? this.fDatatypeRegistry.createDatatypeValidator(var9_9, var19_21, var33_43, false) : var19_21;
                if (var13_15 != null) {
                    this.reportGenericSchemaError("Invalid child '" + var13_15.getNodeName() + "' in complexType : '" + var9_9 + "', because it restricts another complexSimpleType");
                }
            }
            if (var5_5.equals("textOnly")) {
                if (var3_3.length() == 0) {
                    var20_22 = var19_21 = this.getDatatypeValidator("", "string");
                } else if (var19_21 == null && var18_20 != null && var18_20.datatypeValidator == null) {
                    this.reportSchemaError(5, new Object[]{var3_3});
                }
                var14_16 = 4;
            } else {
                if (!var24_26) {
                    var14_16 = 3;
                }
                var15_17 = 5;
                var31_35 = false;
                var32_40 = true;
                var33_42 = 0;
                var34_44 = 0;
                var16_18 = -2;
                var17_19 = -2;
                var35_47 = false;
                if (var5_5.equals("empty")) {
                    var14_16 = 0;
                    var34_44 = 1;
                    var32_40 = false;
                    var16_18 = -1;
                } else if (var5_5.equals("mixed")) {
                    var14_16 = 2;
                    var31_35 = true;
                    var32_40 = false;
                    var15_17 = 4;
                } else if (var5_5.equals("elementOnly") || var5_5.equals("")) {
                    var32_40 = true;
                } else if (var5_5.equals("textOnly")) {
                    var33_42 = 1;
                    var32_40 = false;
                }
                if (var31_35) {
                    var16_18 = this.fSchemaGrammar.addContentSpecNode(0, -1, -1, false);
                    var15_17 = 4;
                }
                var36_50 = false;
                var37_51 = false;
                var38_55 = 0;
                var13_15 = XUtil.getFirstChildElement(var1_1);
                while (var13_15 != null) {
                    var39_56 = -2;
                    var35_47 = true;
                    var36_50 = false;
                    var40_58 = var13_15.getNodeName();
                    if (var40_58.equals("element")) {
                        if (var31_35 || var32_40) {
                            if (TraverseSchema.DEBUGGING) {
                                System.out.println(" child element name " + var13_15.getAttribute("name"));
                            }
                            var41_60 = this.traverseElementDecl(var13_15);
                            var39_56 = this.fSchemaGrammar.addContentSpecNode(0, var41_60.localpart, var41_60.uri, false);
                            var36_50 = true;
                            var37_51 = true;
                        } else {
                            this.reportSchemaError(9, null);
                        }
                    } else if (var40_58.equals("group")) {
                        var39_56 = this.traverseGroupDecl(var13_15);
                        var36_50 = true;
                        var37_51 = true;
                    } else if (var40_58.equals("all")) {
                        var39_56 = this.traverseAll(var13_15);
                        var36_50 = true;
                        var38_55 = 1;
                    } else if (var40_58.equals("choice")) {
                        var39_56 = this.traverseChoice(var13_15);
                        var36_50 = true;
                        var37_51 = true;
                    } else if (var40_58.equals("sequence")) {
                        var39_56 = this.traverseSequence(var13_15);
                        var36_50 = true;
                        var37_51 = true;
                    } else {
                        if (var40_58.equals("attribute") || var40_58.equals("attributeGroup")) break;
                        if (var40_58.equals("any")) {
                            var39_56 = this.traverseAny(var13_15);
                            var36_50 = true;
                            var37_51 = true;
                        } else if (!var40_58.equals("annotation")) {
                            if (var40_58.equals("anyAttribute")) break;
                            if (!var24_26) {
                                if (var3_3.equals("")) {
                                    this.reportSchemaError(23, new Object[]{"unrecognized child '" + var40_58 + "' in complex type " + var9_9});
                                } else {
                                    this.reportSchemaError(23, new Object[]{"unrecognized child '" + var40_58 + "' in complex type '" + var9_9 + "' with base " + var3_3});
                                }
                            }
                        }
                    }
                    if (var24_26 && var36_50) {
                        this.reportGenericSchemaError("In complexType " + var9_9 + ", base type is complexType with simpleType content, can't have any particle children at all");
                        var35_47 = false;
                        var39_56 = -2;
                        var16_18 = -2;
                        var14_16 = 4;
                        break;
                    }
                    if (var38_55 != 0 && var37_51) {
                        this.reportGenericSchemaError(" 'All' group needs to be the only child in Complextype : " + var9_9);
                    }
                    if (var38_55 != 0) {
                        // empty if block
                    }
                    if (!var36_50 || (var39_56 = this.expandContentModel(var39_56, var13_15)) != -2) {
                        if (var16_18 == -2) {
                            var16_18 = var39_56;
                        } else if (var17_19 == -2) {
                            var17_19 = var39_56;
                        } else {
                            var16_18 = this.fSchemaGrammar.addContentSpecNode(var15_17, var16_18, var17_19, false);
                            var17_19 = var39_56;
                        }
                    }
                    var13_15 = XUtil.getNextSiblingElement(var13_15);
                }
                if (!var37_51 && var38_55 == 0 && (var32_40 || var31_35) && (var3_3.length() == 0 || var3_3.length() > 0 && var27_29 && !var24_26)) {
                    var14_16 = 4;
                    var20_22 = this.getDatatypeValidator("", "string");
                    this.reportGenericSchemaError(" complexType '" + var9_9 + "' with a elementOnly or mixed content " + "need to have at least one particle child");
                }
                if (var35_47 && var17_19 != -2) {
                    var16_18 = this.fSchemaGrammar.addContentSpecNode(var15_17, var16_18, var17_19, false);
                }
                if (var31_35 && var35_47) {
                    var16_18 = this.fSchemaGrammar.addContentSpecNode(2, var16_18, -1, false);
                }
            }
            if (!var27_29 && var29_31 > -1) {
                if (var25_27) {
                    var31_36 = (SchemaGrammar)this.fGrammarResolver.getGrammar((String)var26_28);
                    var29_31 = this.importContentSpec(var31_36, var29_31);
                }
                var16_18 = var16_18 == -2 ? var29_31 : this.fSchemaGrammar.addContentSpecNode(5, var29_31, var16_18, false);
            }
            if (var5_5.length() == 0 && var3_3.length() == 0 && var16_18 == -2) {
                var14_16 = 1;
            }
            if (var5_5.length() == 0 && var20_22 == null && var16_18 == -2 && var3_3.length() > 0 && var18_20 != null && var18_20.contentType == 0) {
                var14_16 = 0;
            }
            if (TraverseSchema.DEBUGGING) {
                System.out.println("!!!!!>>>>>" + var9_9 + ", " + var18_20 + ", " + var29_31 + ", " + var16_18 + ", " + var11_12);
            }
            var31_37 = new ComplexTypeInfo();
            var31_37.baseComplexTypeInfo = var18_20;
            var31_37.baseDataTypeValidator = var19_21;
            var32_41 = -1;
            if (var6_6.length() > 0) {
                var32_41 = this.parseComplexDerivedBy(var6_6);
            }
            var31_37.derivedBy = var32_41;
            var31_37.scopeDefined = var11_12;
            var31_37.contentSpecHandle = var16_18;
            var31_37.contentType = var14_16;
            var31_37.datatypeValidator = var20_22;
            var31_37.blockSet = this.parseBlockSet(var1_1.getAttribute("block"));
            var31_37.finalSet = this.parseFinalSet(var1_1.getAttribute("final"));
            var31_37.isAbstract = var2_2.equals("true") != false;
            var33_42 = this.fStringPool.addSymbol(var9_9);
            var34_44 = this.fStringPool.addSymbol("$" + var9_9);
            var31_37.templateElementIndex = this.fSchemaGrammar.addElementDecl(new QName(-1, var34_44, var33_42, this.fTargetNSURI), this.fTargetNSURI == -1 ? -1 : this.fCurrentScope, var11_12, var14_16, var16_18, -1, var20_22);
            var31_37.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(var31_37.templateElementIndex);
            var35_48 = null;
            var36_49 = new Vector<E>();
            var13_15 = XUtil.getFirstChildElement(var1_1);
            while (var13_15 != null) {
                var37_52 = var13_15.getNodeName();
                if (var37_52.equals("attribute")) {
                    if ((var24_26 || var23_25) && var27_29) {
                        this.reportGenericSchemaError("In complexType " + var9_9 + ", base type has simpleType " + "content and derivation method is" + " 'restriction', can't have any " + "attribute children at all");
                        break;
                    }
                    this.traverseAttributeDecl(var13_15, var31_37);
                } else if (var37_52.equals("attributeGroup")) {
                    if ((var24_26 || var23_25) && var27_29) {
                        this.reportGenericSchemaError("In complexType " + var9_9 + ", base " + "type has simpleType content and " + "derivation method is 'restriction'," + " can't have any attribute children at all");
                        break;
                    }
                    this.traverseAttributeGroupDecl(var13_15, var31_37, (Vector)var36_49);
                } else if (var37_52.equals("anyAttribute")) {
                    var35_48 = this.traverseAnyAttribute(var13_15);
                }
                var13_15 = XUtil.getNextSiblingElement(var13_15);
            }
            if (var35_48 != null) {
                var37_53 = null;
                var38_55 = var36_49.size();
                if (var38_55 > 0) {
                    var37_53 = (XMLAttributeDecl)var36_49.elementAt(0);
                    var39_56 = 1;
                    while (var39_56 < var38_55) {
                        var37_53 = this.mergeTwoAnyAttribute(var37_53, (XMLAttributeDecl)var36_49.elementAt(var39_56));
                        ++var39_56;
                    }
                }
                if (var37_53 != null) {
                    var39_56 = var35_48.defaultType;
                    var35_48 = this.mergeTwoAnyAttribute(var35_48, var37_53);
                    var35_48.defaultType = var39_56;
                }
            }
            var37_54 = null;
            if (var18_20 == null || var18_20.attlistHead <= -1) break block112;
            var38_55 = var18_20.attlistHead;
            var39_57 = this.fSchemaGrammar;
            if (var25_27) {
                var39_57 = (SchemaGrammar)this.fGrammarResolver.getGrammar((String)var26_28);
            }
            if (var39_57 != null) ** GOTO lbl344
            this.reportGenericSchemaError("In complexType " + var9_9 + ", can NOT find the grammar " + "with targetNamespace" + (String)var26_28 + "for the base type");
            break block112;
lbl-1000:
            // 1 sources

            {
                this.fTempAttributeDecl.clear();
                var39_57.getAttributeDecl(var38_55, this.fTempAttributeDecl);
                if (this.fTempAttributeDecl.type == 8 || this.fTempAttributeDecl.type == 11 || this.fTempAttributeDecl.type == 10 || this.fTempAttributeDecl.type == 9) {
                    if (var35_48 == null) {
                        var37_54 = this.fTempAttributeDecl;
                    }
                    var38_55 = var39_57.getNextAttributeDeclIndex(var38_55);
                    continue;
                }
                var40_59 = this.fSchemaGrammar.getAttributeDeclIndex(var31_37.templateElementIndex, this.fTempAttributeDecl.name);
                if (var40_59 > -1 && var27_29) {
                    var38_55 = this.fSchemaGrammar.getNextAttributeDeclIndex(var38_55);
                    continue;
                }
                this.fSchemaGrammar.addAttDef(var31_37.templateElementIndex, this.fTempAttributeDecl.name, this.fTempAttributeDecl.type, this.fTempAttributeDecl.enumeration, this.fTempAttributeDecl.defaultType, this.fTempAttributeDecl.defaultValue, this.fTempAttributeDecl.datatypeValidator, this.fTempAttributeDecl.list);
                var38_55 = var39_57.getNextAttributeDeclIndex(var38_55);
lbl344:
                // 4 sources

                ** while (var38_55 > -1)
            }
        }
        if (var35_48 != null) {
            if (var35_48.type != -1) {
                this.fSchemaGrammar.addAttDef(var31_37.templateElementIndex, var35_48.name, var35_48.type, var35_48.enumeration, var35_48.defaultType, var35_48.defaultValue, var35_48.datatypeValidator, var35_48.list);
            }
        } else if (var37_54 != null) {
            this.fSchemaGrammar.addAttDef(var31_37.templateElementIndex, var37_54.name, var37_54.type, var37_54.enumeration, var37_54.defaultType, var37_54.defaultValue, var37_54.datatypeValidator, var37_54.list);
        }
        var31_37.attlistHead = this.fSchemaGrammar.getFirstAttributeDeclIndex(var31_37.templateElementIndex);
        if (!var9_9.startsWith("#")) {
            var9_9 = this.fTargetNSURIString + "," + var9_9;
        }
        var31_37.typeName = new String(var9_9);
        if (TraverseSchema.DEBUGGING) {
            System.out.println("add complex Type to Registry: " + var9_9 + "," + var5_5 + ".");
        }
        this.fComplexTypeRegistry.put(var9_9, var31_37);
        this.fCurrentScope = var12_14;
        if (var10_10) {
            this.fCurrentTypeNameStack.pop();
            this.checkRecursingComplexType();
        }
        this.fSchemaGrammar.setElementComplexTypeInfo(var31_37.templateElementIndex, var31_37);
        var33_42 = this.fStringPool.addSymbol(var9_9);
        return var33_42;
    }

    private void checkRecursingComplexType() throws Exception {
        if (this.fCurrentTypeNameStack.empty() && !this.fElementRecurseComplex.isEmpty()) {
            Enumeration enumeration = this.fElementRecurseComplex.keys();
            while (enumeration.hasMoreElements()) {
                QName qName = (QName)enumeration.nextElement();
                String string = (String)this.fElementRecurseComplex.get(qName);
                int n = qName.uri;
                int n2 = qName.localpart;
                int n3 = qName.prefix;
                ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fTargetNSURIString + "," + string);
                if (complexTypeInfo == null) {
                    throw new Exception("Internal Error in void checkRecursingComplexType(). ");
                }
                int n4 = this.fSchemaGrammar.addElementDecl(new QName(-1, n2, n2, n), n3, complexTypeInfo.scopeDefined, complexTypeInfo.contentType, complexTypeInfo.contentSpecHandle, complexTypeInfo.attlistHead, complexTypeInfo.datatypeValidator);
                this.fSchemaGrammar.setElementComplexTypeInfo(n4, complexTypeInfo);
            }
            this.fElementRecurseComplex.clear();
        }
    }

    private void checkParticleDerivationOK(Element element, Element element2) {
    }

    private int importContentSpec(SchemaGrammar schemaGrammar, int n) throws Exception {
        XMLContentSpec xMLContentSpec = new XMLContentSpec();
        schemaGrammar.getContentSpec(n, xMLContentSpec);
        int n2 = -1;
        int n3 = -1;
        if (xMLContentSpec.type == 0 || (xMLContentSpec.type & 0xF) == 6 || (xMLContentSpec.type & 0xF) == 8 || (xMLContentSpec.type & 0xF) == 7) {
            return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
        }
        n2 = xMLContentSpec.value == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.value);
        n3 = xMLContentSpec.otherValue == -1 ? -1 : this.importContentSpec(schemaGrammar, xMLContentSpec.otherValue);
        return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, n2, n3, false);
    }

    private int expandContentModel(int n, Element element) throws Exception {
        block22: {
            String string = element.getAttribute("minOccurs").trim();
            String string2 = element.getAttribute("maxOccurs").trim();
            int n2 = 1;
            int n3 = 1;
            if (string.equals("0") && string2.equals("0")) {
                return -2;
            }
            if (string.equals("")) {
                string = "1";
            }
            if (string2.equals("")) {
                string2 = string.equals("0") ? "1" : string;
            }
            int n4 = n;
            if (string.equals("1") && string2.equals("1")) break block22;
            if (string.equals("0") && string2.equals("1")) {
                n = this.fSchemaGrammar.addContentSpecNode(1, n, -1, false);
            } else if (string.equals("0") && string2.equals("unbounded")) {
                n = this.fSchemaGrammar.addContentSpecNode(2, n, -1, false);
            } else if (string.equals("1") && string2.equals("unbounded")) {
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
            } else if (string2.equals("unbounded")) {
                try {
                    n2 = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs : '" + exception.getMessage() + "' "});
                }
                if (n2 < 2) {
                    // empty if block
                }
                n = this.fSchemaGrammar.addContentSpecNode(3, n, -1, false);
                int n5 = 0;
                while (n5 < n2 - 1) {
                    n = this.fSchemaGrammar.addContentSpecNode(5, n4, n, false);
                    ++n5;
                }
            } else {
                try {
                    n2 = Integer.parseInt(string);
                    n3 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    this.reportSchemaError(23, new Object[]{"illegal value for minOccurs or maxOccurs : '" + exception.getMessage() + "' "});
                }
                if (n2 == 0) {
                    int n6;
                    n = n6 = this.fSchemaGrammar.addContentSpecNode(1, n4, -1, false);
                    int n7 = 0;
                    while (n7 < n3 - n2 - 1) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n6, false);
                        ++n7;
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2 - 1) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n4, false);
                        ++n8;
                    }
                    int n9 = this.fSchemaGrammar.addContentSpecNode(1, n4, -1, false);
                    int n10 = 0;
                    while (n10 < n3 - n2) {
                        n = this.fSchemaGrammar.addContentSpecNode(5, n, n9, false);
                        ++n10;
                    }
                }
            }
        }
        return n;
    }

    private int traverseAttributeDecl(Element element, ComplexTypeInfo complexTypeInfo) throws Exception {
        String string;
        int n;
        Object object;
        String string2 = element.getAttribute("name");
        int n2 = this.fStringPool.addSymbol(string2);
        String string3 = element.getAttribute("form");
        DatatypeValidator datatypeValidator = null;
        int n3 = -1;
        boolean bl = false;
        int n4 = -1;
        String string4 = element.getAttribute("ref");
        String string5 = element.getAttribute("type");
        String string6 = null;
        if (!string4.equals("")) {
            String string7;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string8 = "";
            string6 = string4;
            int n5 = string4.indexOf(":");
            if (n5 > 0) {
                string8 = string4.substring(0, n5);
                string6 = string4.substring(n5 + 1);
            }
            if (!(string7 = this.resolvePrefixToURI(string8)).equals(this.fTargetNSURIString)) {
                this.addAttributeDeclFromAnotherSchema(string6, string7, complexTypeInfo);
                return -1;
            }
            Element element2 = this.getTopLevelComponentByName("attribute", string6);
            if (element2 != null) {
                this.traverseAttributeDecl(element2, complexTypeInfo);
            } else if (this.fAttributeDeclRegistry.get(string6) != null) {
                this.addAttributeDeclFromAnotherSchema(string6, string7, complexTypeInfo);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attribute " + string4);
            }
            return -1;
        }
        if (string5.equals("")) {
            object = XUtil.getFirstChildElement(element);
            while (object != null && !object.getNodeName().equals("simpleType")) {
                object = XUtil.getNextSiblingElement((Node)object);
            }
            if (object != null && object.getNodeName().equals("simpleType")) {
                n3 = 7;
                n4 = this.traverseSimpleTypeDecl((Element)object);
                string6 = this.fStringPool.toString(n4);
            } else {
                n3 = 7;
                string6 = "string";
                n4 = this.fStringPool.addSymbol(string6);
            }
            string6 = this.fStringPool.toString(n4);
            datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(string6);
        } else {
            Element element3;
            object = "";
            string6 = string5;
            n4 = this.fStringPool.addSymbol(string6);
            n = string5.indexOf(":");
            if (n > 0) {
                object = string5.substring(0, n);
                string6 = string5.substring(n + 1);
            }
            if ((string = this.resolvePrefixToURI((String)object)).equals("http://www.w3.org/1999/XMLSchema") || string.length() == 0) {
                datatypeValidator = this.getDatatypeValidator("", string6);
                if (string6.equals("ID")) {
                    n3 = 3;
                } else if (string6.equals("IDREF")) {
                    n3 = 4;
                } else if (string6.equals("IDREFS")) {
                    n3 = 4;
                    bl = true;
                } else if (string6.equals("ENTITY")) {
                    n3 = 1;
                } else if (string6.equals("ENTITIES")) {
                    n3 = 1;
                    bl = true;
                } else if (string6.equals("NMTOKEN")) {
                    n3 = 5;
                } else if (string6.equals("NMTOKENS")) {
                    n3 = 5;
                    bl = true;
                } else if (string6.equals("notation")) {
                    n3 = 6;
                } else {
                    n3 = 7;
                    if (datatypeValidator == null && string.length() == 0) {
                        element3 = this.getTopLevelComponentByName("simpleType", string6);
                        if (element3 != null) {
                            this.traverseSimpleTypeDecl(element3);
                            datatypeValidator = this.getDatatypeValidator(string, string6);
                        } else {
                            this.reportGenericSchemaError("simpleType not found : " + string6);
                        }
                    }
                }
            } else {
                datatypeValidator = this.getDatatypeValidator(string, string6);
                if (datatypeValidator == null && string.equals(this.fTargetNSURIString)) {
                    element3 = this.getTopLevelComponentByName("simpleType", string6);
                    if (element3 != null) {
                        this.traverseSimpleTypeDecl(element3);
                        datatypeValidator = this.getDatatypeValidator(string, string6);
                    } else {
                        this.reportGenericSchemaError("simpleType not found : " + string6);
                    }
                }
                n3 = 7;
            }
        }
        int n6 = -1;
        n = -1;
        string = element.getAttribute("use");
        boolean bl2 = string.equals("required");
        if (datatypeValidator == null) {
            this.reportGenericSchemaError("could not resolve the type or get a null validator for datatype : " + this.fStringPool.toString(n4));
        }
        if (bl2) {
            n6 = 2;
        } else {
            String string9;
            if (string.equals("fixed")) {
                string9 = element.getAttribute("value");
                if (!string9.equals("")) {
                    n6 = 1;
                    n = this.fStringPool.addString(string9);
                }
            } else if (string.equals("default")) {
                string9 = element.getAttribute("value");
                if (!string9.equals("")) {
                    n6 = 3;
                    n = this.fStringPool.addString(string9);
                }
            } else {
                n6 = string.equals("prohibited") ? 0 : 0;
            }
            if (n3 == 7 && n != -1) {
                try {
                    if (datatypeValidator != null) {
                        datatypeValidator.validate(this.fStringPool.toString(n), null);
                    } else {
                        this.reportSchemaError(2, new Object[]{string5});
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError(18, new Object[]{element.getAttribute("name"), invalidDatatypeValueException.getMessage()});
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    System.out.println("Internal error in attribute datatype validation");
                }
            }
        }
        int n7 = -1;
        if (string3.equals("qualified") || this.fAttributeDefaultQualified || this.isTopLevel(element)) {
            n7 = this.fTargetNSURI;
        }
        QName qName = new QName(-1, n2, n2, n7);
        if (DEBUGGING) {
            System.out.println(" the dataType Validator for " + this.fStringPool.toString(n2) + " is " + datatypeValidator);
        }
        if (this.isTopLevel(element)) {
            this.fTempAttributeDecl.datatypeValidator = datatypeValidator;
            this.fTempAttributeDecl.name.setValues(qName);
            this.fTempAttributeDecl.type = n3;
            this.fTempAttributeDecl.defaultType = n6;
            this.fTempAttributeDecl.list = bl;
            if (n != -1) {
                this.fTempAttributeDecl.defaultValue = new String(this.fStringPool.toString(n));
            }
            this.fAttributeDeclRegistry.put(string2, new XMLAttributeDecl(this.fTempAttributeDecl));
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, qName, n3, n4, n6, this.fStringPool.toString(n), datatypeValidator, bl);
        }
        return -1;
    }

    private int addAttributeDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #addAttributeDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
        if (hashtable == null) {
            this.reportGenericSchemaError("no attribute was defined in schema : " + string2);
            return -1;
        }
        XMLAttributeDecl xMLAttributeDecl = (XMLAttributeDecl)hashtable.get(string);
        if (xMLAttributeDecl == null) {
            this.reportGenericSchemaError("no attribute named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        if (complexTypeInfo != null) {
            this.fSchemaGrammar.addAttDef(complexTypeInfo.templateElementIndex, xMLAttributeDecl.name, xMLAttributeDecl.type, -1, xMLAttributeDecl.defaultType, xMLAttributeDecl.defaultValue, xMLAttributeDecl.datatypeValidator, xMLAttributeDecl.list);
        }
        return 0;
    }

    private int traverseAttributeGroupDecl(Element element, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        int n = this.fStringPool.addSymbol(element.getAttribute("name"));
        String string = element.getAttribute("ref");
        int n2 = -1;
        int n3 = -1;
        if (!string.equals("")) {
            String string2;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string3 = "";
            String string4 = string;
            int n4 = string.indexOf(":");
            if (n4 > 0) {
                string3 = string.substring(0, n4);
                string4 = string.substring(n4 + 1);
            }
            if (!(string2 = this.resolvePrefixToURI(string3)).equals(this.fTargetNSURIString)) {
                this.traverseAttributeGroupDeclFromAnotherSchema(string4, string2, complexTypeInfo, vector);
                return -1;
            }
            Element element2 = this.getTopLevelComponentByName("attributeGroup", string4);
            if (element2 != null) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else {
                this.reportGenericSchemaError("Couldn't find top level attributegroup " + string);
            }
            return -1;
        }
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null) {
            if (element3.getNodeName().equals("attribute")) {
                this.traverseAttributeDecl(element3, complexTypeInfo);
            } else if (element3.getNodeName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element3, complexTypeInfo, vector);
            } else {
                if (element3.getNodeName().equals("anyAttribute")) {
                    vector.addElement(this.traverseAnyAttribute(element3));
                    break;
                }
                if (element3.getNodeName().equals("annotation")) {
                    // empty if block
                }
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
        return -1;
    }

    private int traverseAttributeGroupDeclFromAnotherSchema(String string, String string2, ComplexTypeInfo complexTypeInfo, Vector vector) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseAttributeGroupDeclFromAnotherSchema, schema uri : " + string2);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelAttrGrpDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no attribute group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        int n2 = -1;
        int n3 = -1;
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null) {
            if (element2.getNodeName().equals("attribute")) {
                String string3 = element2.getAttribute("name");
                if (string3.length() > 0) {
                    Hashtable hashtable = schemaGrammar.getAttirubteDeclRegistry();
                    if (hashtable != null && hashtable.get(string3) != null) {
                        this.addAttributeDeclFromAnotherSchema(string3, string2, complexTypeInfo);
                        return -1;
                    }
                } else {
                    this.traverseAttributeDecl(element2, complexTypeInfo);
                }
            } else if (element2.getNodeName().equals("attributeGroup")) {
                this.traverseAttributeGroupDecl(element2, complexTypeInfo, vector);
            } else {
                if (element2.getNodeName().equals("anyAttribute")) {
                    vector.addElement(this.traverseAnyAttribute(element2));
                    break;
                }
                if (element2.getNodeName().equals("annotation")) {
                    // empty if block
                }
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        return -1;
    }

    private QName traverseElementDecl(Element element) throws Exception {
        Object object;
        int n;
        int n2;
        int n3;
        String string;
        String string2;
        int n4;
        int n5;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = -2;
        DatatypeValidator datatypeValidator = null;
        String string3 = element.getAttribute("name");
        if (DEBUGGING) {
            System.out.println("traversing element decl : " + string3);
        }
        String string4 = element.getAttribute("ref");
        String string5 = element.getAttribute("type");
        String string6 = element.getAttribute("minOccurs");
        String string7 = element.getAttribute("maxOccurs");
        String string8 = element.getAttribute("default");
        String string9 = element.getAttribute("fixed");
        String string10 = element.getAttribute("equivClass");
        String string11 = element.getAttribute("form");
        String string12 = null;
        if (this.isTopLevel(element) && (n5 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, n4 = this.fStringPool.addSymbol(string3), -1)) > -1) {
            return new QName(-1, n4, n4, this.fTargetNSURI);
        }
        n4 = this.parseBlockSet(element.getAttribute("block"));
        n5 = this.parseFinalSet(element.getAttribute("final"));
        boolean bl = element.getAttribute("nullable").equals("true");
        boolean bl2 = element.getAttribute("abstract").equals("true");
        int n10 = 0;
        if (bl) {
            ++n10;
        }
        if (bl2) {
            n10 += 2;
        }
        int n11 = 0;
        if (!string4.equals("")) {
            ++n11;
        }
        if (!string5.equals("")) {
            ++n11;
        }
        if (n11 > 1) {
            this.reportSchemaError(16, null);
        }
        if (!string4.equals("")) {
            Element element2;
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string13 = "";
            String string14 = string4;
            int n12 = string4.indexOf(":");
            if (n12 > 0) {
                string13 = string4.substring(0, n12);
                string14 = string4.substring(n12 + 1);
            }
            int n13 = this.fStringPool.addSymbol(string14);
            String string15 = this.resolvePrefixToURI(string13);
            QName qName = new QName(string13 != null ? this.fStringPool.addSymbol(string13) : -1, n13, this.fStringPool.addSymbol(string4), string15 != null ? this.fStringPool.addSymbol(string15) : -1);
            if (!string15.equals(this.fTargetNSURIString)) {
                return qName;
            }
            int n14 = this.fSchemaGrammar.getElementDeclIndex(qName, -1);
            if (n14 == -1 && (element2 = this.getTopLevelComponentByName("element", string14)) == null) {
                this.reportGenericSchemaError("Element " + string14 + " not found in the Schema");
                return qName;
            }
            return qName;
        }
        Element element3 = null;
        int n15 = -1;
        boolean bl3 = true;
        String string16 = null;
        String string17 = null;
        String string18 = null;
        ComplexTypeInfo complexTypeInfo = null;
        DatatypeValidator datatypeValidator2 = null;
        if (string10.length() > 0) {
            string16 = this.resolvePrefixToURI(this.getPrefix(string10));
            string17 = this.getLocalPart(string10);
            string18 = string16 + "," + string17;
            if (!string16.equals(this.fTargetNSURIString)) {
                complexTypeInfo = this.getElementDeclTypeInfoFromNS(string16, string17);
                if (complexTypeInfo == null && (datatypeValidator2 = this.getElementDeclTypeValidatorFromNS(string16, string17)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type for element '" + string17 + "' in schema '" + string16 + "'");
                }
            } else {
                element3 = this.getTopLevelComponentByName("element", string17);
                if (element3 == null) {
                    n15 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string10), -1);
                    if (n15 == -1) {
                        bl3 = false;
                        this.reportGenericSchemaError("Equivclass affiliation element " + string10 + " in element declaration " + string3);
                    }
                } else {
                    n15 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string10), -1);
                    if (n15 == -1) {
                        this.traverseElementDecl(element3);
                        n15 = this.fSchemaGrammar.getElementDeclIndex(this.fTargetNSURI, this.getLocalPartIndex(string10), -1);
                    }
                }
                if (n15 != -1 && (complexTypeInfo = this.fSchemaGrammar.getElementComplexTypeInfo(n15)) == null) {
                    this.fSchemaGrammar.getElementDecl(n15, this.fTempElementDecl);
                    datatypeValidator2 = this.fTempElementDecl.datatypeValidator;
                    if (datatypeValidator2 == null) {
                        bl3 = false;
                        this.reportGenericSchemaError("Could not find type for element '" + string17 + "' in schema '" + string16 + "'");
                    }
                }
            }
        }
        ComplexTypeInfo complexTypeInfo2 = null;
        Element element4 = XUtil.getFirstChildElement(element);
        while (element4 != null && element4.getNodeName().equals("annotation")) {
            element4 = XUtil.getNextSiblingElement(element4);
        }
        boolean bl4 = false;
        if (element4 != null) {
            string2 = element4.getNodeName();
            if (string2.equals("complexType")) {
                if (element4.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous complexType in element '" + string3 + "' has a name attribute");
                } else {
                    n8 = this.traverseComplexTypeDecl(element4);
                }
                if (n8 != -1) {
                    complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n8));
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("traverse complexType error in element '" + string3 + "'");
                }
                bl4 = true;
            } else if (string2.equals("simpleType")) {
                if (element4.getAttribute("name").length() > 0) {
                    bl3 = false;
                    this.reportGenericSchemaError("anonymous simpleType in element '" + string3 + "' has a name attribute");
                } else {
                    n8 = this.traverseSimpleTypeDecl(element4);
                }
                if (n8 != -1) {
                    datatypeValidator = this.fDatatypeRegistry.getDatatypeValidator(this.fStringPool.toString(n8));
                } else {
                    bl3 = false;
                    this.reportGenericSchemaError("traverse simpleType error in element '" + string3 + "'");
                }
                n6 = 4;
                bl4 = true;
            } else if (string5.equals("")) {
                n6 = 1;
                n7 = -1;
            } else {
                System.out.println("unhandled case in TraverseElementDecl");
            }
        }
        if (bl4 && string5.length() > 0) {
            bl3 = false;
            this.reportGenericSchemaError("Element '" + string3 + "' have both a type attribute and a annoymous type child");
        } else if (!string5.equals("")) {
            String string19;
            if (element3 != null) {
                this.checkEquivClassOK(element, element3);
            }
            string2 = "";
            string = string5;
            n3 = string5.indexOf(":");
            if (n3 > 0) {
                string2 = string5.substring(0, n3);
                string = string5.substring(n3 + 1);
            }
            if (!(string19 = this.resolvePrefixToURI(string2)).equals(this.fTargetNSURIString) && !string19.equals("http://www.w3.org/1999/XMLSchema") && string19.length() != 0) {
                string12 = string19;
                complexTypeInfo2 = this.getTypeInfoFromNS(string19, string);
                if (complexTypeInfo2 == null && (datatypeValidator = this.getTypeValidatorFromNS(string19, string)) == null) {
                    bl3 = false;
                    this.reportGenericSchemaError("Could not find type " + string + " in schema " + string19);
                }
            } else {
                complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(string19 + "," + string);
                if (complexTypeInfo2 == null && (datatypeValidator = this.getDatatypeValidator(string19, string)) == null) {
                    if (string19.equals("http://www.w3.org/1999/XMLSchema") && !this.fTargetNSURIString.equals("http://www.w3.org/1999/XMLSchema")) {
                        bl3 = false;
                        this.reportGenericSchemaError("type not found : " + string19 + ":" + string);
                    } else {
                        Element element5 = this.getTopLevelComponentByName("complexType", string);
                        if (element5 != null) {
                            if (this.fCurrentTypeNameStack.search(string) > -1) {
                                int n16 = -1;
                                if (string11.equals("qualified") || this.fElementDefaultQualified) {
                                    n16 = this.fTargetNSURI;
                                }
                                int n17 = this.fStringPool.addSymbol(string3);
                                QName qName = new QName(this.fCurrentScope, n17, n17, n16);
                                this.fElementRecurseComplex.put(qName, string);
                                return new QName(-1, n17, n17, n16);
                            }
                            n8 = this.traverseComplexTypeDecl(element5);
                            complexTypeInfo2 = (ComplexTypeInfo)this.fComplexTypeRegistry.get(this.fStringPool.toString(n8));
                        } else {
                            element5 = this.getTopLevelComponentByName("simpleType", string);
                            if (element5 != null) {
                                n8 = this.traverseSimpleTypeDecl(element5);
                                datatypeValidator = this.getDatatypeValidator(string19, string);
                            } else {
                                bl3 = false;
                                this.reportGenericSchemaError("type not found : " + string19 + ":" + string);
                            }
                        }
                    }
                }
            }
        } else if (bl4) {
            if (element3 != null) {
                this.checkEquivClassOK(element, element3);
            }
        } else {
            if (complexTypeInfo2 == null && datatypeValidator == null) {
                complexTypeInfo2 = complexTypeInfo;
            }
            if (complexTypeInfo2 == null && datatypeValidator == null) {
                datatypeValidator = datatypeValidator2;
            }
        }
        if (complexTypeInfo2 == null && datatypeValidator == null) {
            if (bl3) {
                n6 = 1;
            } else {
                bl3 = false;
                this.reportGenericSchemaError("untyped element : " + string3);
            }
        }
        if (complexTypeInfo2 != null) {
            n7 = complexTypeInfo2.contentSpecHandle;
            n6 = complexTypeInfo2.contentType;
            n9 = complexTypeInfo2.scopeDefined;
            datatypeValidator = complexTypeInfo2.datatypeValidator;
        }
        if (datatypeValidator != null) {
            n6 = 4;
            if (complexTypeInfo2 == null) {
                string12 = null;
            }
        }
        element4 = XUtil.getFirstChildElement(element);
        string2 = null;
        while (element4 != null) {
            string = element4.getNodeName();
            element4 = XUtil.getNextSiblingElement(element4);
        }
        n3 = n2 = this.fStringPool.addSymbol(string3);
        int n18 = -1;
        int n19 = this.fCurrentScope;
        if (string11.equals("qualified") || this.fElementDefaultQualified) {
            n18 = this.fTargetNSURI;
        }
        if (this.isTopLevel(element)) {
            n18 = this.fTargetNSURI;
            n19 = -1;
        }
        if ((n = this.fSchemaGrammar.getElementDeclIndex(n18, n3, n19)) > -1) {
            this.fSchemaGrammar.getElementDecl(n, this.fTempElementDecl);
            object = this.fTempElementDecl.datatypeValidator;
            ComplexTypeInfo complexTypeInfo3 = this.fSchemaGrammar.getElementComplexTypeInfo(n);
            if (complexTypeInfo3 != null && complexTypeInfo3 != complexTypeInfo2 || object != null && object != datatypeValidator) {
                bl3 = false;
                this.reportGenericSchemaError("duplicate element decl in the same scope : " + this.fStringPool.toString(n3));
            }
        }
        object = new QName(-1, n3, n2, n18);
        int n20 = -1;
        if (complexTypeInfo2 != null) {
            n20 = complexTypeInfo2.attlistHead;
        }
        int n21 = this.fSchemaGrammar.addElementDecl((QName)object, n19, n9, n6, n7, n20, datatypeValidator);
        if (DEBUGGING) {
            System.out.println("########elementIndex:" + n21 + " (" + this.fStringPool.toString(((QName)object).uri) + "," + this.fStringPool.toString(((QName)object).localpart) + ")" + " eltType:" + string5 + " contentSpecType:" + n6 + " SpecNodeIndex:" + n7 + " enclosingScope: " + n19 + " scopeDefined: " + n9 + "\n");
        }
        if (complexTypeInfo2 != null) {
            this.fSchemaGrammar.setElementComplexTypeInfo(n21, complexTypeInfo2);
        } else {
            this.fSchemaGrammar.setElementComplexTypeInfo(n21, complexTypeInfo2);
        }
        this.fSchemaGrammar.setElementFromAnotherSchemaURI(n21, string12);
        this.fSchemaGrammar.setElementDeclBlockSet(n21, n4);
        this.fSchemaGrammar.setElementDeclFinalSet(n21, n5);
        this.fSchemaGrammar.setElementDeclMiscFlags(n21, n10);
        this.fSchemaGrammar.setElementDeclEquivClassElementFullName(n21, string18);
        return object;
    }

    int getLocalPartIndex(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getLocalPart(String string) {
        int n = string.indexOf(":");
        String string2 = string;
        if (n > -1) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    int getPrefixIndex(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return this.fStringPool.addSymbol(string2);
    }

    String getPrefix(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n > -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    private void checkEquivClassOK(Element element, Element element2) {
    }

    /*
     * Unable to fully structure code
     */
    private Element getTopLevelComponentByName(String var1_1, String var2_2) throws Exception {
        var3_3 = XUtil.getFirstChildElement(this.fSchemaRootElement);
        if (var3_3 != null) ** GOTO lbl7
        return null;
lbl-1000:
        // 1 sources

        {
            if (var3_3.getNodeName().equals(var1_1) && var3_3.getAttribute("name").equals(var2_2)) {
                return var3_3;
            }
            var3_3 = XUtil.getNextSiblingElement(var3_3);
lbl7:
            // 2 sources

            ** while (var3_3 != null)
        }
lbl8:
        // 1 sources

        return null;
    }

    private boolean isTopLevel(Element element) {
        return element.getParentNode().getNodeName().endsWith("schema");
    }

    DatatypeValidator getTypeValidatorFromNS(String string, String string2) throws Exception {
        return this.getDatatypeValidator(string, string2);
    }

    ComplexTypeInfo getTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            ComplexTypeInfo complexTypeInfo = (ComplexTypeInfo)schemaGrammar.getComplexTypeRegistry().get(string + "," + string2);
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getTypeInfoFromNS");
        return null;
    }

    DatatypeValidator getElementDeclTypeValidatorFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            DatatypeValidator datatypeValidator = null;
            if (n > -1) {
                schemaGrammar.getElementDecl(n, this.fTempElementDecl);
                datatypeValidator = this.fTempElementDecl.datatypeValidator;
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return datatypeValidator;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getELementDeclTypeValidatorFromNS");
        return null;
    }

    ComplexTypeInfo getElementDeclTypeInfoFromNS(String string, String string2) throws Exception {
        Grammar grammar = this.fGrammarResolver.getGrammar(string);
        if (grammar != null && grammar instanceof SchemaGrammar) {
            SchemaGrammar schemaGrammar = (SchemaGrammar)grammar;
            int n = schemaGrammar.getElementDeclIndex(this.fStringPool.addSymbol(string), this.fStringPool.addSymbol(string2), -1);
            ComplexTypeInfo complexTypeInfo = null;
            if (n > -1) {
                complexTypeInfo = schemaGrammar.getElementComplexTypeInfo(n);
            } else {
                this.reportGenericSchemaError("could not find global element : '" + string2 + " in the SchemaGrammar " + string);
            }
            return complexTypeInfo;
        }
        this.reportGenericSchemaError("could not resolve URI : " + string + " to a SchemaGrammar in getElementDeclTypeInfoFromNS");
        return null;
    }

    private int traverseGroupDecl(Element element) throws Exception {
        String string = element.getAttribute("name");
        String string2 = element.getAttribute("ref");
        if (!string2.equals("")) {
            if (XUtil.getFirstChildElement(element) != null) {
                this.reportSchemaError(17, null);
            }
            String string3 = "";
            String string4 = string2;
            int n = string2.indexOf(":");
            if (n > 0) {
                string3 = string2.substring(0, n);
                string4 = string2.substring(n + 1);
            }
            int n2 = this.fStringPool.addSymbol(string4);
            String string5 = this.resolvePrefixToURI(string3);
            if (!string5.equals(this.fTargetNSURIString)) {
                return this.traverseGroupDeclFromAnotherSchema(string4, string5);
            }
            int n3 = -1;
            Element element2 = this.getTopLevelComponentByName("group", string4);
            if (element2 == null) {
                this.reportGenericSchemaError("Group " + string4 + " not found in the Schema");
                throw new Exception("Group " + string4 + " not found in the Schema");
            }
            n3 = this.traverseGroupDecl(element2);
            return n3;
        }
        boolean bl = true;
        if (this.fCurrentScope == -1) {
            bl = false;
        }
        Element element3 = XUtil.getFirstChildElement(element);
        while (element3 != null && element3.getNodeName().equals("annotation")) {
            element3 = XUtil.getNextSiblingElement(element3);
        }
        int n = 0;
        int n4 = 0;
        Object var8_13 = null;
        boolean bl2 = false;
        n4 = 5;
        n = 3;
        int n5 = -2;
        int n6 = -2;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        while (element3 != null) {
            int n7 = -2;
            bl3 = true;
            boolean bl6 = false;
            String string6 = element3.getNodeName();
            if (string6.equals("element")) {
                QName qName = this.traverseElementDecl(element3);
                n7 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl5 = true;
            } else if (string6.equals("group")) {
                n7 = this.traverseGroupDecl(element3);
                bl5 = true;
            } else if (string6.equals("all")) {
                n7 = this.traverseAll(element3);
                bl4 = true;
            } else if (string6.equals("choice")) {
                n7 = this.traverseChoice(element3);
                bl5 = true;
            } else if (string6.equals("sequence")) {
                n7 = this.traverseSequence(element3);
                bl5 = true;
            } else if (string6.equals("any")) {
                n7 = this.traverseAny(element3);
                bl5 = true;
            } else {
                bl6 = true;
                this.reportSchemaError(14, new Object[]{"group", string6});
            }
            if (!bl6) {
                n7 = this.expandContentModel(n7, element3);
            }
            if (bl5 && bl4) {
                this.reportSchemaError(14, new Object[]{"'all' needs to be 'the' only Child", string6});
            }
            if (n5 == -2) {
                n5 = n7;
            } else if (n6 == -2) {
                n6 = n7;
            } else {
                n5 = this.fSchemaGrammar.addContentSpecNode(n4, n5, n6, false);
                n6 = n7;
            }
            element3 = XUtil.getNextSiblingElement(element3);
        }
        if (bl3 && n6 != -2) {
            n5 = this.fSchemaGrammar.addContentSpecNode(n4, n5, n6, false);
        }
        return n5;
    }

    private int traverseGroupDeclFromAnotherSchema(String string, String string2) throws Exception {
        SchemaGrammar schemaGrammar = (SchemaGrammar)this.fGrammarResolver.getGrammar(string2);
        if (string2 == null || schemaGrammar == null || !(schemaGrammar instanceof SchemaGrammar)) {
            this.reportGenericSchemaError("!!Schema not found in #traverseGroupDeclFromAnotherSchema, schema uri: " + string2 + ", groupName: " + string);
            return -1;
        }
        Element element = (Element)schemaGrammar.topLevelGroupDecls.get(string);
        if (element == null) {
            this.reportGenericSchemaError("no group named \"" + string + "\" was defined in schema : " + string2);
            return -1;
        }
        NamespacesScope namespacesScope = this.fNamespacesScope;
        int n = this.fTargetNSURI;
        this.fTargetNSURI = this.fStringPool.addSymbol(schemaGrammar.getTargetNamespaceURI());
        this.fNamespacesScope = schemaGrammar.getNamespacesScope();
        boolean bl = true;
        if (this.fCurrentScope == -1) {
            bl = false;
        }
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n2 = 0;
        int n3 = 0;
        Object var11_11 = null;
        boolean bl2 = false;
        n3 = 5;
        n2 = 3;
        int n4 = -2;
        int n5 = -2;
        boolean bl3 = false;
        while (element2 != null) {
            int n6 = -2;
            bl3 = true;
            boolean bl4 = false;
            String string3 = element2.getNodeName();
            int n7 = this.fStringPool.addSymbol(string3);
            String string4 = element2.getAttribute("form");
            if (string3.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n6 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl4 = true;
            } else if (string3.equals("group")) {
                n6 = this.traverseGroupDecl(element2);
                bl4 = true;
            } else if (string3.equals("all")) {
                n6 = this.traverseAll(element2);
                bl4 = true;
            } else if (string3.equals("choice")) {
                n6 = this.traverseChoice(element2);
                bl4 = true;
            } else if (string3.equals("sequence")) {
                n6 = this.traverseSequence(element2);
                bl4 = true;
            } else if (string3.equals("any")) {
                n6 = this.traverseAny(element2);
                bl4 = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string3});
            }
            if (bl4) {
                n6 = this.expandContentModel(n6, element2);
            }
            if (n4 == -2) {
                n4 = n6;
            } else if (n5 == -2) {
                n5 = n6;
            } else {
                n4 = this.fSchemaGrammar.addContentSpecNode(n3, n4, n5, false);
                n5 = n6;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl3 && n5 != -2) {
            n4 = this.fSchemaGrammar.addContentSpecNode(n3, n4, n5, false);
        }
        this.fNamespacesScope = namespacesScope;
        this.fTargetNSURI = n;
        return n4;
    }

    int traverseSequence(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        n2 = 5;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            int n5 = -2;
            bl = true;
            boolean bl2 = false;
            String string = element2.getNodeName();
            if (string.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl2 = true;
            } else if (string.equals("group")) {
                n5 = this.traverseGroupDecl(element2);
                bl2 = true;
            } else if (string.equals("choice")) {
                n5 = this.traverseChoice(element2);
                bl2 = true;
            } else if (string.equals("sequence")) {
                n5 = this.traverseSequence(element2);
                bl2 = true;
            } else if (string.equals("any")) {
                n5 = this.traverseAny(element2);
                bl2 = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string});
            }
            if (bl2) {
                n5 = this.expandContentModel(n5, element2);
            }
            if (n3 == -2) {
                n3 = n5;
            } else if (n4 == -2) {
                n4 = n5;
            } else {
                n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                n4 = n5;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    int traverseChoice(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int n = 0;
        int n2 = 0;
        n2 = 4;
        n = 3;
        int n3 = -2;
        int n4 = -2;
        boolean bl = false;
        while (element2 != null) {
            int n5 = -2;
            bl = true;
            boolean bl2 = false;
            String string = element2.getNodeName();
            if (string.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n5 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl2 = true;
            } else if (string.equals("group")) {
                n5 = this.traverseGroupDecl(element2);
                bl2 = true;
            } else if (string.equals("choice")) {
                n5 = this.traverseChoice(element2);
                bl2 = true;
            } else if (string.equals("sequence")) {
                n5 = this.traverseSequence(element2);
                bl2 = true;
            } else if (string.equals("any")) {
                n5 = this.traverseAny(element2);
                bl2 = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string});
            }
            if (bl2) {
                n5 = this.expandContentModel(n5, element2);
            }
            if (n3 == -2) {
                n3 = n5;
            } else if (n4 == -2) {
                n4 = n5;
            } else {
                n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
                n4 = n5;
            }
            element2 = XUtil.getNextSiblingElement(element2);
        }
        if (bl && n4 != -2) {
            n3 = this.fSchemaGrammar.addContentSpecNode(n2, n3, n4, false);
        }
        return n3;
    }

    int traverseAll(Element element) throws Exception {
        Element element2 = XUtil.getFirstChildElement(element);
        while (element2 != null && element2.getNodeName().equals("annotation")) {
            element2 = XUtil.getNextSiblingElement(element2);
        }
        int[] nArray = null;
        int n = 0;
        int n2 = -2;
        while (element2 != null) {
            int n3 = -2;
            boolean bl = false;
            String string = element2.getNodeName();
            if (string.equals("element")) {
                QName qName = this.traverseElementDecl(element2);
                n3 = this.fSchemaGrammar.addContentSpecNode(0, qName.localpart, qName.uri, false);
                bl = true;
            } else if (string.equals("group")) {
                n3 = this.traverseGroupDecl(element2);
                bl = true;
            } else if (string.equals("choice")) {
                n3 = this.traverseChoice(element2);
                bl = true;
            } else if (string.equals("sequence")) {
                n3 = this.traverseSequence(element2);
                bl = true;
            } else if (string.equals("any")) {
                n3 = this.traverseAny(element2);
                bl = true;
            } else {
                this.reportSchemaError(14, new Object[]{"group", string});
            }
            if (bl) {
                n3 = this.expandContentModel(n3, element2);
            }
            try {
                nArray[n] = n3;
            }
            catch (NullPointerException nullPointerException) {
                nArray = new int[32];
                nArray[n] = n3;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                int[] nArray2 = new int[nArray.length * 2];
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                nArray[n] = n3;
            }
            ++n;
            element2 = XUtil.getNextSiblingElement(element2);
        }
        n2 = this.buildAllModel(nArray, n);
        return n2;
    }

    private int buildAllModel(int[] nArray, int n) throws Exception {
        if (n > 1) {
            XMLContentSpec xMLContentSpec = new XMLContentSpec();
            xMLContentSpec.type = 4;
            xMLContentSpec.value = -1;
            xMLContentSpec.otherValue = -1;
            int[] nArray2 = new int[n];
            System.arraycopy(nArray, 0, nArray2, 0, n);
            this.sort(nArray2, 0, n);
            int n2 = this.buildAllModel(nArray2, 0, xMLContentSpec);
            return n2;
        }
        if (n > 0) {
            return nArray[0];
        }
        return -1;
    }

    private int buildAllModel(int[] nArray, int n, XMLContentSpec xMLContentSpec) throws Exception {
        if (nArray.length - n == 2) {
            int n2 = this.createSeq(nArray);
            if (xMLContentSpec.value == -1) {
                xMLContentSpec.value = n2;
            } else {
                if (xMLContentSpec.otherValue != -1) {
                    xMLContentSpec.value = this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
                }
                xMLContentSpec.otherValue = n2;
            }
            this.swap(nArray, n, n + 1);
            n2 = this.createSeq(nArray);
            if (xMLContentSpec.value == -1) {
                xMLContentSpec.value = n2;
            } else {
                if (xMLContentSpec.otherValue != -1) {
                    xMLContentSpec.value = this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
                }
                xMLContentSpec.otherValue = n2;
            }
            return this.fSchemaGrammar.addContentSpecNode(xMLContentSpec.type, xMLContentSpec.value, xMLContentSpec.otherValue, false);
        }
        int n3 = n;
        while (n3 < nArray.length - 1) {
            xMLContentSpec.value = this.buildAllModel(nArray, n + 1, xMLContentSpec);
            xMLContentSpec.otherValue = -1;
            this.sort(nArray, n, nArray.length - n);
            this.shift(nArray, n, n3 + 1);
            ++n3;
        }
        int n4 = this.buildAllModel(nArray, n + 1, xMLContentSpec);
        this.sort(nArray, n, nArray.length - n);
        return n4;
    }

    private int createSeq(int[] nArray) throws Exception {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = 2;
        while (n3 < nArray.length) {
            n = this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
            n2 = nArray[n3];
            ++n3;
        }
        return this.fSchemaGrammar.addContentSpecNode(5, n, n2, false);
    }

    private void shift(int[] nArray, int n, int n2) {
        int n3 = nArray[n2];
        int n4 = n2;
        while (n4 > n) {
            nArray[n4] = nArray[n4 - 1];
            --n4;
        }
        nArray[n] = n3;
    }

    private void sort(int[] nArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2 - 1) {
            int n4 = n3;
            int n5 = n3 + 1;
            while (n5 < n + n2) {
                if (nArray[n5] < nArray[n4]) {
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 != n3) {
                int n6 = nArray[n3];
                nArray[n3] = nArray[n4];
                nArray[n4] = n6;
            }
            ++n3;
        }
    }

    private void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private int parseInt(String string) throws Exception {
        if (string.equals("*")) {
            return -1;
        }
        return Integer.parseInt(string);
    }

    private int parseSimpleDerivedBy(String string) throws Exception {
        if (string.equals("list")) {
            return 8;
        }
        if (string.equals("restriction")) {
            return 2;
        }
        this.reportGenericSchemaError("SimpleType: Invalid value for 'derivedBy'");
        return -1;
    }

    private int parseComplexDerivedBy(String string) throws Exception {
        if (string.equals("extension")) {
            return 1;
        }
        if (string.equals("restriction")) {
            return 2;
        }
        this.reportGenericSchemaError("ComplexType: Invalid value for 'derivedBy'");
        return -1;
    }

    private int parseSimpleFinal(String string) throws Exception {
        if (string.equals("#all")) {
            return 30;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction in set twice");
                continue;
            }
            if (string2.equals("list")) {
                if (n3 == 0) {
                    n3 = 8;
                    continue;
                }
                this.reportGenericSchemaError("list in set twice");
                continue;
            }
            this.reportGenericSchemaError("Invalid value (" + string + ")");
        }
        return n + n2 + n3 + n4;
    }

    private int parseComplexContent(String string) throws Exception {
        if (string.equals("empty")) {
            return 0;
        }
        if (string.equals("elementOnly")) {
            return 3;
        }
        if (string.equals("textOnly")) {
            return 4;
        }
        if (string.equals("mixed")) {
            return 2;
        }
        this.reportGenericSchemaError("Invalid value for content");
        return -1;
    }

    private int parseDerivationSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 7;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseBlockSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("equivclass")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'equivClass' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private int parseFinalSet(String string) throws Exception {
        if (string.equals("#all")) {
            return 47;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("equivclass")) {
                if (n == 0) {
                    n = 32;
                    continue;
                }
                this.reportGenericSchemaError("'equivClass' already in set");
                continue;
            }
            if (string2.equals("extension")) {
                if (n == 0) {
                    n = 1;
                    continue;
                }
                this.reportGenericSchemaError("extension already in set");
                continue;
            }
            if (string2.equals("list")) {
                if (n == 0) {
                    n = 8;
                    continue;
                }
                this.reportGenericSchemaError("'list' already in set");
                continue;
            }
            if (string2.equals("restriction")) {
                if (n2 == 0) {
                    n2 = 2;
                    continue;
                }
                this.reportGenericSchemaError("restriction already in set");
                continue;
            }
            this.reportGenericSchemaError("Invalid final value (" + string + ")");
        }
        return n + n2 + n3;
    }

    private void reportGenericSchemaError(String string) throws Exception {
        if (this.fErrorReporter == null) {
            System.err.println("__TraverseSchemaError__ : " + string);
        } else {
            this.reportSchemaError(23, new Object[]{string});
        }
    }

    private void reportSchemaError(int n, Object[] objectArray) throws Exception {
        if (this.fErrorReporter == null) {
            System.out.println("__TraverseSchemaError__ : " + SchemaMessageProvider.fgMessageKeys[n]);
            int n2 = 0;
            while (n2 < objectArray.length) {
                System.out.println((String)objectArray[n2]);
                ++n2;
            }
        } else {
            this.fErrorReporter.reportError(this.fErrorReporter.getLocator(), "http://www.w3.org/TR/xml-schema-1", n, 0, objectArray, 1);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Error: Usage java TraverseSchema yourFile.xsd");
            System.exit(0);
        }
        DOMParser dOMParser = new DOMParser(){

            public void ignorableWhitespace(char[] cArray, int n, int n2) {
            }

            public void ignorableWhitespace(int n) {
            }
        };
        dOMParser.setEntityResolver(new Resolver());
        dOMParser.setErrorHandler(new ErrorHandler());
        try {
            dOMParser.setFeature("http://xml.org/sax/features/validation", false);
            dOMParser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
        }
        catch (SAXNotRecognizedException sAXNotRecognizedException) {
            sAXNotRecognizedException.printStackTrace();
        }
        catch (SAXNotSupportedException sAXNotSupportedException) {
            sAXNotSupportedException.printStackTrace();
        }
        try {
            dOMParser.parse(stringArray[0]);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
        }
        Document document = dOMParser.getDocument();
        OutputFormat outputFormat = new OutputFormat(document);
        StringWriter stringWriter = new StringWriter();
        XMLSerializer xMLSerializer = new XMLSerializer(stringWriter, outputFormat);
        TraverseSchema traverseSchema = null;
        try {
            Element element = document.getDocumentElement();
            traverseSchema = new TraverseSchema(element, new StringPool(), new SchemaGrammar(), new GrammarResolverImpl());
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
        dOMParser.getDocument();
    }

    static class ErrorHandler
    implements org.xml.sax.ErrorHandler {
        ErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("[Warning] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void error(SAXParseException sAXParseException) {
            System.err.println("[Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            System.err.println("[Fatal Error] " + this.getLocationString(sAXParseException) + ": " + sAXParseException.getMessage());
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }

    static class Resolver
    implements EntityResolver {
        private static final String[] SYSTEM = new String[]{"http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/structures.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/datatypes.dtd", "http://www.w3.org/TR/2000/WD-xmlschema-1-20000407/versionInfo.ent"};
        private static final String[] PATH = new String[]{"structures.dtd", "datatypes.dtd", "versionInfo.ent"};

        Resolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws IOException {
            int n = 0;
            while (n < SYSTEM.length) {
                if (string2.equals(SYSTEM[n])) {
                    InputSource inputSource = new InputSource(this.getClass().getResourceAsStream(PATH[n]));
                    inputSource.setPublicId(string);
                    inputSource.setSystemId(string2);
                    return inputSource;
                }
                ++n;
            }
            return null;
        }
    }

    public class ComplexTypeInfo {
        public String typeName;
        public DatatypeValidator baseDataTypeValidator;
        public ComplexTypeInfo baseComplexTypeInfo;
        public int derivedBy = 0;
        public int blockSet = 0;
        public int finalSet = 0;
        public boolean isAbstract = false;
        public int scopeDefined = -1;
        public int contentType;
        public int contentSpecHandle = -1;
        public int templateElementIndex = -1;
        public int attlistHead = -1;
        public DatatypeValidator datatypeValidator;
    }
}

